/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.model.document;

import gov.epa.cdx.model.commons.BaseVO;
import gov.epa.cdx.model.dataflow.DataflowTypeVO;
import gov.epa.cdx.model.document.DocumentInterface;
import gov.epa.cdx.model.document.DocumentStatusVO;
import gov.epa.cdx.model.document.DocumentType;

public class DocumentVO
extends BaseVO
implements DocumentInterface {
    private static final long serialVersionUID = 1L;
    private String ID;
    private String name;
    private DocumentType documentType;
    private DataflowTypeVO dataFlowType;
    private byte[] data;
    private int isCompressed = 0;
    private DocumentStatusVO status;

    public DocumentVO(String ID, String name, DocumentType documentType, DataflowTypeVO dataFlowType, byte[] data) {
        this.ID = ID;
        this.name = name;
        this.documentType = documentType;
        this.dataFlowType = dataFlowType;
        this.data = data;
        this.status = new DocumentStatusVO("CREATED");
    }

    public DocumentVO(String ID, String name, DocumentType documentType, DataflowTypeVO dataFlowType) {
        this.ID = ID;
        this.name = name;
        this.documentType = documentType;
        this.dataFlowType = dataFlowType;
        this.status = new DocumentStatusVO("CREATED");
    }

    public DocumentVO(String ID, String name, String documentType, String dataFlowType, byte[] data) {
        this.ID = ID;
        this.name = name;
        this.setDocumentType(documentType);
        this.setDataFlowType(dataFlowType);
        this.data = data;
        this.status = new DocumentStatusVO("CREATED");
    }

    public DocumentVO() {
        this.status = new DocumentStatusVO("CREATED");
    }

    public byte[] getData() {
        return this.data;
    }

    public DataflowTypeVO getDataflowTypeVO() {
        return this.dataFlowType;
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public String getID() {
        return this.ID;
    }

    public String getName() {
        return this.name;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setDataFlowType(DataflowTypeVO dataFlowType) {
        this.dataFlowType = dataFlowType;
    }

    public void setDataFlowType(String type) {
        this.dataFlowType = new DataflowTypeVO(type);
    }

    public void setDocumentType(DocumentType documentType) {
        this.documentType = documentType;
    }

    public void setDocumentType(String type) {
        this.documentType = DocumentType.getDocumentTypeById(type);
    }

    public void setID(String ID) {
        this.ID = ID;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DocumentStatusVO getStatus() {
        return this.status;
    }

    public void setStatus(DocumentStatusVO status) {
        this.status = status;
    }

    public int getIsCompressed() {
        return this.isCompressed;
    }

    public void setIsCompressed(int isCompressed) {
        this.isCompressed = isCompressed;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Name: ");
        if (this.getName() != null) {
            buffer.append(this.getName());
        } else {
            buffer.append("null");
        }
        buffer.append(" Type: ");
        if (this.getDocumentType() != null) {
            buffer.append(this.getDocumentType().toString());
        } else {
            buffer.append("null");
        }
        buffer.append(" Dataflow: ");
        if (this.getDataflowTypeVO().getDataflowType() != null) {
            buffer.append(this.getDataflowTypeVO().getDataflowType().toString());
        } else {
            buffer.append("null");
        }
        buffer.append(" Size: ");
        if (this.getData() != null) {
            buffer.append(this.getData().length);
        } else {
            buffer.append("null");
        }
        buffer.append(" bytes. ");
        buffer.append(" Id: ");
        if (this.getID() != null) {
            buffer.append(this.getID());
        } else {
            buffer.append("null");
        }
        return buffer.toString();
    }
}

