/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.model.scheduler;

import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.model.commons.BaseVO;
import gov.epa.cdx.model.node.NodeKey;
import gov.epa.cdx.model.scheduler.TaskStatus;
import gov.epa.cdx.model.scheduler.TaskTypeVO;
import gov.epa.cdx.model.transaction.TransactionVO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TaskVO
extends BaseVO {
    private static final long serialVersionUID = 1L;
    protected static LogInterface log = LogFactory.getLog((String)(class$gov$epa$cdx$model$scheduler$TaskVO == null ? (class$gov$epa$cdx$model$scheduler$TaskVO = TaskVO.class$("gov.epa.cdx.model.scheduler.TaskVO")) : class$gov$epa$cdx$model$scheduler$TaskVO).getName());
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd_HH:mm:ss:SSS");
    private String taskID = null;
    private TaskTypeVO taskType = null;
    private long taskStartTime = 0L;
    private TaskStatus taskStatus = null;
    private String taskDescription = null;
    private Map taskParameters = null;
    private HashMap taskNodesDetails = new HashMap();
    static /* synthetic */ Class class$gov$epa$cdx$model$scheduler$TaskVO;

    public TaskVO(String taskID, TaskTypeVO taskType) {
        this.taskID = taskID;
        this.taskType = taskType;
    }

    public TaskVO(String taskID, String taskDescription, TaskTypeVO taskType, long taskStartTime, Map taskParameters, Collection taskNodeKeys) {
        this(taskID, taskDescription, taskType, taskStartTime, TaskStatus.NotStarted, taskParameters, taskNodeKeys);
    }

    public TaskVO(String taskID, String taskDescription, TaskTypeVO taskType, long taskStartTime, TaskStatus taskStatus, Map taskParameters, Collection taskNodeKeys) {
        this.taskID = taskID;
        this.taskDescription = taskDescription;
        this.taskType = taskType;
        this.taskStartTime = taskStartTime;
        this.taskStatus = taskStatus;
        this.taskParameters = taskParameters;
        this.convertNodeKeysToNodesDetails(taskNodeKeys);
    }

    public TaskVO(String taskID, String taskDescription, TaskTypeVO taskType, long taskStartTime, Map taskParameters, Map taskNodeKeyTransactionDetails) {
        this(taskID, taskDescription, taskType, taskStartTime, TaskStatus.NotStarted, taskParameters, taskNodeKeyTransactionDetails);
    }

    public TaskVO(String taskID, String taskDescription, TaskTypeVO taskType, long taskStartTime, TaskStatus taskStatus, Map taskParameters, Map taskNodeKeyTransactionDetails) {
        this.taskID = taskID;
        this.taskDescription = taskDescription;
        this.taskType = taskType;
        this.taskStartTime = taskStartTime;
        this.taskStatus = taskStatus;
        this.taskParameters = taskParameters;
        this.taskNodesDetails = new HashMap(taskNodeKeyTransactionDetails);
    }

    public void setTaskID(String taskID) {
        this.taskID = taskID;
    }

    public String getTaskID() {
        return this.taskID;
    }

    public String getTaskDescription() {
        return this.taskDescription;
    }

    public void setTaskDescription(String taskDescription) {
        this.taskDescription = taskDescription;
    }

    public void setStatus(TaskStatus taskStatus) {
        this.taskStatus = taskStatus;
    }

    public TaskStatus getStatus() {
        return this.taskStatus;
    }

    public long getTaskStartTime() {
        return this.taskStartTime;
    }

    public void setTaskStartTime(long startTime) {
        this.taskStartTime = startTime;
    }

    public Map getTaskParameters() {
        return this.taskParameters;
    }

    public void setTaskParameters(Map taskParameters) {
        this.taskParameters = taskParameters;
    }

    public TaskTypeVO getTaskType() {
        return this.taskType;
    }

    public void setTaskType(TaskTypeVO taskType) {
        this.taskType = taskType;
    }

    public void setTaskTransaction(NodeKey nodeKey, TransactionVO trVO) {
        if (this.taskNodesDetails == null) {
            this.taskNodesDetails = new HashMap();
        }
        this.taskNodesDetails.put(nodeKey, trVO);
    }

    public TransactionVO getTaskTransaction(NodeKey nodeKey) {
        return (TransactionVO)this.taskNodesDetails.get(nodeKey);
    }

    public Collection getTaskNodeKeys() {
        ArrayList<NodeKey> keys = new ArrayList<NodeKey>();
        NodeKey item = null;
        Iterator iter = this.taskNodesDetails.keySet().iterator();
        while (iter.hasNext()) {
            item = (NodeKey)iter.next();
            keys.add(item);
        }
        return keys;
    }

    public void setTaskNodeKeys(Collection taskNodeKeys) {
        this.convertNodeKeysToNodesDetails(taskNodeKeys);
    }

    public Collection getTransactions() {
        if (this.taskNodesDetails == null) {
            return null;
        }
        return this.taskNodesDetails.values();
    }

    private void convertNodeKeysToNodesDetails(Collection taskNodeKeys) {
        NodeKey nodeKey = null;
        if (this.taskNodesDetails == null) {
            this.taskNodesDetails = new HashMap();
        }
        Iterator iter = taskNodeKeys.iterator();
        while (iter.hasNext()) {
            nodeKey = (NodeKey)iter.next();
            if (this.taskNodesDetails.containsKey(nodeKey)) continue;
            this.taskNodesDetails.put(nodeKey, null);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        StringBuffer tmp = new StringBuffer();
        TransactionVO trVO = null;
        NodeKey nodeKey = null;
        try {
            sb.append("TaskID:" + this.taskID + "\n");
            sb.append("CDXTaskTypes:" + this.taskType.toString() + "\n");
            sb.append("TaskDescription:" + this.taskDescription + "\n");
            sb.append("TaskStatus:" + this.taskStatus + "\n");
            sb.append("TaskStartTime:" + formatter.format(new Date(this.taskStartTime)) + "\n");
            sb.append("** NodeKeys | Transaction ID | Transaction Status **\n");
            Iterator iter = this.taskNodesDetails.keySet().iterator();
            while (iter.hasNext()) {
                nodeKey = (NodeKey)iter.next();
                if (nodeKey != null) {
                    sb.append(nodeKey.toString());
                    trVO = (TransactionVO)this.taskNodesDetails.get(nodeKey);
                    if (trVO != null) {
                        sb.append(" | " + trVO.getTransactionID());
                        sb.append(" | " + trVO.getStatus());
                    }
                }
                sb.append("\n*******************************\n");
            }
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            return sb.toString();
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

