/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.model.transaction;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;

public final class Status
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private static HashMap table = new HashMap();
    public static final Status RECEIVED = new Status("RECEIVED");
    public static final Status PENDING = new Status("PENDING");
    public static final Status ACCEPTED = new Status("ACCEPTED");
    public static final Status PROCESSED = new Status("PROCESSED");
    public static final Status COMPLETED = new Status("COMPLETED");
    public static final Status RESCHEDULED = new Status("RESCHEDULED");
    public static final Status FAILED = new Status("FAILED");
    public static final Status REPORT = new Status("REPORT");
    public static final Status HEADER = new Status("HEADER");
    public static final Status NOTIFY = new Status("NOTIFY");
    public static final Status NOT_VALID_TRANSACTION = new Status("INVALID TRANSACTION");
    public static final Status UNKNOWN = new Status("Unknown");

    public boolean equals(Object obj) {
        Status stat = (Status)obj;
        return this.toString().equalsIgnoreCase(stat.toString());
    }

    private Status(String anID) {
        this.id = anID;
        table.put(anID, this);
    }

    public static Status getStatusById(String statusId) {
        Status status = (Status)table.get(statusId.toUpperCase());
        if (status != null) {
            return status;
        }
        return UNKNOWN;
    }

    public static void isValid(String status) throws CDXException {
        if (!table.containsValue(new Status(status.toUpperCase()))) {
            throw new CDXException(CDXErrorCode.INVALID_STATUS_FOR_NOTIFICATION);
        }
    }

    public String toString() {
        return this.id;
    }

    private Object readResolve() throws ObjectStreamException {
        return Status.getStatusById(this.id);
    }
}

