/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.PreorderNodeIterator;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.VariableTable;

public class NodeTransformer {
    protected ObjArray loops;
    protected ObjArray loopEnds;
    protected boolean inFunction;
    protected IRFactory irFactory;

    public NodeTransformer newInstance() {
        return new NodeTransformer();
    }

    public IRFactory createIRFactory(TokenStream ts, Scriptable scope) {
        return new IRFactory(ts, scope);
    }

    /*
     * WARNING - void declaration
     */
    public Node transform(Node tree, Node enclosing, TokenStream ts, Scriptable scope) {
        Node node;
        this.loops = new ObjArray();
        this.loopEnds = new ObjArray();
        boolean bl = this.inFunction = tree.getType() == 110;
        if (!this.inFunction) {
            this.addVariables(tree, this.getVariableTable(tree));
        }
        this.irFactory = this.createIRFactory(ts, scope);
        boolean hasFinally = false;
        PreorderNodeIterator iterator = tree.getPreorderIterator();
        block22: while ((node = iterator.nextNode()) != null) {
            void var7_7;
            int type = var7_7.getType();
            block0 : switch (type) {
                case 110: {
                    if (var7_7 == tree) {
                        VariableTable vars = this.getVariableTable(tree);
                        this.addVariables(tree, vars);
                        Node stmts = var7_7.getLastChild();
                        Node lastStmt = stmts.getLastChild();
                        if (lastStmt != null && lastStmt.getType() == 5) continue block22;
                        stmts.addChildToBack(new Node(5));
                        break;
                    }
                    FunctionNode fnNode = (FunctionNode)var7_7.getProp(5);
                    if (this.inFunction) {
                        ((FunctionNode)tree).setRequiresActivation(true);
                        fnNode.setCheckThis(true);
                    }
                    this.addParameters(fnNode);
                    NodeTransformer inner = this.newInstance();
                    fnNode = (FunctionNode)inner.transform(fnNode, tree, ts, scope);
                    var7_7.putProp(5, fnNode);
                    ObjArray fns = (ObjArray)tree.getProp(5);
                    if (fns == null) {
                        fns = new ObjArray();
                        tree.putProp(5, fns);
                    }
                    fns.add(fnNode);
                    break;
                }
                case 136: {
                    Node child = var7_7.getFirstChild();
                    var7_7.removeChild(child);
                    String id = child.getString();
                    int i = this.loops.size() - 1;
                    while (i >= 0) {
                        String otherId;
                        Node n = (Node)this.loops.get(i);
                        if (n.getType() == 136 && id.equals(otherId = (String)n.getProp(20))) {
                            String message = Context.getMessage1("msg.dup.label", id);
                            this.reportMessage(Context.getContext(), message, (Node)var7_7, tree, true, scope);
                            break block0;
                        }
                        --i;
                    }
                    var7_7.putProp(20, id);
                    Node breakTarget = new Node(137);
                    Node parent = iterator.getCurrentParent();
                    Node next = var7_7.getNext();
                    while (next != null && (next.getType() == 136 || next.getType() == 137)) {
                        next = next.getNext();
                    }
                    if (next == null) continue block22;
                    parent.addChildAfter(breakTarget, next);
                    var7_7.putProp(2, breakTarget);
                    if (next.getType() == 138) {
                        var7_7.putProp(3, next.getProp(3));
                    }
                    this.loops.push(var7_7);
                    this.loopEnds.push(breakTarget);
                    break;
                }
                case 115: {
                    Node breakTarget = new Node(137);
                    Node parent = iterator.getCurrentParent();
                    parent.addChildAfter(breakTarget, (Node)var7_7);
                    Node sib = var7_7;
                    Node child = var7_7.getFirstChild().next;
                    while (child != null) {
                        Node next = child.next;
                        var7_7.removeChild(child);
                        parent.addChildAfter(child, sib);
                        sib = child;
                        child = next;
                    }
                    var7_7.putProp(2, breakTarget);
                    this.loops.push(var7_7);
                    this.loopEnds.push(breakTarget);
                    var7_7.putProp(13, new ObjArray());
                    break;
                }
                case 116: 
                case 117: {
                    Node sw = (Node)this.loops.peek();
                    if (type == 116) {
                        ObjArray cases = (ObjArray)sw.getProp(13);
                        cases.add(var7_7);
                        break;
                    }
                    sw.putProp(14, var7_7);
                    break;
                }
                case 144: {
                    int localCount = tree.getIntProp(22, 0);
                    tree.putIntProp(22, localCount + 1);
                    break;
                }
                case 138: {
                    this.loops.push(var7_7);
                    this.loopEnds.push(var7_7.getProp(2));
                    break;
                }
                case 124: {
                    if (this.inFunction) {
                        ((FunctionNode)tree).setRequiresActivation(true);
                    }
                    this.loops.push(var7_7);
                    Node leave = var7_7.getNext();
                    if (leave.getType() != 4) {
                        throw new RuntimeException("Unexpected tree");
                    }
                    this.loopEnds.push(leave);
                    break;
                }
                case 75: {
                    Node finallytarget = (Node)var7_7.getProp(21);
                    if (finallytarget != null) {
                        hasFinally = true;
                        this.loops.push(var7_7);
                        this.loopEnds.push(finallytarget);
                    }
                    int localCount = tree.getIntProp(22, 0);
                    tree.putIntProp(22, localCount + 1);
                    break;
                }
                case 4: 
                case 137: {
                    if (this.loopEnds.isEmpty() || this.loopEnds.peek() != var7_7) continue block22;
                    this.loopEnds.pop();
                    this.loops.pop();
                    break;
                }
                case 5: {
                    if (!hasFinally) continue block22;
                    int i = this.loops.size() - 1;
                    while (i >= 0) {
                        Node n = (Node)this.loops.get(i);
                        int elemtype = n.getType();
                        if (elemtype == 75) {
                            Node jsrnode = new Node(143);
                            Object jsrtarget = n.getProp(21);
                            jsrnode.putProp(1, jsrtarget);
                            iterator.addBeforeCurrent(jsrnode);
                        } else if (elemtype == 124) {
                            Node leave = new Node(4);
                            iterator.addBeforeCurrent(leave);
                        }
                        --i;
                    }
                    continue block22;
                }
                case 121: 
                case 122: {
                    Node target;
                    Node loop = null;
                    boolean labelled = var7_7.hasChildren();
                    String id = null;
                    if (labelled) {
                        Node child = var7_7.getFirstChild();
                        id = child.getString();
                        var7_7.removeChild(child);
                    }
                    int i = this.loops.size() - 1;
                    while (i >= 0) {
                        Node n = (Node)this.loops.get(i);
                        int elemtype = n.getType();
                        if (elemtype == 124) {
                            Node leave = new Node(4);
                            iterator.addBeforeCurrent(leave);
                        } else if (elemtype == 75) {
                            Node jsrFinally = new Node(143);
                            Object jsrTarget = n.getProp(21);
                            jsrFinally.putProp(1, jsrTarget);
                            iterator.addBeforeCurrent(jsrFinally);
                        } else {
                            if (!labelled && (elemtype == 138 || elemtype == 115 && type == 121)) {
                                loop = n;
                                break;
                            }
                            if (labelled && elemtype == 136 && id.equals((String)n.getProp(20))) {
                                loop = n;
                                break;
                            }
                        }
                        --i;
                    }
                    int propType = type == 121 ? 2 : 3;
                    Node node2 = target = loop == null ? null : (Node)loop.getProp(propType);
                    if (loop == null || target == null) {
                        String message;
                        if (!labelled) {
                            message = type == 122 ? Context.getMessage("msg.continue.outside", null) : Context.getMessage("msg.bad.break", null);
                        } else if (loop != null) {
                            message = Context.getMessage0("msg.continue.nonloop");
                        } else {
                            Object[] errArgs = new Object[]{id};
                            message = Context.getMessage("msg.undef.label", errArgs);
                        }
                        this.reportMessage(Context.getContext(), message, (Node)var7_7, tree, true, scope);
                        var7_7.setType(128);
                        break;
                    }
                    var7_7.setType(6);
                    var7_7.putProp(1, target);
                    break;
                }
                case 43: {
                    if (this.isSpecialCallName(tree, (Node)var7_7)) {
                        var7_7.putProp(30, Boolean.TRUE);
                    }
                    this.visitCall((Node)var7_7, tree);
                    break;
                }
                case 30: {
                    if (this.isSpecialCallName(tree, (Node)var7_7)) {
                        var7_7.putProp(30, Boolean.TRUE);
                    }
                    this.visitNew((Node)var7_7, tree);
                    break;
                }
                case 108: {
                    Node right = var7_7.getLastChild();
                    right.setType(46);
                    break;
                }
                case 140: {
                    var7_7.setType(this.inFunction ? 57 : 2);
                    break;
                }
                case 56: {
                    ObjArray regexps = (ObjArray)tree.getProp(12);
                    if (regexps == null) {
                        regexps = new ObjArray();
                        tree.putProp(12, regexps);
                    }
                    regexps.add(var7_7);
                    Node n = new Node(56);
                    iterator.replaceCurrent(n);
                    n.putProp(12, var7_7);
                    break;
                }
                case 123: {
                    Node result = new Node(133);
                    Node cursor = var7_7.getFirstChild();
                    while (cursor != null) {
                        Node n = cursor;
                        cursor = cursor.getNext();
                        if (!n.hasChildren()) continue;
                        Node init = n.getFirstChild();
                        n.removeChild(init);
                        Node asn = (Node)this.irFactory.createAssignment(128, n, init, null, false);
                        Node pop = new Node(57, asn, var7_7.getLineno());
                        result.addChildToBack(pop);
                    }
                    iterator.replaceCurrent(result);
                    break;
                }
                case 10: 
                case 31: {
                    VariableTable vars;
                    Node bind;
                    if (!this.inFunction || this.inWithStatement() || (bind = var7_7.getFirstChild()) == null || bind.getType() != 61) continue block22;
                    String name = bind.getString();
                    Context cx = Context.getCurrentContext();
                    if (cx != null && cx.isActivationNeeded(name)) {
                        ((FunctionNode)tree).setRequiresActivation(true);
                    }
                    if (!(vars = this.getVariableTable(tree)).hasVariable(name)) break;
                    if (type == 10) {
                        var7_7.setType(73);
                        bind.setType(46);
                        break;
                    }
                    Node n = new Node(109, 51);
                    iterator.replaceCurrent(n);
                    break;
                }
                case 39: {
                    if (!this.inFunction) break;
                    Node n = var7_7.getFirstChild().getNext();
                    String name = n == null ? "" : n.getString();
                    Context cx = Context.getCurrentContext();
                    if ((cx == null || !cx.isActivationNeeded(name)) && (!name.equals("length") || Context.getContext().getLanguageVersion() != 120)) continue block22;
                    ((FunctionNode)tree).setRequiresActivation(true);
                    break;
                }
                case 44: {
                    VariableTable vars;
                    if (!this.inFunction || this.inWithStatement()) continue block22;
                    String name = var7_7.getString();
                    Context cx = Context.getCurrentContext();
                    if (cx != null && cx.isActivationNeeded(name)) {
                        ((FunctionNode)tree).setRequiresActivation(true);
                    }
                    if (!(vars = this.getVariableTable(tree)).hasVariable(name)) break;
                    var7_7.setType(72);
                    break;
                }
            }
        }
        return tree;
    }

    /*
     * WARNING - void declaration
     */
    protected void addVariables(Node tree, VariableTable vars) {
        String name;
        Node node;
        boolean inFunction = tree.getType() == 110;
        PreorderNodeIterator iterator = tree.getPreorderIterator();
        ObjToIntMap fNames = null;
        while ((node = iterator.nextNode()) != null) {
            void var6_6;
            int nodeType = var6_6.getType();
            if (inFunction && nodeType == 110 && var6_6 != tree && ((FunctionNode)var6_6.getProp(5)).getFunctionType() == 3) {
                name = var6_6.getString();
                if (name == null) continue;
                vars.removeLocal(name);
                if (fNames == null) {
                    fNames = new ObjToIntMap();
                }
                fNames.put(name, 0);
            }
            if (nodeType != 123) continue;
            Node cursor = var6_6.getFirstChild();
            while (cursor != null) {
                String name2 = cursor.getString();
                if (fNames == null || !fNames.has(name2)) {
                    vars.addLocal(name2, this.createVariableObject(name2, false));
                }
                cursor = cursor.getNext();
            }
        }
        if (inFunction) {
            FunctionNode fn = (FunctionNode)tree;
            name = fn.getFunctionName();
            if (fn.getFunctionType() == 2 && name != null && name.length() > 0 && vars.hasVariable(name)) {
                vars.addLocal(name, this.createVariableObject(name, false));
                Node block = tree.getLastChild();
                Node setFn = new Node(57, new Node(73, Node.newString(name), new Node(109, 87)));
                block.addChildrenToFront(setFn);
            }
        }
    }

    protected void addParameters(FunctionNode fnNode) {
        VariableTable vars = fnNode.getVariableTable();
        Node args = fnNode.getFirstChild();
        if (args.getType() == 94 && vars.getParameterCount() == 0) {
            Node cursor = args.getFirstChild();
            while (cursor != null) {
                String arg = cursor.getString();
                vars.addParameter(arg, this.createVariableObject(arg, true));
                cursor = cursor.getNext();
            }
        }
    }

    protected Object createVariableObject(String name, boolean isParameter) {
        return name;
    }

    protected void visitNew(Node node, Node tree) {
    }

    protected void visitCall(Node node, Node tree) {
        Node left = node.getFirstChild();
        int argCount = 0;
        Node arg = left.getNext();
        while (arg != null) {
            arg = arg.getNext();
            ++argCount;
        }
        boolean addGetThis = false;
        if (left.getType() == 44) {
            VariableTable vars = this.getVariableTable(tree);
            String name = left.getString();
            if (this.inFunction && vars.hasVariable(name) && !this.inWithStatement()) {
                left.setType(72);
            } else {
                node.removeChild(left);
                left.setType(71);
                Node str = left.cloneNode();
                str.setType(46);
                Node getProp = new Node(39, left, str);
                node.addChildToFront(getProp);
                left = getProp;
                boolean bl = addGetThis = this.inWithStatement() || !this.inFunction;
            }
        }
        if (left.getType() != 39 && left.getType() != 41) {
            node.removeChild(left);
            Node tmp = this.irFactory.createNewTemp(left);
            Node use = this.irFactory.createUseTemp(tmp);
            use.putProp(6, tmp);
            Node parent = new Node(141, use);
            node.addChildToFront(parent);
            node.addChildToFront(tmp);
            return;
        }
        Node leftLeft = left.getFirstChild();
        left.removeChild(leftLeft);
        Node tmp = this.irFactory.createNewTemp(leftLeft);
        left.addChildToFront(tmp);
        Node use = this.irFactory.createUseTemp(tmp);
        use.putProp(6, tmp);
        if (addGetThis) {
            use = new Node(68, use);
        }
        node.addChildAfter(use, left);
    }

    protected boolean inWithStatement() {
        int i = this.loops.size() - 1;
        while (i >= 0) {
            Node n = (Node)this.loops.get(i);
            if (n.getType() == 124) {
                return true;
            }
            --i;
        }
        return false;
    }

    private boolean isSpecialCallName(Node tree, Node node) {
        Node left = node.getFirstChild();
        boolean isSpecial = false;
        if (left.getType() == 44) {
            String name = left.getString();
            isSpecial = name.equals("eval") || name.equals("With");
        } else if (left.getType() == 39) {
            String name = left.getLastChild().getString();
            isSpecial = name.equals("exec");
        }
        if (isSpecial) {
            if (this.inFunction) {
                ((FunctionNode)tree).setRequiresActivation(true);
            }
            return true;
        }
        return false;
    }

    protected VariableTable createVariableTable() {
        return new VariableTable();
    }

    protected VariableTable getVariableTable(Node tree) {
        if (this.inFunction) {
            return ((FunctionNode)tree).getVariableTable();
        }
        VariableTable result = (VariableTable)tree.getProp(10);
        if (result == null) {
            result = this.createVariableTable();
            tree.putProp(10, result);
        }
        return result;
    }

    protected void reportMessage(Context cx, String msg, Node stmt, Node tree, boolean isError, Scriptable scope) {
        Object prop;
        int lineno = stmt.getLineno();
        Object object = prop = tree == null ? null : tree.getProp(16);
        if (isError) {
            if (scope != null) {
                throw NativeGlobal.constructError(cx, "SyntaxError", msg, scope, (String)prop, lineno, 0, null);
            }
            Context.reportError(msg, (String)prop, lineno, null, 0);
        } else {
            Context.reportWarning(msg, (String)prop, lineno, null, 0);
        }
    }
}

