/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.axis.dataflow.server;

import gov.epa.cdx.axis.fault.FaultHandler;
import gov.epa.cdx.axis.v10.impl.DocumentConverter;
import gov.epa.cdx.axis.v10.impl.NetworkNodeBindingImpl;
import gov.epa.cdx.axis.v10.vo.NodeDocument;
import gov.epa.cdx.axis.v10.vo.holders.ArrayofDocHolder;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.ejbs.sb.dataflow.DataflowDocumentExchangeService;
import gov.epa.cdx.ejbs.sb.dataflow.DataflowDocumentExchangeServiceUtil;
import gov.epa.cdx.infrastructure.auditor.Audit;
import gov.epa.cdx.infrastructure.document.DocumentMgr;
import gov.epa.cdx.model.dataflow.DataflowTypeVO;
import gov.epa.cdx.model.document.DocumentInterface;
import gov.epa.cdx.model.document.DocumentList;
import gov.epa.cdx.model.document.DocumentType;
import gov.epa.cdx.model.document.DocumentVO;
import gov.epa.cdx.model.node.NodeVersion;
import gov.epa.cdx.model.security.AuthTokenVO;
import gov.epa.cdx.model.transaction.TransactionVO;
import java.rmi.RemoteException;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;

public class DataflowDocumentServicesBindingImpl
extends NetworkNodeBindingImpl {
    private static LogInterface log = LogFactory.getLog((String)(class$gov$epa$cdx$axis$dataflow$server$DataflowDocumentServicesBindingImpl == null ? (class$gov$epa$cdx$axis$dataflow$server$DataflowDocumentServicesBindingImpl = DataflowDocumentServicesBindingImpl.class$("gov.epa.cdx.axis.dataflow.server.DataflowDocumentServicesBindingImpl")) : class$gov$epa$cdx$axis$dataflow$server$DataflowDocumentServicesBindingImpl).getName());
    protected static Audit audit = new Audit((class$gov$epa$cdx$axis$dataflow$server$DataflowServicesBindingImpl == null ? (class$gov$epa$cdx$axis$dataflow$server$DataflowServicesBindingImpl = DataflowDocumentServicesBindingImpl.class$("gov.epa.cdx.axis.dataflow.server.DataflowServicesBindingImpl")) : class$gov$epa$cdx$axis$dataflow$server$DataflowServicesBindingImpl).getName());
    static /* synthetic */ Class class$gov$epa$cdx$axis$dataflow$server$DataflowDocumentServicesBindingImpl;
    static /* synthetic */ Class class$gov$epa$cdx$axis$dataflow$server$DataflowServicesBindingImpl;

    public String getStatus(String authToken, String documentId) throws RemoteException {
        log.debug((Object)"Enter DataflowDocumentServicesBindingImpl.getStatus()");
        TransactionVO transactionVO = new TransactionVO();
        String status = "UNKNOWN";
        try {
            transactionVO = DocumentMgr.getTransactionForDocument((String)documentId);
            AuthTokenVO authTokenVO = new AuthTokenVO(this.getClientHost(), NodeVersion.V10, authToken);
            DataflowDocumentExchangeService serverBean = DataflowDocumentExchangeServiceUtil.getRemote();
            status = serverBean.getStatus(authTokenVO, documentId);
        }
        catch (Exception exception) {
            log.error((Object)"GetStatus Failed", (Throwable)exception);
            AxisFault fault = FaultHandler.exceptionToAxisFault((Exception)exception);
            audit.failure(transactionVO.getTransactionID(), exception.getMessage(), (Throwable)exception);
            throw fault;
        }
        log.debug((Object)"Exit DataflowDocumentServicesBindingImpl.getStatus()");
        return status;
    }

    public void download(String authToken, String documentId, String dataflow, ArrayofDocHolder documents) throws RemoteException {
        log.debug((Object)"Enter DataFlowServiceBindingImpl.download()");
        TransactionVO transactionVO = new TransactionVO();
        String transactionId = null;
        int arrayLength = 0;
        try {
            transactionVO = DocumentMgr.getTransactionForDocument((String)documentId);
            transactionId = transactionVO.getTransactionID();
            AuthTokenVO authTokenVO = new AuthTokenVO(this.getClientHost(), NodeVersion.V10, authToken);
            DocumentList documentList = new DocumentList(new DataflowTypeVO(dataflow));
            if (documents != null && (documentList = DocumentConverter.CdxToDocumentList((NodeDocument[])documents.value, (String)dataflow)) != null) {
                arrayLength = documentList.getDocuments().size();
            }
            documentList.setTransaction(transactionVO);
            if (arrayLength == 0) {
                DocumentVO document = new DocumentVO();
                document.setID(documentId);
                document.setDataFlowType(new DataflowTypeVO(dataflow));
                document.setDocumentType(DocumentType.XML);
                document.setName(documentId);
                documentList.addDocument((DocumentInterface)document);
            } else {
                if (arrayLength > 1) {
                    audit.info(transactionId, "Only single-element document arrays are supported.  The first document in the list will be processed.");
                }
                Iterator iter = documentList.getDocuments().iterator();
                while (iter.hasNext()) {
                    DocumentVO documentVO = (DocumentVO)iter.next();
                    documentVO.setID(documentId);
                }
            }
            DataflowDocumentExchangeService serverBean = DataflowDocumentExchangeServiceUtil.getRemote();
            documentList = serverBean.download(authTokenVO, documentList);
            if (documentList != null && documents != null) {
                documents.value = DocumentConverter.DocumentListToCdx((DocumentList)documentList, (int)1);
            }
        }
        catch (Exception exception) {
            log.error((Object)"download Failed", (Throwable)exception);
            AxisFault fault = FaultHandler.exceptionToAxisFault((Exception)exception);
            audit.failure(transactionId, exception.getMessage(), (Throwable)exception);
            throw fault;
        }
        log.debug((Object)"Exit DataflowDocumentServicesBindingImpl.download()");
    }

    public String notify(String authToken, String nodeAddress, String dataFlow, NodeDocument[] documents) throws RemoteException {
        log.debug((Object)"Enter DataflowDocumentServicesBindingImpl.notify()");
        String transactionId = null;
        try {
            AuthTokenVO authTokenVO = new AuthTokenVO(this.getClientHost(), NodeVersion.V10, authToken);
            DocumentList documentList = DocumentConverter.CdxToDocumentList((NodeDocument[])documents, (String)dataFlow);
            DataflowDocumentExchangeService serverBean = DataflowDocumentExchangeServiceUtil.getRemote();
            transactionId = serverBean.notify(authTokenVO, nodeAddress, dataFlow, documentList);
        }
        catch (CDXException exception) {
            log.error((Object)"Notify Failed", (Throwable)exception);
            AxisFault fault = FaultHandler.exceptionToAxisFault((Exception)((Object)exception));
            audit.failure(transactionId, exception.getMessage(), (Throwable)exception);
            throw fault;
        }
        log.debug((Object)"Exit DataflowDocumentServicesBindingImpl.notify()");
        return transactionId;
    }

    public String submit(String authToken, String documentId, String dataflow, NodeDocument[] documents) throws RemoteException {
        log.debug((Object)"Enter DataflowDocumentServicesBindingImpl.submit()");
        TransactionVO transactionVO = null;
        AuthTokenVO authTokenVO = new AuthTokenVO(this.getClientHost(), NodeVersion.V10, authToken);
        try {
            DocumentList documentList = DocumentConverter.CdxToDocumentList((NodeDocument[])documents, (String)dataflow);
            transactionVO = DocumentMgr.getTransactionForDocument((String)documentId);
            documentList.setTransaction(transactionVO);
            DataflowDocumentExchangeService serverBean = DataflowDocumentExchangeServiceUtil.getRemote();
            transactionVO = serverBean.submit(authTokenVO, documentList);
        }
        catch (Exception exception) {
            log.error((Object)"Submit Failed", (Throwable)exception);
            AxisFault fault = FaultHandler.exceptionToAxisFault((Exception)exception);
            audit.failure(transactionVO.getTransactionID(), exception.getMessage(), (Throwable)exception, authTokenVO);
            throw fault;
        }
        log.debug((Object)"Exit DataflowDocumentServicesBindingImpl.submit()");
        return transactionVO.getTransactionID();
    }

    private String getClientHost() {
        MessageContext msgContext = MessageContext.getCurrentContext();
        HttpServletRequest req = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        String clientHost = req.getRemoteAddr();
        return clientHost;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

