/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.axis.dataflow.server;

import gov.epa.cdx.axis.fault.FaultHandler;
import gov.epa.cdx.axis.v10.impl.DocumentConverter;
import gov.epa.cdx.axis.v10.impl.NetworkNodeBindingImpl;
import gov.epa.cdx.axis.v10.vo.NodeDocument;
import gov.epa.cdx.axis.v10.vo.holders.ArrayofDocHolder;
import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.ejbs.sb.dataflow.DataflowExchangeService;
import gov.epa.cdx.ejbs.sb.dataflow.DataflowExchangeServiceUtil;
import gov.epa.cdx.infrastructure.auditor.Audit;
import gov.epa.cdx.model.document.DocumentList;
import gov.epa.cdx.model.node.NodeVersion;
import gov.epa.cdx.model.security.AuthTokenVO;
import gov.epa.cdx.model.transaction.TransactionVO;
import java.rmi.RemoteException;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;

public class DataflowServicesBindingImpl
extends NetworkNodeBindingImpl {
    private static LogInterface log = LogFactory.getLog((String)(class$gov$epa$cdx$axis$dataflow$server$DataflowServicesBindingImpl == null ? (class$gov$epa$cdx$axis$dataflow$server$DataflowServicesBindingImpl = DataflowServicesBindingImpl.class$("gov.epa.cdx.axis.dataflow.server.DataflowServicesBindingImpl")) : class$gov$epa$cdx$axis$dataflow$server$DataflowServicesBindingImpl).getName());
    protected static Audit audit = new Audit((class$gov$epa$cdx$axis$dataflow$server$DataflowServicesBindingImpl == null ? (class$gov$epa$cdx$axis$dataflow$server$DataflowServicesBindingImpl = DataflowServicesBindingImpl.class$("gov.epa.cdx.axis.dataflow.server.DataflowServicesBindingImpl")) : class$gov$epa$cdx$axis$dataflow$server$DataflowServicesBindingImpl).getName());
    static /* synthetic */ Class class$gov$epa$cdx$axis$dataflow$server$DataflowServicesBindingImpl;

    public String submit(String authToken, String transactionId, String dataflow, NodeDocument[] documents) throws RemoteException {
        log.debug((Object)"Enter DataFlowServiceBindingImpl.submit()");
        TransactionVO transactionVO = null;
        try {
            AuthTokenVO authTokenVO = new AuthTokenVO(this.getClientHost(), NodeVersion.V10, authToken);
            DocumentList documentList = DocumentConverter.CdxToDocumentList((NodeDocument[])documents, (String)dataflow);
            if (transactionId == null) {
                throw new CDXException(CDXErrorCode.INVALID_TRANSACTION_ID);
            }
            TransactionVO inputTransactionVO = new TransactionVO();
            inputTransactionVO.setTransactionID(transactionId);
            documentList.setTransaction(inputTransactionVO);
            DataflowExchangeService serverBean = DataflowExchangeServiceUtil.getRemote();
            transactionVO = serverBean.submit(authTokenVO, documentList);
        }
        catch (Exception exception) {
            log.error((Object)"Submit Failed", (Throwable)exception);
            AxisFault fault = FaultHandler.exceptionToAxisFault((Exception)exception);
            audit.failure(transactionId, exception.getMessage(), (Throwable)exception);
            throw fault;
        }
        log.debug((Object)"Exit DataFlowServiceBindingImpl.submit()");
        return transactionVO.getTransactionID();
    }

    public void download(String authToken, String transactionId, String dataflow, ArrayofDocHolder documents) throws RemoteException {
        log.debug((Object)"Enter DataFlowServiceBindingImpl.download()");
        try {
            AuthTokenVO authTokenVO = new AuthTokenVO(this.getClientHost(), NodeVersion.V10, authToken);
            DocumentList documentList = DocumentConverter.CdxToDocumentList((NodeDocument[])documents.value, (String)dataflow);
            TransactionVO transactionVO = new TransactionVO();
            transactionVO.setTransactionID(transactionId);
            documentList.setTransaction(transactionVO);
            DataflowExchangeService serverBean = DataflowExchangeServiceUtil.getRemote();
            documentList = serverBean.download(authTokenVO, documentList);
            if (documentList != null) {
                documents.value = DocumentConverter.DocumentListToCdx((DocumentList)documentList, (int)1);
            }
        }
        catch (Exception exception) {
            log.error((Object)"download Failed", (Throwable)exception);
            AxisFault fault = FaultHandler.exceptionToAxisFault((Exception)exception);
            audit.failure(transactionId, exception.getMessage(), (Throwable)exception);
            throw fault;
        }
        log.debug((Object)"Exit DataFlowServiceBindingImpl.download()");
    }

    public String notify(String authToken, String nodeAddress, String dataFlow, NodeDocument[] documents) throws RemoteException {
        log.debug((Object)"Enter DataFlowServiceBindingImpl.notify()");
        String transactionId = null;
        try {
            AuthTokenVO authTokenVO = new AuthTokenVO(this.getClientHost(), NodeVersion.V10, authToken);
            DocumentList documentList = DocumentConverter.CdxToDocumentList((NodeDocument[])documents, (String)dataFlow);
            DataflowExchangeService serverBean = DataflowExchangeServiceUtil.getRemote();
            transactionId = serverBean.notify(authTokenVO, nodeAddress, dataFlow, documentList);
        }
        catch (CDXException exception) {
            log.error((Object)"Notify Failed", (Throwable)exception);
            AxisFault fault = FaultHandler.exceptionToAxisFault((Exception)((Object)exception));
            audit.failure(transactionId, exception.getMessage(), (Throwable)exception);
            throw fault;
        }
        log.debug((Object)"Exit DataFlowServiceBindingImpl.notify()");
        return transactionId;
    }

    private String getClientHost() {
        MessageContext msgContext = MessageContext.getCurrentContext();
        HttpServletRequest req = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        String clientHost = req.getRemoteAddr();
        return clientHost;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

