/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.axis.v10.impl;

import gov.epa.cdx.axis.fault.FaultErrorCode;
import gov.epa.cdx.axis.fault.FaultHandler;
import gov.epa.cdx.axis.v10.NetworkNodePortType;
import gov.epa.cdx.axis.v10.impl.DocumentConverter;
import gov.epa.cdx.axis.v10.vo.NodeDocument;
import gov.epa.cdx.axis.v10.vo.holders.ArrayofDocHolder;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.ejbs.sb.server.ExchangeNetworkService;
import gov.epa.cdx.ejbs.sb.server.ExchangeNetworkServiceUtil;
import gov.epa.cdx.infrastructure.auditor.Audit;
import gov.epa.cdx.infrastructure.node.NodeMgr;
import gov.epa.cdx.infrastructure.transaction.TransactionMgr;
import gov.epa.cdx.model.commons.QueryVO;
import gov.epa.cdx.model.document.DocumentList;
import gov.epa.cdx.model.node.NodeVersion;
import gov.epa.cdx.model.scheduler.TaskTypeVO;
import gov.epa.cdx.model.security.AuthTokenVO;
import gov.epa.cdx.model.security.CredentialType;
import gov.epa.cdx.model.security.LoginVO;
import gov.epa.cdx.model.supportedservices.ServiceTypes;
import gov.epa.cdx.model.transaction.Status;
import gov.epa.cdx.model.transaction.TransactionVO;
import java.math.BigInteger;
import java.rmi.RemoteException;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;

public class NetworkNodeBindingImpl
implements NetworkNodePortType {
    protected static LogInterface log = LogFactory.getLog((String)(class$gov$epa$cdx$axis$v10$impl$NetworkNodeBindingImpl == null ? (class$gov$epa$cdx$axis$v10$impl$NetworkNodeBindingImpl = NetworkNodeBindingImpl.class$("gov.epa.cdx.axis.v10.impl.NetworkNodeBindingImpl")) : class$gov$epa$cdx$axis$v10$impl$NetworkNodeBindingImpl).getName());
    protected static Audit audit = new Audit((class$gov$epa$cdx$axis$v10$impl$NetworkNodeBindingImpl == null ? (class$gov$epa$cdx$axis$v10$impl$NetworkNodeBindingImpl = NetworkNodeBindingImpl.class$("gov.epa.cdx.axis.v10.impl.NetworkNodeBindingImpl")) : class$gov$epa$cdx$axis$v10$impl$NetworkNodeBindingImpl).getName());
    public static final String XMLGATEWAY_CLIENTIP_PROPERTY_KEY = "XMLGateway.ClientIP";
    static /* synthetic */ Class class$gov$epa$cdx$axis$v10$impl$NetworkNodeBindingImpl;

    private String getClientHost() {
        MessageContext msgContext = MessageContext.getCurrentContext();
        HttpServletRequest req = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        String clientHost = null;
        String clientProperty = null;
        try {
            clientProperty = NodeMgr.getUrlByNode((String)XMLGATEWAY_CLIENTIP_PROPERTY_KEY);
        }
        catch (Exception e) {
            log.debug((Object)"could not find property for <XMLGateway.ClientIP>", (Throwable)e);
        }
        clientHost = clientProperty == null || clientProperty.trim().length() <= 0 ? req.getRemoteAddr() : req.getHeader(clientProperty);
        return clientHost;
    }

    public String authenticate(String userId, String credential, String authMethod) throws RemoteException {
        log.debug((Object)"Enter NetworkNodeBindingImpl.Authenticate()");
        AuthTokenVO authTokenVO = null;
        LoginVO loginVO = null;
        try {
            loginVO = new LoginVO(this.getClientHost(), NodeVersion.V10, userId, CredentialType.getCredentialTypeById((String)authMethod), (Object)credential);
            ExchangeNetworkService serverBean = ExchangeNetworkServiceUtil.getRemote();
            authTokenVO = serverBean.authenticate(loginVO);
        }
        catch (Exception exception) {
            log.error((Object)"Authentication Failed", (Throwable)exception);
            AxisFault fault = FaultHandler.exceptionToAxisFault((Exception)exception);
            String failureMessage = "User" + userId + " with " + authMethod + ": " + credential + " IP: " + this.getClientHost();
            audit.failure(null, failureMessage, (Throwable)exception);
            throw fault;
        }
        log.debug((Object)"Exit NetworkNodeBindingImpl.Authenticate()");
        return authTokenVO.getAuthToken();
    }

    public String submit(String authToken, String transactionId, String dataflow, NodeDocument[] documents) throws RemoteException {
        log.debug((Object)"Enter NetworkNodeBindingImpl.submit()");
        TransactionVO transactionVO = null;
        AuthTokenVO authTokenVO = new AuthTokenVO(this.getClientHost(), NodeVersion.V10, authToken);
        try {
            DocumentList documentList = DocumentConverter.CdxToDocumentList((NodeDocument[])documents, (String)dataflow);
            if (transactionId != null) {
                TransactionVO inputTransactionVO = new TransactionVO();
                inputTransactionVO.setTransactionID(transactionId);
                documentList.setTransaction(inputTransactionVO);
            }
            ExchangeNetworkService serverBean = ExchangeNetworkServiceUtil.getRemote();
            transactionVO = serverBean.submit(authTokenVO, documentList);
        }
        catch (Exception exception) {
            log.error((Object)"Submit Failed", (Throwable)exception);
            AxisFault fault = FaultHandler.exceptionToAxisFault((Exception)exception);
            audit.failure(transactionId, exception.getMessage(), (Throwable)exception, authTokenVO);
            throw fault;
        }
        log.debug((Object)"Exit NetworkNodeBindingImpl.submit()");
        return transactionVO.getTransactionID();
    }

    public String getStatus(String authToken, String transid) throws RemoteException {
        log.debug((Object)"Enter NetworkNodeBindingImpl.getStatus()");
        Status status = null;
        AuthTokenVO authTokenVO = new AuthTokenVO(this.getClientHost(), NodeVersion.V10, authToken);
        TransactionVO transactionVO = new TransactionVO();
        transactionVO.setTransactionID(transid);
        try {
            ExchangeNetworkService serverBean = ExchangeNetworkServiceUtil.getRemote();
            status = serverBean.getStatus(authTokenVO, transactionVO);
        }
        catch (Exception exception) {
            log.error((Object)"getStatus Failed", (Throwable)exception);
            AxisFault fault = FaultHandler.exceptionToAxisFault((Exception)exception);
            audit.failure(transid, exception.getMessage(), (Throwable)exception, authTokenVO);
            throw fault;
        }
        log.debug((Object)"Exit NetworkNodeBindingImpl.getStatus()");
        return status.toString();
    }

    public void download(String authToken, String transid, String dataflow, ArrayofDocHolder documents) throws RemoteException {
        log.debug((Object)"Enter NetworkNodeBindingImpl.download()");
        AuthTokenVO authTokenVO = new AuthTokenVO(this.getClientHost(), NodeVersion.V10, authToken);
        try {
            DocumentList documentList = DocumentConverter.CdxToDocumentList((NodeDocument[])documents.value, (String)dataflow);
            TransactionVO transactionVO = new TransactionVO();
            transactionVO.setTransactionID(transid);
            ExchangeNetworkService serverBean = ExchangeNetworkServiceUtil.getRemote();
            documentList = serverBean.download(authTokenVO, documentList, transactionVO);
            documents.value = DocumentConverter.DocumentListToCdx((DocumentList)documentList, (int)1);
        }
        catch (Exception exception) {
            log.error((Object)"Download Failed", (Throwable)exception);
            AxisFault fault = FaultHandler.exceptionToAxisFault((Exception)exception);
            audit.failure(transid, exception.getMessage(), (Throwable)exception, authTokenVO);
            throw fault;
        }
        log.debug((Object)"Exit NetworkNodeBindingImpl.download()");
    }

    public String notify(String authToken, String nodeAddress, String dataFlow, NodeDocument[] documents) throws RemoteException {
        log.debug((Object)"Enter NetworkNodeBindingImpl.notify()");
        String transactionId = null;
        try {
            AuthTokenVO authTokenVO = new AuthTokenVO(this.getClientHost(), NodeVersion.V10, authToken);
            DocumentList documentList = DocumentConverter.CdxToDocumentList((NodeDocument[])documents, (String)dataFlow);
            ExchangeNetworkService serverBean = ExchangeNetworkServiceUtil.getRemote();
            transactionId = serverBean.notify(authTokenVO, nodeAddress, dataFlow, documentList);
        }
        catch (CDXException exception) {
            log.error((Object)"Notify Failed", (Throwable)exception);
            AxisFault fault = FaultHandler.exceptionToAxisFault((Exception)((Object)exception));
            audit.failure(transactionId, exception.getMessage(), (Throwable)exception);
            throw fault;
        }
        log.debug((Object)"Exit NetworkNodeBindingImpl.notify()");
        return transactionId;
    }

    public String solicit(String authToken, String returnURL, String serviceName, String[] parameters) throws RemoteException {
        log.debug((Object)"Enter NetworkNodeBindingImpl.solicit()");
        TransactionVO transactionVO = null;
        AuthTokenVO authTokenVO = new AuthTokenVO(this.getClientHost(), NodeVersion.V10, authToken);
        String transactionID = null;
        try {
            QueryVO queryVO = new QueryVO(returnURL, serviceName, parameters, new TaskTypeVO("DATA_FLOW_ASYNC_QUERY"), "Asyncronous Query For Data Flow");
            transactionVO = TransactionMgr.create();
            transactionID = transactionVO.getTransactionID();
            queryVO.setTransactionId(transactionID);
            ExchangeNetworkService serverBean = ExchangeNetworkServiceUtil.getRemote();
            transactionVO = serverBean.solicit(authTokenVO, queryVO);
        }
        catch (Exception exception) {
            log.error((Object)"solicit Failed", (Throwable)exception);
            AxisFault fault = FaultHandler.exceptionToAxisFault((Exception)exception);
            audit.failure(null, exception.getMessage(), (Throwable)exception, authTokenVO);
            throw fault;
        }
        log.debug((Object)"Exit NetworkNodeBindingImpl.solicit()");
        return transactionVO.getTransactionID();
    }

    public String query(String authToken, String request, BigInteger rowId, BigInteger maxRows, String[] parameters) throws RemoteException {
        log.debug((Object)"Enter NetworkNodeBindingImpl.query()");
        String result = null;
        String transactionID = null;
        AuthTokenVO authTokenVO = new AuthTokenVO(this.getClientHost(), NodeVersion.V10, authToken);
        try {
            QueryVO queryVO = new QueryVO(null, request, parameters, new TaskTypeVO("DATA_FLOW_QUERY"), "Query For Data FLow");
            TransactionVO transactionVO = TransactionMgr.create();
            transactionID = transactionVO.getTransactionID();
            queryVO.setTransactionId(transactionID);
            ExchangeNetworkService serverBean = ExchangeNetworkServiceUtil.getRemote();
            byte[] data = serverBean.query(authTokenVO, queryVO);
            result = new String(data);
        }
        catch (Exception exception) {
            log.error((Object)"Query Failed", (Throwable)exception);
            AxisFault fault = FaultHandler.exceptionToAxisFault((Exception)exception);
            audit.failure(transactionID, exception.getMessage(), (Throwable)exception, authTokenVO);
            throw fault;
        }
        log.debug((Object)"Exit NetworkNodeBindingImpl.query()");
        return result;
    }

    public String execute(String authToken, String request, String[] parameters) throws RemoteException {
        log.error((Object)"Execute Web Service Is Not Supported by CDX Node");
        AxisFault fault = FaultHandler.getFault((String)"Client", (String)"Execute Web Service Is Not Supported by CDX Node", (FaultErrorCode)FaultErrorCode.FEATURE_UNSUPPORTED);
        audit.failure(null, "Execute Web Service Is Not Supported by CDX Node", (Throwable)fault);
        throw fault;
    }

    public String nodePing(String hello) throws RemoteException {
        audit.success(null, "String: " + hello);
        return "Ready";
    }

    public String[] getServices(String authToken, String service) throws RemoteException {
        log.debug((Object)"Enter NetworkNodeBindingImpl.getServices()");
        String[] services = null;
        ServiceTypes serviceType = null;
        serviceType = ServiceTypes.getServiceTypesById((String)service);
        if (serviceType == null) {
            serviceType = ServiceTypes.UNKNOWN;
        }
        AuthTokenVO authTokenVO = null;
        try {
            authTokenVO = new AuthTokenVO(this.getClientHost(), NodeVersion.V10, authToken);
            ExchangeNetworkService serverBean = ExchangeNetworkServiceUtil.getRemote();
            services = serverBean.getServices(authTokenVO, serviceType);
        }
        catch (Exception exception) {
            log.error((Object)"getServices Failed", (Throwable)exception);
            AxisFault fault = FaultHandler.exceptionToAxisFault((Exception)exception);
            audit.failure(null, exception.getMessage(), (Throwable)exception, authTokenVO);
            throw fault;
        }
        log.debug((Object)"Exit NetworkNodeBindingImpl.getServices()");
        return services;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

