/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.xml;

import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ElementTag
extends TagSupport {
    private String namespace;
    private String name;
    private AttributesImpl attributes = new AttributesImpl();
    private boolean outputAttributes;

    public void setAttributeValue(String name, String value) throws JellyTagException {
        if (this.outputAttributes) {
            throw new JellyTagException("Cannot set the value of attribute: " + name + " as we have already output the startElement() SAX event");
        }
        int index = this.attributes.getIndex("", name);
        if (index >= 0) {
            this.attributes.removeAttribute(index);
        }
        if (value != null) {
            this.attributes.addAttribute("", name, name, "CDATA", value);
        }
    }

    public void doTag(XMLOutput output) throws JellyTagException {
        int idx = this.name.indexOf(58);
        final String localName = idx >= 0 ? this.name.substring(idx + 1) : this.name;
        this.outputAttributes = false;
        XMLOutput newOutput = new XMLOutput((ContentHandler)output){

            public void startElement(String uri, String localName2, String qName, Attributes atts) throws SAXException {
                this.initialize();
                super.startElement(uri, localName2, qName, atts);
            }

            public void endElement(String uri, String localName2, String qName) throws SAXException {
                this.initialize();
                super.endElement(uri, localName2, qName);
            }

            public void characters(char[] ch, int start, int length) throws SAXException {
                this.initialize();
                super.characters(ch, start, length);
            }

            public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
                this.initialize();
                super.ignorableWhitespace(ch, start, length);
            }

            public void processingInstruction(String target, String data) throws SAXException {
                this.initialize();
                super.processingInstruction(target, data);
            }

            protected void initialize() throws SAXException {
                if (!ElementTag.this.outputAttributes) {
                    super.startElement(ElementTag.this.namespace, localName, ElementTag.this.name, (Attributes)ElementTag.this.attributes);
                    ElementTag.this.outputAttributes = true;
                }
            }
        };
        this.invokeBody(newOutput);
        try {
            if (!this.outputAttributes) {
                output.startElement(this.namespace, localName, this.name, (Attributes)this.attributes);
                this.outputAttributes = true;
            }
            output.endElement(this.namespace, localName, this.name);
            this.attributes.clear();
        }
        catch (SAXException e) {
            throw new JellyTagException((Throwable)e);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getURI() {
        return this.namespace;
    }

    public void setURI(String namespace) {
        this.namespace = namespace;
    }
}

