/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.ws.logic;

import gov.epa.cdx.axis.v10.vo.NodeDocument;
import gov.epa.cdx.commons.property.CDXPropertyManager;
import gov.epa.cdx.model.document.DocumentList;
import gov.epa.cdx.model.document.DocumentVO;
import gov.epa.cdx.ws.logic.WSNodeManager;
import gov.epa.wqx.node.Lib;
import gov.epa.wqx.node.WqxSaxHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.CopyUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class WSBackEndWorkerThread
implements Runnable {
    protected static Log log = LogFactory.getLog((String)(class$gov$epa$cdx$ws$logic$WSBackEndWorkerThread == null ? (class$gov$epa$cdx$ws$logic$WSBackEndWorkerThread = WSBackEndWorkerThread.class$("gov.epa.cdx.ws.logic.WSBackEndWorkerThread")) : class$gov$epa$cdx$ws$logic$WSBackEndWorkerThread).getName());
    private DocumentList _documents;
    static /* synthetic */ Class class$gov$epa$cdx$ws$logic$WSBackEndWorkerThread;

    public WSBackEndWorkerThread(DocumentList documents) {
        this._documents = documents;
    }

    public static File unzipDocument(DocumentVO document, String transactionId) throws Exception {
        try {
            log.debug((Object)"WSBackEndWorkerThread.unzip - Start");
            String workingFolder = Lib.getWorkingDirectory();
            File tempFolder = new File(workingFolder + transactionId);
            log.debug((Object)("tempFolder=" + tempFolder.getPath()));
            FileUtils.forceMkdir((File)tempFolder);
            String cdxFilePath = tempFolder + Lib.getFileSeparator() + document.getName();
            FileOutputStream zipFileOutputStream = new FileOutputStream(cdxFilePath);
            CopyUtils.copy((byte[])document.getData(), (OutputStream)zipFileOutputStream);
            zipFileOutputStream.flush();
            zipFileOutputStream.close();
            if (document.getName().toUpperCase().indexOf(".XML") > 0) {
                File file = new File(cdxFilePath);
                return file;
            }
            File file = WSBackEndWorkerThread.unzipFile(cdxFilePath);
            return file;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
        finally {
            log.debug((Object)"WSBackEndWorkerThread.unzip - End");
        }
    }

    public static File unzipFile(String zipFilePath) throws Exception {
        int BUFFER = 2048;
        File xmlSubmissionFile = null;
        try {
            log.debug((Object)"WSBackEndWorkerThread.unzipFile - Start");
            String osSlash = Lib.getFileSeparator();
            String destinationPath = zipFilePath.substring(0, zipFilePath.lastIndexOf(osSlash));
            ZipFile zipFile = new ZipFile(zipFilePath);
            Enumeration<? extends ZipEntry> zipEnumeration = zipFile.entries();
            while (zipEnumeration.hasMoreElements()) {
                int bytesRead;
                ZipEntry zipEntry = zipEnumeration.nextElement();
                if (zipEntry.isDirectory()) continue;
                String zipEntryName = zipEntry.getName();
                int lastSlash = zipEntryName.lastIndexOf("\\");
                if (lastSlash < 1) {
                    lastSlash = zipEntryName.lastIndexOf("/");
                }
                String zipEntryFileNameOnly = lastSlash < 1 ? zipEntryName.trim() : zipEntryName.substring(lastSlash + 1).trim();
                if (zipEntryName.indexOf(".") == -1 && zipFile.size() == 1) {
                    zipEntryFileNameOnly = zipEntryFileNameOnly + ".xml";
                }
                log.debug((Object)("zipEntryFileNameOnly=" + zipEntryFileNameOnly));
                String outputFileName = destinationPath + osSlash + zipEntryFileNameOnly;
                if (zipEntryFileNameOnly.toUpperCase().indexOf(".XML") > 0) {
                    xmlSubmissionFile = new File(outputFileName);
                    log.debug((Object)("xmlSubmissionFile=" + xmlSubmissionFile));
                }
                BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFileName), 2048);
                BufferedInputStream zipEntryInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                byte[] data = new byte[2048];
                while ((bytesRead = zipEntryInputStream.read(data, 0, 2048)) != -1) {
                    outputStream.write(data, 0, bytesRead);
                }
                outputStream.flush();
                outputStream.close();
                zipEntryInputStream.close();
            }
            File file = xmlSubmissionFile;
            return file;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
        finally {
            log.debug((Object)"WSBackEndWorkerThread.unzipFile - End");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        log.info((Object)"******** WSBackEndWorkerThread.run() - Start ********");
        String xmlPath = null;
        try {
            try {
                String transactionId = this._documents.getTransaction().getTransactionID();
                DocumentVO doc = (DocumentVO)this._documents.getDocuments().iterator().next();
                File xmlFile = WSBackEndWorkerThread.unzipDocument(doc, transactionId);
                xmlPath = xmlFile.getPath().substring(0, xmlFile.getPath().lastIndexOf(Lib.getFileSeparator()));
                String xmlFileName = xmlFile.getName();
                xmlFile = null;
                this.parseDocument(xmlPath, xmlFileName, transactionId);
            }
            catch (Exception e) {
                log.trace((Object)"Failed to Parse Document:", (Throwable)e);
                Object var7_8 = null;
                log.info((Object)"******** WSBackEndWorkerThread.run() - End ********");
                return;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            log.info((Object)"******** WSBackEndWorkerThread.run() - End ********");
            throw throwable;
        }
        log.info((Object)"******** WSBackEndWorkerThread.run() - End ********");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void parseDocument(String docPath, String docName, String transactionId) throws Exception, IOException, SAXException {
        block20: {
            WqxSaxHandler handler;
            block19: {
                handler = null;
                log.debug((Object)"WSBackEndWorkerThread.parseDocument() - Start");
                XMLReader reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
                handler = new WqxSaxHandler(docPath, docName, transactionId);
                reader.setContentHandler((ContentHandler)handler);
                reader.setErrorHandler((ErrorHandler)handler);
                InputSource input = new InputSource(new FileReader(docPath + Lib.getFileSeparator() + docName));
                reader.parse(input);
                Object var8_8 = null;
                if (handler == null) break block19;
                try {
                    log.debug((Object)"Building Processing Report");
                    byte[] content = handler.getProcessingReport().getBytes();
                    if (Lib.allowTwoWayCommunication()) {
                        NodeDocument nodeDoc = new NodeDocument();
                        nodeDoc.putContent(content, 0);
                        nodeDoc.setName(transactionId);
                        nodeDoc.setType("XML");
                        String urlEndpoint = CDXPropertyManager.getProperty((String)"Submit", (String)"NotifyURL");
                        WSNodeManager.callCdxNotify(transactionId, nodeDoc, urlEndpoint);
                    } else {
                        FileOutputStream fileOutputStream = new FileOutputStream(Lib.getWorkingDirectory() + transactionId + "_ProcessingReport.xml");
                        CopyUtils.copy((byte[])content, (OutputStream)fileOutputStream);
                        fileOutputStream.flush();
                        fileOutputStream.close();
                    }
                }
                catch (Exception e2) {
                    log.error((Object)e2);
                    log.info((Object)Lib.getSimplifiedStackTrace((Exception)e2, (boolean)false));
                }
                finally {
                    handler.done();
                }
            }
            log.debug((Object)"WSBackEndWorkerThread.parseDocument() - End");
            {
                break block20;
                catch (Exception e) {
                    log.error((Object)e);
                    log.info((Object)Lib.getSimplifiedStackTrace((Exception)e, (boolean)false));
                    Object var8_9 = null;
                    if (handler != null) {
                        block21: {
                            try {
                                log.debug((Object)"Building Processing Report");
                                byte[] content = handler.getProcessingReport().getBytes();
                                if (Lib.allowTwoWayCommunication()) {
                                    NodeDocument nodeDoc = new NodeDocument();
                                    nodeDoc.putContent(content, 0);
                                    nodeDoc.setName(transactionId);
                                    nodeDoc.setType("XML");
                                    String urlEndpoint = CDXPropertyManager.getProperty((String)"Submit", (String)"NotifyURL");
                                    WSNodeManager.callCdxNotify(transactionId, nodeDoc, urlEndpoint);
                                    break block21;
                                }
                                FileOutputStream fileOutputStream = new FileOutputStream(Lib.getWorkingDirectory() + transactionId + "_ProcessingReport.xml");
                                CopyUtils.copy((byte[])content, (OutputStream)fileOutputStream);
                                fileOutputStream.flush();
                                fileOutputStream.close();
                            }
                            catch (Exception e2) {
                                try {}
                                catch (Throwable throwable) {
                                    handler.done();
                                    throw throwable;
                                }
                                log.error((Object)e2);
                                log.info((Object)Lib.getSimplifiedStackTrace((Exception)e2, (boolean)false));
                                handler.done();
                            }
                        }
                        handler.done();
                    }
                    log.debug((Object)"WSBackEndWorkerThread.parseDocument() - End");
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (handler != null) {
                    block23: {
                        try {
                            log.debug((Object)"Building Processing Report");
                            byte[] content = handler.getProcessingReport().getBytes();
                            if (Lib.allowTwoWayCommunication()) {
                                NodeDocument nodeDoc = new NodeDocument();
                                nodeDoc.putContent(content, 0);
                                nodeDoc.setName(transactionId);
                                nodeDoc.setType("XML");
                                String urlEndpoint = CDXPropertyManager.getProperty((String)"Submit", (String)"NotifyURL");
                                WSNodeManager.callCdxNotify(transactionId, nodeDoc, urlEndpoint);
                                break block23;
                            }
                            FileOutputStream fileOutputStream = new FileOutputStream(Lib.getWorkingDirectory() + transactionId + "_ProcessingReport.xml");
                            CopyUtils.copy((byte[])content, (OutputStream)fileOutputStream);
                            fileOutputStream.flush();
                            fileOutputStream.close();
                        }
                        catch (Exception e2) {
                            try {}
                            catch (Throwable throwable2) {
                                handler.done();
                                throw throwable2;
                            }
                            log.error((Object)e2);
                            log.info((Object)Lib.getSimplifiedStackTrace((Exception)e2, (boolean)false));
                            handler.done();
                        }
                    }
                    handler.done();
                }
                log.debug((Object)"WSBackEndWorkerThread.parseDocument() - End");
                throw throwable;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

