/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.ws.logic;

import gov.epa.cdx.axis.v10.client.NodeRequestor;
import gov.epa.cdx.axis.v10.vo.NodeDocument;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.property.CDXPropertyManager;
import gov.epa.cdx.model.commons.QueryVO;
import gov.epa.cdx.model.document.DocumentList;
import gov.epa.cdx.model.transaction.TransactionVO;
import gov.epa.cdx.ws.logic.WSBackEndWorkerThread;
import gov.epa.wqx.node.SolicitThread;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WSNodeManager {
    protected static Log log = LogFactory.getLog((String)(class$gov$epa$cdx$ws$logic$WSNodeManager == null ? (class$gov$epa$cdx$ws$logic$WSNodeManager = WSNodeManager.class$("gov.epa.cdx.ws.logic.WSNodeManager")) : class$gov$epa$cdx$ws$logic$WSNodeManager).getName());
    static /* synthetic */ Class class$gov$epa$cdx$ws$logic$WSNodeManager;

    public static TransactionVO processSubmit(DocumentList documents) throws CDXException {
        log.debug((Object)"WSNodeManager.processSubmit() - Start");
        WSBackEndWorkerThread worker = new WSBackEndWorkerThread(documents);
        Thread thread = new Thread(worker);
        thread.start();
        log.debug((Object)"WSNodeManager.processSubmit() - End");
        return documents.getTransaction();
    }

    public static TransactionVO processSolicit(QueryVO queryVO) throws CDXException {
        log.debug((Object)"WSNodeManager.processSolicit() - Start");
        TransactionVO transactionVO = new TransactionVO();
        transactionVO.setTransactionID(queryVO.getReturnURL());
        SolicitThread worker = new SolicitThread(queryVO);
        Thread thread = new Thread((Runnable)worker);
        thread.start();
        log.debug((Object)"WSNodeManager.processSolicit() - End");
        return transactionVO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void callCdxNotify(String transId, NodeDocument doc, String urlEndpoint) {
        try {
            log.debug((Object)"callCdxNotify() - Start");
            URL nodeURL = new URL(urlEndpoint);
            NodeRequestor nr = new NodeRequestor(nodeURL);
            log.debug((Object)"calling authenticate");
            String token = nr.authenticate(CDXPropertyManager.getProperty((String)"CDX", (String)"User"), CDXPropertyManager.getProperty((String)"CDX", (String)"Password"));
            NodeDocument[] nDocs = new NodeDocument[]{doc};
            log.debug((Object)"calling notify");
            nr.notify(token, transId, "WQX", nDocs);
            log.info((Object)("Notification sent for Transaction ID " + transId));
        }
        catch (MalformedURLException e) {
            log.error((Object)"Error in callCdxNotify - Node URL is incorrect. ", (Throwable)e);
        }
        catch (RemoteException e) {
            log.trace((Object)"Error in callCdxNotify", (Throwable)e);
        }
        finally {
            log.debug((Object)"callCdxNotify() - End");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void callCdxSubmit(String transId, NodeDocument doc) {
        try {
            log.debug((Object)"callCdxSubmit() - Start");
            String submitUrl = CDXPropertyManager.getProperty((String)"Solicit", (String)"SubmitURL");
            log.debug((Object)("Submit URL = " + submitUrl));
            URL nodeURL = new URL(submitUrl);
            NodeRequestor nr = new NodeRequestor(nodeURL);
            log.debug((Object)"calling authenticate");
            String token = nr.authenticate(CDXPropertyManager.getProperty((String)"CDX", (String)"User"), CDXPropertyManager.getProperty((String)"CDX", (String)"Password"));
            NodeDocument[] nDocs = new NodeDocument[]{doc};
            log.debug((Object)"calling submit");
            nr.submit(token, transId, "WQX", nDocs);
        }
        catch (MalformedURLException e) {
            log.error((Object)"Error in callCdxSubmit - Node URL is incorrect. ", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Error in callCdxSubmit", (Throwable)e);
        }
        finally {
            log.debug((Object)"callCdxSubmit() - End");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

