/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.ws.axis.impl;

import gov.epa.cdx.axis.fault.FaultErrorCode;
import gov.epa.cdx.axis.fault.FaultHandler;
import gov.epa.cdx.axis.v10.NetworkNodePortType;
import gov.epa.cdx.axis.v10.impl.DocumentConverter;
import gov.epa.cdx.axis.v10.vo.NodeDocument;
import gov.epa.cdx.axis.v10.vo.holders.ArrayofDocHolder;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.model.commons.QueryVO;
import gov.epa.cdx.model.document.DocumentList;
import gov.epa.cdx.model.node.NodeVersion;
import gov.epa.cdx.model.scheduler.TaskTypeVO;
import gov.epa.cdx.model.security.AuthTokenVO;
import gov.epa.cdx.model.security.AuthorizationVO;
import gov.epa.cdx.model.security.CredentialType;
import gov.epa.cdx.model.security.LoginVO;
import gov.epa.cdx.model.supportedservices.Methods;
import gov.epa.cdx.model.supportedservices.ServiceTypes;
import gov.epa.cdx.model.transaction.Status;
import gov.epa.cdx.model.transaction.TransactionVO;
import gov.epa.cdx.ws.ejbs.sb.server.WSServerServiceRemote;
import gov.epa.cdx.ws.ejbs.sb.server.WSServerServiceUtil;
import java.math.BigInteger;
import java.rmi.RemoteException;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WSWSImplementation
implements NetworkNodePortType {
    protected static Log log = LogFactory.getLog((String)(class$gov$epa$cdx$ws$axis$impl$WSWSImplementation == null ? (class$gov$epa$cdx$ws$axis$impl$WSWSImplementation = WSWSImplementation.class$("gov.epa.cdx.ws.axis.impl.WSWSImplementation")) : class$gov$epa$cdx$ws$axis$impl$WSWSImplementation).getName());
    static /* synthetic */ Class class$gov$epa$cdx$ws$axis$impl$WSWSImplementation;

    private String getClientHost() {
        MessageContext msgContext = MessageContext.getCurrentContext();
        HttpServletRequest req = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        String clientHost = req.getRemoteAddr();
        return clientHost;
    }

    public String authenticate(String userId, String credential, String authMethod) throws RemoteException {
        AuthTokenVO authTokenVO = null;
        LoginVO loginVO = null;
        Object status = null;
        try {
            loginVO = new LoginVO(this.getClientHost(), NodeVersion.V10, userId, CredentialType.getCredentialTypeById((String)authMethod), (Object)credential);
            WSServerServiceRemote bean = this.getServerBean();
            authTokenVO = bean.authenticate(loginVO);
            return authTokenVO.getAuthToken();
        }
        catch (Exception exception) {
            log.error((Object)"Authentication Failed", (Throwable)exception);
            AxisFault fault = FaultHandler.exceptionToAxisFault((Exception)exception);
            String failureMessage = "User" + userId + " with " + authMethod + ": " + credential + " IP: " + this.getClientHost();
            throw fault;
        }
    }

    public String submit(String authToken, String transactionId, String dataflow, NodeDocument[] documents) throws RemoteException {
        log.info((Object)"******** submit() - Start ********");
        try {
            if (transactionId == null) {
                throw new RemoteException("transactionId is required for submit");
            }
            TransactionVO transactionVO = null;
            AuthTokenVO authTokenVO = new AuthTokenVO(this.getClientHost(), NodeVersion.V10, authToken);
            AuthorizationVO authVO = new AuthorizationVO();
            authVO.setDataFlow("WQX");
            authVO.setMethod(Methods.SUBMIT);
            authVO.setRequest("n/a");
            String[] params = new String[]{"n/a"};
            authVO.setParameters(params);
            authTokenVO.setAuthorizationVO(authVO);
            DocumentList documentList = DocumentConverter.CdxToDocumentList((NodeDocument[])documents, (String)dataflow);
            if (transactionId != null) {
                TransactionVO inputTransactionVO = new TransactionVO();
                inputTransactionVO.setTransactionID(transactionId);
                documentList.setTransaction(inputTransactionVO);
            }
            WSServerServiceRemote bean = this.getServerBean();
            transactionVO = bean.submit(authTokenVO, documentList);
            String string = transactionVO.getTransactionID();
            return string;
        }
        catch (Exception exception) {
            log.error((Object)"Submit Failed", (Throwable)exception);
            AxisFault fault = FaultHandler.exceptionToAxisFault((Exception)exception);
            throw fault;
        }
        finally {
            log.info((Object)"******** submit() - End ********");
        }
    }

    public String getStatus(String authToken, String transid) throws RemoteException {
        log.info((Object)"******** getStatus() - Start ********");
        try {
            Status status = null;
            AuthTokenVO authTokenVO = new AuthTokenVO(this.getClientHost(), NodeVersion.V10, authToken);
            TransactionVO transactionVO = new TransactionVO();
            transactionVO.setTransactionID(transid);
            WSServerServiceRemote bean = this.getServerBean();
            status = bean.getStatus(authTokenVO, transactionVO);
            String string = status.toString();
            return string;
        }
        catch (Exception exception) {
            log.error((Object)"getStatus Failed", (Throwable)exception);
            AxisFault fault = FaultHandler.exceptionToAxisFault((Exception)exception);
            throw fault;
        }
        finally {
            log.info((Object)"******** getStatus() - End ********");
        }
    }

    public void download(String authToken, String transid, String dataflow, ArrayofDocHolder documents) throws RemoteException {
        log.info((Object)"******** download() - Start ********");
        try {
            AuthTokenVO authTokenVO = new AuthTokenVO(this.getClientHost(), NodeVersion.V10, authToken);
            DocumentList documentList = null;
            TransactionVO transactionVO = new TransactionVO();
            documentList = DocumentConverter.CdxToDocumentList((NodeDocument[])documents.value, (String)dataflow);
            transactionVO.setTransactionID(transid);
            WSServerServiceRemote bean = this.getServerBean();
            documentList = bean.download(authTokenVO, documentList, transactionVO);
            documents.value = DocumentConverter.DocumentListToCdx((DocumentList)documentList, (int)1);
        }
        catch (Exception exception) {
            log.error((Object)"Download Failed", (Throwable)exception);
            AxisFault fault = FaultHandler.exceptionToAxisFault((Exception)exception);
            throw fault;
        }
        finally {
            log.info((Object)"******** download() - End ********");
        }
    }

    public String notify(String authToken, String nodeAddress, String dataFlow, NodeDocument[] documents) throws RemoteException {
        log.info((Object)"******** notify() - Start ********");
        try {
            String transactionId = null;
            DocumentList documentList = null;
            AuthTokenVO authTokenVO = new AuthTokenVO(this.getClientHost(), NodeVersion.V10, authToken);
            documentList = DocumentConverter.CdxToDocumentList((NodeDocument[])documents, (String)dataFlow);
            WSServerServiceRemote bean = this.getServerBean();
            String string = transactionId = bean.notify(authTokenVO, nodeAddress, dataFlow, documentList);
            return string;
        }
        catch (Exception exception) {
            log.error((Object)"Notify Failed", (Throwable)exception);
            AxisFault fault = FaultHandler.exceptionToAxisFault((Exception)exception);
            throw fault;
        }
        finally {
            log.info((Object)"******** notify() - End ********");
        }
    }

    public String solicit(String authToken, String returnURL, String serviceName, String[] parameters) throws RemoteException {
        log.info((Object)"******** solicit() - Start ********");
        try {
            if (returnURL == null) {
                throw new RemoteException("returnURL parameter must contain the Transaction ID from CDX");
            }
            TransactionVO transactionVO = null;
            AuthTokenVO authTokenVO = new AuthTokenVO(this.getClientHost(), NodeVersion.V10, authToken);
            AuthorizationVO authVO = new AuthorizationVO();
            authVO.setDataFlow("WQX");
            authVO.setMethod(Methods.QUERY);
            authVO.setRequest(serviceName);
            authVO.setParameters(parameters);
            authTokenVO.setAuthorizationVO(authVO);
            QueryVO queryVO = new QueryVO(returnURL, serviceName, parameters, new TaskTypeVO("DATA_FLOW_ASYNC_QUERY"), "Solicit");
            WSServerServiceRemote bean = this.getServerBean();
            transactionVO = bean.solicit(authTokenVO, queryVO);
            String string = transactionVO.getTransactionID();
            return string;
        }
        catch (Exception exception) {
            log.error((Object)"Solicit Failed", (Throwable)exception);
            AxisFault fault = FaultHandler.exceptionToAxisFault((Exception)exception);
            throw fault;
        }
        finally {
            log.info((Object)"******** solicit() - End ********");
        }
    }

    public String query(String authToken, String request, BigInteger rowId, BigInteger maxRows, String[] parameters) throws RemoteException {
        log.info((Object)"******** query() - Start ********");
        try {
            String result = null;
            Object transactionID = null;
            QueryVO queryVO = null;
            AuthTokenVO authTokenVO = new AuthTokenVO(this.getClientHost(), NodeVersion.V10, authToken);
            AuthorizationVO authVO = new AuthorizationVO();
            authVO.setDataFlow("WQX");
            authVO.setMethod(Methods.QUERY);
            authVO.setRequest(request);
            authVO.setParameters(parameters);
            authTokenVO.setAuthorizationVO(authVO);
            queryVO = new QueryVO(null, request, parameters, new TaskTypeVO("DATA_FLOW_QUERY"), "Query");
            WSServerServiceRemote bean = this.getServerBean();
            byte[] data = bean.query(authTokenVO, queryVO);
            String string = result = new String(data);
            return string;
        }
        catch (Exception exception) {
            log.error((Object)"Query Failed", (Throwable)exception);
            AxisFault fault = FaultHandler.exceptionToAxisFault((Exception)exception);
            throw fault;
        }
        finally {
            log.info((Object)"******** query() - End ********");
        }
    }

    public String execute(String authToken, String request, String[] parameters) throws RemoteException {
        log.warn((Object)"Execute is not supported by WQX Node");
        AxisFault fault = FaultHandler.getFault((String)"Client", (String)"Execute is not supported by WQX Node", (FaultErrorCode)FaultErrorCode.FEATURE_UNSUPPORTED);
        throw fault;
    }

    public String nodePing(String hello) throws RemoteException {
        return "Ready";
    }

    public String[] getServices(String authToken, String service) throws RemoteException {
        log.info((Object)"******** getServices() - Start ********");
        try {
            String[] services = null;
            ServiceTypes serviceType = null;
            serviceType = ServiceTypes.getServiceTypesById((String)service);
            if (serviceType == null) {
                serviceType = ServiceTypes.UNKNOWN;
            }
            AuthTokenVO authTokenVO = null;
            authTokenVO = new AuthTokenVO(this.getClientHost(), NodeVersion.V10, authToken);
            WSServerServiceRemote bean = this.getServerBean();
            String[] stringArray = services = bean.getServices(authTokenVO, serviceType);
            return stringArray;
        }
        catch (Exception exception) {
            log.error((Object)"getServices Failed", (Throwable)exception);
            AxisFault fault = FaultHandler.exceptionToAxisFault((Exception)exception);
            throw fault;
        }
        finally {
            log.info((Object)"******** getServices() - Start ********");
        }
    }

    private WSServerServiceRemote getServerBean() throws CDXException {
        return WSServerServiceUtil.getRemote();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

