/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import org.apache.commons.beanutils.ConversionException;

public abstract class AbstractHeaderCheck
extends Check {
    private String[] mHeaderLines;

    protected String[] getHeaderLines() {
        return this.mHeaderLines;
    }

    public void setHeaderFile(String aFileName) throws ConversionException {
        if (aFileName == null || aFileName.trim().length() == 0) {
            return;
        }
        try {
            String l;
            LineNumberReader lnr = new LineNumberReader(new FileReader(aFileName));
            ArrayList<String> lines = new ArrayList<String>();
            while ((l = lnr.readLine()) != null) {
                lines.add(l);
            }
            this.mHeaderLines = lines.toArray(new String[0]);
        }
        catch (IOException ex) {
            throw new ConversionException("unable to load header file " + aFileName, (Throwable)ex);
        }
    }

    protected final void finishLocalSetup() throws CheckstyleException {
        if (this.mHeaderLines == null) {
            throw new CheckstyleException("property 'headerFile' is missing or invalid in module " + this.getConfiguration().getName());
        }
    }

    public final int[] getDefaultTokens() {
        return new int[0];
    }
}

