/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.beanutils.ConversionException;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class HiddenFieldCheck
extends Check {
    private LinkedList mFieldsStack = new LinkedList();
    private RE mRegexp;
    private boolean mIgnoreSetter;
    private boolean mIgnoreConstructorParameter;

    public int[] getDefaultTokens() {
        return new int[]{10, 21, 14};
    }

    public int[] getAcceptableTokens() {
        return new int[]{10, 21};
    }

    public int[] getRequiredTokens() {
        return new int[]{14};
    }

    public void beginTree(DetailAST aRootAST) {
        this.mFieldsStack.clear();
    }

    public void visitToken(DetailAST aAST) {
        if (aAST.getType() == 14) {
            FieldFrame frame = new FieldFrame();
            DetailAST objBlock = aAST.findFirstToken(6);
            for (DetailAST child = (DetailAST)objBlock.getFirstChild(); child != null; child = (DetailAST)child.getNextSibling()) {
                if (child.getType() != 10) continue;
                String name = child.findFirstToken(58).getText();
                DetailAST mods = child.findFirstToken(5);
                if (mods.branchContains(64)) {
                    frame.addStaticField(name);
                    continue;
                }
                frame.addInstanceField(name);
            }
            this.mFieldsStack.addLast(frame);
        } else {
            this.processVariable(aAST);
        }
    }

    public void leaveToken(DetailAST aAST) {
        if (aAST.getType() == 14) {
            this.mFieldsStack.removeLast();
        }
    }

    private void processVariable(DetailAST aAST) {
        if (!ScopeUtils.inInterfaceBlock(aAST) && (ScopeUtils.isLocalVariableDef(aAST) || aAST.getType() == 21)) {
            DetailAST nameAST = aAST.findFirstToken(58);
            String name = nameAST.getText();
            boolean inStatic = this.inStatic(aAST);
            Iterator it = this.mFieldsStack.iterator();
            while (it.hasNext()) {
                FieldFrame frame = (FieldFrame)it.next();
                if (!frame.containsStaticField(name) && (inStatic || !frame.containsInstanceField(name)) || this.mRegexp != null && this.getRegexp().match(name) || this.isIgnoredSetterParam(aAST, name) || this.isIgnoredConstructorParam(aAST)) continue;
                this.log(nameAST.getLineNo(), nameAST.getColumnNo(), "hidden.field", (Object)name);
                break;
            }
        }
    }

    private boolean inStatic(DetailAST aAST) {
        for (DetailAST parent = aAST.getParent(); parent != null; parent = parent.getParent()) {
            switch (parent.getType()) {
                case 12: {
                    return true;
                }
                case 9: {
                    DetailAST mods = parent.findFirstToken(5);
                    return mods.branchContains(64);
                }
            }
        }
        return false;
    }

    private boolean isIgnoredSetterParam(DetailAST aAST, String aName) {
        if (aAST.getType() != 21 || !this.mIgnoreSetter) {
            return false;
        }
        DetailAST parametersAST = aAST.getParent();
        if (parametersAST.getChildCount() != 1) {
            return false;
        }
        DetailAST methodAST = parametersAST.getParent();
        if (methodAST.getType() != 9) {
            return false;
        }
        String expectedName = "set" + aName.substring(0, 1).toUpperCase() + aName.substring(1);
        DetailAST methodNameAST = methodAST.findFirstToken(58);
        String methodName = methodNameAST.getText();
        if (!methodName.equals(expectedName)) {
            return false;
        }
        DetailAST typeAST = methodAST.findFirstToken(13);
        return typeAST.branchContains(49);
    }

    private boolean isIgnoredConstructorParam(DetailAST aAST) {
        if (aAST.getType() != 21 || !this.mIgnoreConstructorParameter) {
            return false;
        }
        DetailAST parametersAST = aAST.getParent();
        DetailAST constructorAST = parametersAST.getParent();
        return constructorAST.getType() == 8;
    }

    public void setIgnoreFormat(String aFormat) throws ConversionException {
        try {
            this.mRegexp = Utils.getRE(aFormat);
        }
        catch (RESyntaxException e) {
            throw new ConversionException("unable to parse " + aFormat, (Throwable)e);
        }
    }

    public void setIgnoreSetter(boolean aIgnoreSetter) {
        this.mIgnoreSetter = aIgnoreSetter;
    }

    public void setIgnoreConstructorParameter(boolean aIgnoreConstructorParameter) {
        this.mIgnoreConstructorParameter = aIgnoreConstructorParameter;
    }

    public RE getRegexp() {
        return this.mRegexp;
    }

    private class FieldFrame {
        private Set mInstanceFields = new HashSet();
        private Set mStaticFields = new HashSet();

        private FieldFrame() {
        }

        public void addInstanceField(String aField) {
            this.mInstanceFields.add(aField);
        }

        public void addStaticField(String aField) {
            this.mStaticFields.add(aField);
        }

        public boolean containsInstanceField(String aField) {
            return this.mInstanceFields.contains(aField);
        }

        public boolean containsStaticField(String aField) {
            return this.mStaticFields.contains(aField);
        }
    }
}

