/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.beanutils.ConversionException;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class VisibilityModifierCheck
extends Check {
    private boolean mProtectedAllowed;
    private boolean mPackageAllowed;
    private String mPublicMemberPattern = "^serialVersionUID$";
    private RE mPublicMemberRE;

    public VisibilityModifierCheck() {
        this.setPublicMemberPattern(this.mPublicMemberPattern);
    }

    public boolean isProtectedAllowed() {
        return this.mProtectedAllowed;
    }

    public void setProtectedAllowed(boolean aProtectedAllowed) {
        this.mProtectedAllowed = aProtectedAllowed;
    }

    public boolean isPackageAllowed() {
        return this.mPackageAllowed;
    }

    public void setPackageAllowed(boolean aPackageAllowed) {
        this.mPackageAllowed = aPackageAllowed;
    }

    public void setPublicMemberPattern(String aPattern) {
        try {
            this.mPublicMemberRE = Utils.getRE(aPattern);
            this.mPublicMemberPattern = aPattern;
        }
        catch (RESyntaxException e) {
            throw new ConversionException("unable to parse " + aPattern, (Throwable)e);
        }
    }

    private RE getPublicMemberRegexp() {
        return this.mPublicMemberRE;
    }

    public int[] getDefaultTokens() {
        return new int[]{10};
    }

    public void visitToken(DetailAST aAST) {
        String variableScope;
        if (aAST.getType() != 10 || aAST.getParent().getType() != 6) {
            return;
        }
        DetailAST varNameAST = this.getVarNameAST(aAST);
        String varName = varNameAST.getText();
        boolean inInterfaceBlock = this.inInterfaceBlock(aAST);
        Set mods = this.getModifiers(aAST);
        String declaredScope = this.getVisibilityScope(mods);
        String string = variableScope = inInterfaceBlock ? "public" : declaredScope;
        if (!("private".equals(variableScope) || inInterfaceBlock || mods.contains("static") && mods.contains("final") || "package".equals(variableScope) && this.isPackageAllowed() || "protected".equals(variableScope) && this.isProtectedAllowed() || "public".equals(variableScope) && this.getPublicMemberRegexp().match(varName))) {
            this.log(varNameAST.getLineNo(), varNameAST.getColumnNo(), "variable.notPrivate", (Object)varName);
        }
    }

    private DetailAST getVarNameAST(DetailAST aVariableDefAST) {
        AST ast = aVariableDefAST.getFirstChild();
        while (ast != null) {
            AST nextSibling = ast.getNextSibling();
            if (ast.getType() == 13) {
                return (DetailAST)nextSibling;
            }
            ast = nextSibling;
        }
        return null;
    }

    private boolean inInterfaceBlock(DetailAST aAST) {
        for (DetailAST ast = aAST.getParent(); ast != null; ast = ast.getParent()) {
            switch (ast.getType()) {
                case 15: {
                    return true;
                }
                case 14: {
                    return false;
                }
            }
        }
        return false;
    }

    private Set getModifiers(DetailAST aVariableDefAST) {
        AST modifiersAST = aVariableDefAST.getFirstChild();
        if (modifiersAST.getType() != 5) {
            throw new IllegalStateException("Strange parse tree");
        }
        HashSet<String> retVal = new HashSet<String>();
        for (AST modifier = modifiersAST.getFirstChild(); modifier != null; modifier = modifier.getNextSibling()) {
            retVal.add(modifier.getText());
        }
        return retVal;
    }

    private String getVisibilityScope(Set aModifiers) {
        String[] explicitModifiers = new String[]{"public", "private", "protected"};
        for (int i = 0; i < explicitModifiers.length; ++i) {
            String candidate = explicitModifiers[i];
            if (!aModifiers.contains(candidate)) continue;
            return candidate;
        }
        return "package";
    }
}

