/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTag;
import java.util.Vector;
import org.apache.commons.beanutils.ConversionException;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class JavadocTypeCheck
extends Check {
    private Scope mScope = Scope.PRIVATE;
    private Scope mExcludeScope;
    private RE mAuthorFormatRE;
    private RE mVersionFormatRE;
    private String mAuthorFormat;
    private String mVersionFormat;

    public void setScope(String aFrom) {
        this.mScope = Scope.getInstance(aFrom);
    }

    public void setExcludeScope(String aScope) {
        this.mExcludeScope = Scope.getInstance(aScope);
    }

    public void setAuthorFormat(String aFormat) throws ConversionException {
        try {
            this.mAuthorFormat = aFormat;
            this.mAuthorFormatRE = Utils.getRE(aFormat);
        }
        catch (RESyntaxException e) {
            throw new ConversionException("unable to parse " + aFormat, (Throwable)e);
        }
    }

    public void setVersionFormat(String aFormat) throws ConversionException {
        try {
            this.mVersionFormat = aFormat;
            this.mVersionFormatRE = Utils.getRE(aFormat);
        }
        catch (RESyntaxException e) {
            throw new ConversionException("unable to parse " + aFormat, (Throwable)e);
        }
    }

    public int[] getDefaultTokens() {
        return new int[]{15, 14};
    }

    public void visitToken(DetailAST aAST) {
        if (this.shouldCheck(aAST)) {
            int lineNo;
            FileContents contents = this.getFileContents();
            TextBlock cmt = contents.getJavadocBefore(lineNo = aAST.getLineNo());
            if (cmt == null) {
                this.log(lineNo, "javadoc.missing");
            } else if (ScopeUtils.isOuterMostType(aAST)) {
                Vector tags = this.getJavadocTags(cmt);
                this.checkTag(lineNo, tags, "author", this.mAuthorFormatRE, this.mAuthorFormat);
                this.checkTag(lineNo, tags, "version", this.mVersionFormatRE, this.mVersionFormat);
            }
        }
    }

    private boolean shouldCheck(DetailAST aAST) {
        DetailAST mods = aAST.findFirstToken(5);
        Scope declaredScope = ScopeUtils.getScopeFromMods(mods);
        Scope scope = ScopeUtils.inInterfaceBlock(aAST) ? Scope.PUBLIC : declaredScope;
        Scope surroundingScope = ScopeUtils.getSurroundingScope(aAST);
        return scope.isIn(this.mScope) && (surroundingScope == null || surroundingScope.isIn(this.mScope)) && (this.mExcludeScope == null || !scope.isIn(this.mExcludeScope) || surroundingScope != null && !surroundingScope.isIn(this.mExcludeScope));
    }

    private Vector getJavadocTags(TextBlock aCmt) {
        String[] text = aCmt.getText();
        Vector<JavadocTag> tags = new Vector<JavadocTag>();
        RE tagRE = Utils.getRE("/\\*{2,}\\s*@([:alpha:]+)\\s");
        for (int i = 0; i < text.length; ++i) {
            String s = text[i];
            if (tagRE.match(s)) {
                String tagName = tagRE.getParen(1);
                String content = s.substring(tagRE.getParenEnd(0));
                if (content.endsWith("*/")) {
                    content = content.substring(0, content.length() - 2);
                }
                tags.add(new JavadocTag(aCmt.getStartLineNo() + i, tagName, content.trim()));
            }
            if (i == 0) continue;
            tagRE = Utils.getRE("^\\s*\\**\\s*@([:alpha:]+)\\s");
        }
        return tags;
    }

    private void checkTag(int aLineNo, Vector aTags, String aTag, RE aFormatRE, String aFormat) {
        if (aFormatRE == null) {
            return;
        }
        int tagCount = 0;
        for (int i = aTags.size() - 1; i >= 0; --i) {
            JavadocTag tag = (JavadocTag)aTags.get(i);
            if (!tag.getTag().equals(aTag)) continue;
            ++tagCount;
            if (aFormatRE.match(tag.getArg1())) continue;
            this.log(aLineNo, "type.tagFormat", (Object)("@" + aTag), (Object)aFormat);
        }
        if (tagCount == 0) {
            this.log(aLineNo, "type.missingTag", (Object)("@" + aTag));
        }
    }
}

