/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.sizes;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Utils;
import org.apache.commons.beanutils.ConversionException;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class LineLengthCheck
extends Check {
    private static final int DEFAULT_MAX_COLUMNS = 80;
    private int mMax = 80;
    private RE mIgnorePattern;

    public LineLengthCheck() {
        this.setIgnorePattern("^$");
    }

    public int[] getDefaultTokens() {
        return new int[0];
    }

    public void beginTree(DetailAST aRootAST) {
        String[] lines = this.getLines();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            int realLength = Utils.lengthExpandedTabs(line, line.length(), this.getTabWidth());
            if (realLength <= this.mMax || this.mIgnorePattern.match(line)) continue;
            this.log(i + 1, "maxLineLen", (Object)new Integer(this.mMax));
        }
    }

    public void setMax(int aLength) {
        this.mMax = aLength;
    }

    public void setIgnorePattern(String aFormat) throws ConversionException {
        try {
            this.mIgnorePattern = Utils.getRE(aFormat);
        }
        catch (RESyntaxException e) {
            throw new ConversionException("unable to parse " + aFormat, (Throwable)e);
        }
    }
}

