/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.ws.web;

import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.util.CDXFilesList;
import gov.epa.cdx.commons.util.FileManager;
import gov.epa.cdx.ws.web.InitServlet;
import java.io.File;
import java.util.Date;
import java.util.Iterator;
import java.util.TimerTask;

class CleanupTask
extends TimerTask {
    private String logDir = null;
    private int dayLimit;

    public CleanupTask(String logDir, int limit) {
        this.logDir = logDir;
        this.dayLimit = limit;
    }

    public void stop() {
    }

    public void run() {
        InitServlet.log.debug((Object)("CleanupTask started at [" + System.currentTimeMillis() + "] \n\t for directory [" + this.logDir + "]"));
        long longDayLimit = System.currentTimeMillis() - (long)(this.dayLimit * 24 * 60 * 60 * 1000);
        InitServlet.log.debug((Object)("checking for file older than [" + longDayLimit + "]"));
        try {
            CDXFilesList logfiles = FileManager.getFilesListFromDirectory((String)this.logDir);
            Iterator iter = logfiles.getFiles().iterator();
            while (iter.hasNext()) {
                File fo;
                Object o = iter.next();
                if (!(o instanceof File) || (fo = (File)o).lastModified() >= longDayLimit) continue;
                InitServlet.log.debug((Object)("removing file [" + fo.getName() + "] [" + fo.lastModified() + "] is date " + new Date(fo.lastModified())));
                fo.delete();
            }
        }
        catch (CDXException e) {
            InitServlet.log.error((Object)("CleanupTask error: " + e.getMessage()), (Throwable)e);
        }
        catch (Throwable ex) {
            InitServlet.log.error((Object)("unknown error: " + ex.getMessage()), ex);
        }
        InitServlet.log.debug((Object)("CleanupTask ended at [" + System.currentTimeMillis() + "]"));
    }
}

