/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.ws.web;

import gov.epa.cdx.commons.property.CDXPropertyManager;
import gov.epa.cdx.ws.web.CleanupTask;
import gov.epa.cdx.ws.web.LogCleanUpUtil;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InitServlet
extends HttpServlet {
    private static final String CONFIG_FILE = "wsnode_properties.xml";
    private static final String LOG_FILE_LIFE_LIMIT_PARAM = "logFileLifeLimit";
    private static final int LOG_FILE_LIFE_LIMIT_VALUE_DEFAULT = 20;
    protected static Log log = LogFactory.getLog((String)(class$gov$epa$cdx$ws$web$InitServlet == null ? (class$gov$epa$cdx$ws$web$InitServlet = InitServlet.class$("gov.epa.cdx.ws.web.InitServlet")) : class$gov$epa$cdx$ws$web$InitServlet).getName());
    private Timer timer = null;
    static /* synthetic */ Class class$gov$epa$cdx$ws$web$InitServlet;

    public void init() throws ServletException {
        CDXPropertyManager.init((String)CDXPropertyManager.GLOBAL_CONFIG_FILE, (String)CONFIG_FILE);
        CDXPropertyManager.loadProperties();
        boolean useLocal = false;
        String configDir = LogCleanUpUtil.formatFileName(System.getProperty("app.WSNode.dir"));
        if (configDir.charAt(configDir.length() - 1) != '/') {
            configDir = configDir + '/';
        }
        configDir = "j2ee home";
        String logFileLifeLimit = CDXPropertyManager.getGlobalProperty((String)LOG_FILE_LIFE_LIMIT_PARAM);
        log.debug((Object)("InitServlet.init started with config directory [" + configDir + "] and log limit of [" + logFileLifeLimit + "]"));
        int dayLogFileLifeLimit = 20;
        try {
            dayLogFileLifeLimit = Integer.parseInt(logFileLifeLimit);
        }
        catch (Exception e) {
            dayLogFileLifeLimit = 20;
        }
        Properties p = null;
        p = LogCleanUpUtil.getLogProperty();
        if (p != null) {
            String logDirectory = LogCleanUpUtil.getLastValidDirectory(p.getProperty("log4j.appender.A1.File"));
            if (logDirectory == null) {
                log.debug((Object)"couldn't find log file directory");
            } else {
                this.timer = new Timer();
                int threadWaitTime = 1000;
                int taskRepeatTime = 86400000;
                this.timer.schedule((TimerTask)new CleanupTask(logDirectory, dayLogFileLifeLimit), threadWaitTime, (long)taskRepeatTime);
            }
        }
    }

    public void destroy() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        super.destroy();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

