/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.admin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class Entry {
    public static final String DUMMY_TIMESTAMP = "dummy timestamp";
    public static final String DUMMY_TIMESTAMP_NEW_ENTRY = "dummy timestamp from new-entry";
    public static final String MERGE_TIMESTAMP = "Result of merge";
    private static final String TAG = "T";
    private static final String DATE = "D";
    private static SimpleDateFormat stickyDateFormatter;
    private static final String BINARY_FILE = "-kb";
    private static final String NO_USER_FILE = "";
    private static final String NEW_USER_FILE = "0";
    private static final String REMOVE_USER_FILE = "-";
    private static SimpleDateFormat lastModifiedDateFormatter;
    public static final char HAD_CONFLICTS = '+';
    public static final char TIMESTAMP_MATCHES_FILE = '=';
    private static final String DIRECTORY_PREFIX = "D/";
    private String name;
    private String revision;
    private String conflict;
    private Date lastModified;
    private String options;
    private String tag;
    private Date date;
    private boolean directory;

    private static SimpleDateFormat getStickyDateFormatter() {
        if (stickyDateFormatter == null) {
            stickyDateFormatter = new SimpleDateFormat("yyyy.MM.dd.hh.mm.ss");
        }
        return stickyDateFormatter;
    }

    public static SimpleDateFormat getLastModifiedDateFormatter() {
        if (lastModifiedDateFormatter == null) {
            lastModifiedDateFormatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.US);
            lastModifiedDateFormatter.setTimeZone(TimeZone.getTimeZone("GMT+0000"));
        }
        return lastModifiedDateFormatter;
    }

    public Entry(String entryLine) {
        this.init(entryLine);
    }

    public Entry() {
    }

    protected void init(String entryLine) {
        if (entryLine.startsWith(DIRECTORY_PREFIX)) {
            this.directory = true;
            entryLine = entryLine.substring(1);
        }
        int[] slashPositions = new int[5];
        try {
            slashPositions[0] = 0;
            for (int i = 1; i < 5; ++i) {
                slashPositions[i] = entryLine.indexOf(47, slashPositions[i - 1] + 1);
            }
            if (slashPositions[1] > 0) {
                this.name = entryLine.substring(slashPositions[0] + 1, slashPositions[1]);
                this.revision = entryLine.substring(slashPositions[1] + 1, slashPositions[2]);
                if (slashPositions[3] - slashPositions[2] > 1) {
                    String conflict = entryLine.substring(slashPositions[2] + 1, slashPositions[3]);
                    this.setConflict(conflict);
                }
                if (slashPositions[4] - slashPositions[3] > 1) {
                    this.options = entryLine.substring(slashPositions[3] + 1, slashPositions[4]);
                }
                if (slashPositions[4] != entryLine.length() - 1) {
                    String tagOrDate = entryLine.substring(slashPositions[4] + 1);
                    if (tagOrDate.startsWith(TAG)) {
                        this.setTag(tagOrDate.substring(1));
                    } else if (tagOrDate.startsWith(DATE)) {
                        try {
                            String dateString = tagOrDate.substring(DATE.length());
                            Date stickyDate = Entry.getStickyDateFormatter().parse(dateString);
                            this.setDate(stickyDate);
                        }
                        catch (ParseException exc) {
                            System.err.println("We got another inconsistency in the library's date formatting.");
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error parsing entry line: " + e);
            e.printStackTrace();
            throw new IllegalArgumentException("Invalid entry line: " + entryLine);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public String getConflict() {
        return this.conflict;
    }

    public void setConflict(String conflict) {
        this.conflict = conflict;
        this.lastModified = null;
        if (conflict == null || conflict.equals(DUMMY_TIMESTAMP) || conflict.equals(MERGE_TIMESTAMP) || conflict.equals(DUMMY_TIMESTAMP_NEW_ENTRY)) {
            return;
        }
        String dateString = conflict;
        int conflictIndex = dateString.indexOf(43);
        if (conflictIndex >= 0) {
            int timeMatchIndex = dateString.indexOf(61);
            conflictIndex = Math.max(conflictIndex, timeMatchIndex);
        }
        if (conflictIndex >= 0) {
            dateString = dateString.substring(conflictIndex + 1);
        }
        if (dateString.length() == 0) {
            return;
        }
        try {
            this.lastModified = Entry.getLastModifiedDateFormatter().parse(dateString);
        }
        catch (Exception ex) {
            this.lastModified = null;
        }
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public String getStickyInformation() {
        if (this.tag != null) {
            return this.tag;
        }
        return this.getDateFormatted();
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag2) {
        this.tag = tag2;
        this.date = null;
    }

    public Date getDate() {
        return this.date;
    }

    public String getDateFormatted() {
        if (this.getDate() == null) {
            return null;
        }
        SimpleDateFormat format = Entry.getStickyDateFormatter();
        String dateFormatted = format.format(this.getDate());
        return dateFormatted;
    }

    public void setDate(Date date) {
        this.date = date;
        this.tag = null;
    }

    public boolean hasDate() {
        return this.date != null;
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    public boolean isBinary() {
        return this.options != null && this.options.equals(BINARY_FILE);
    }

    public boolean isNoUserFile() {
        return this.revision == null || this.revision.equals(NO_USER_FILE);
    }

    public boolean isNewUserFile() {
        return this.revision != null && this.revision.startsWith(NEW_USER_FILE);
    }

    public boolean isUserFileToBeRemoved() {
        return this.revision != null && this.revision.startsWith(REMOVE_USER_FILE);
    }

    public boolean isValid() {
        return this.getName() != null && this.getName().length() > 0;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public void setDirectory(boolean directory) {
        this.directory = directory;
    }

    public boolean hadConflicts() {
        if (this.conflict != null) {
            return this.conflict.indexOf(43) >= 0;
        }
        return false;
    }

    public boolean timestampMatchesFile() {
        return this.conflict.charAt(1) == '=';
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.directory) {
            buf.append(DIRECTORY_PREFIX);
        } else {
            buf.append('/');
        }
        if (this.name != null) {
            buf.append(this.name);
            buf.append('/');
            if (this.revision != null) {
                buf.append(this.revision);
            }
            buf.append('/');
            if (this.conflict != null) {
                buf.append(this.conflict);
            }
            buf.append('/');
            if (this.options != null) {
                buf.append(this.options);
            }
            buf.append('/');
            if (this.tag != null && this.date == null) {
                buf.append(TAG);
                buf.append(this.getTag());
            } else if (this.tag == null && this.date != null) {
                String dateString = this.getDateFormatted();
                buf.append(DATE);
                buf.append(dateString);
            }
        }
        return buf.toString();
    }
}

