/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.tag;

import java.io.EOFException;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.RepositoryCommand;
import org.netbeans.lib.cvsclient.command.tag.TagBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;

public class RtagCommand
extends RepositoryCommand {
    private EventManager eventManager;
    private boolean clearFromRemoved;
    private boolean deleteTag;
    private boolean makeBranchTag;
    private boolean overrideExistingTag;
    private boolean matchHeadIfRevisionNotFound;
    private boolean noExecTagProgram;
    private String tag;
    private String tagByDate;
    private String tagByRevision;

    public Builder createBuilder(EventManager eventManager) {
        return new TagBuilder(eventManager, this.getLocalDirectory());
    }

    public boolean isClearFromRemoved() {
        return this.clearFromRemoved;
    }

    public void setClearFromRemoved(boolean clearFromRemoved) {
        this.clearFromRemoved = clearFromRemoved;
    }

    public boolean isDeleteTag() {
        return this.deleteTag;
    }

    public void setDeleteTag(boolean deleteTag) {
        this.deleteTag = deleteTag;
    }

    public boolean isMakeBranchTag() {
        return this.makeBranchTag;
    }

    public void setMakeBranchTag(boolean makeBranchTag) {
        this.makeBranchTag = makeBranchTag;
    }

    public boolean isOverrideExistingTag() {
        return this.overrideExistingTag;
    }

    public void setOverrideExistingTag(boolean overrideExistingTag) {
        this.overrideExistingTag = overrideExistingTag;
    }

    public boolean isMatchHeadIfRevisionNotFound() {
        return this.matchHeadIfRevisionNotFound;
    }

    public void setMatchHeadIfRevisionNotFound(boolean matchHeadIfRevisionNotFound) {
        this.matchHeadIfRevisionNotFound = matchHeadIfRevisionNotFound;
    }

    public boolean isNoExecTagProgram() {
        return this.noExecTagProgram;
    }

    public void setNoExecTagProgram(boolean noExecTagProgram) {
        this.noExecTagProgram = noExecTagProgram;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag2) {
        this.tag = tag2;
    }

    public String getTagByDate() {
        return this.tagByDate;
    }

    public void setTagByDate(String tagDate) {
        this.tagByDate = tagDate;
    }

    public String getTagByRevision() {
        return this.tagByRevision;
    }

    public void setTagByRevision(String tagRevision) {
        this.tagByRevision = tagRevision;
    }

    protected void postExpansionExecute(ClientServices client, EventManager eventManager) throws CommandException, AuthenticationException {
        client.ensureConnection();
        this.eventManager = eventManager;
        try {
            if (this.clearFromRemoved) {
                this.requests.add(new ArgumentRequest("-a"));
            }
            if (this.overrideExistingTag) {
                this.requests.add(new ArgumentRequest("-F"));
            }
            if (this.matchHeadIfRevisionNotFound) {
                this.requests.add(new ArgumentRequest("-f"));
            }
            if (this.makeBranchTag) {
                this.requests.add(new ArgumentRequest("-b"));
            }
            if (this.deleteTag) {
                this.requests.add(new ArgumentRequest("-d"));
            }
            if (this.noExecTagProgram) {
                this.requests.add(new ArgumentRequest("-n "));
            }
            if (this.tagByDate != null && this.tagByDate.length() > 0) {
                this.requests.add(new ArgumentRequest("-D"));
                this.requests.add(new ArgumentRequest(this.getTagByDate()));
            }
            if (this.tagByRevision != null && this.tagByRevision.length() > 0) {
                this.requests.add(new ArgumentRequest("-r"));
                this.requests.add(new ArgumentRequest(this.getTagByRevision()));
            }
            this.requests.add(new ArgumentRequest(this.getTag()));
            this.addArgumentRequests();
            this.addRequest(CommandRequest.RTAG);
            client.processRequests(this.requests);
        }
        catch (CommandException ex) {
            throw ex;
        }
        catch (EOFException ex) {
            throw new CommandException(ex, CommandException.getLocalMessage("CommandException.EndOfFile", null));
        }
        catch (Exception ex) {
            throw new CommandException(ex, ex.getLocalizedMessage());
        }
        finally {
            this.requests.clear();
        }
    }

    public void commandTerminated(TerminationEvent e) {
        if (this.builder != null) {
            this.builder.outputDone();
        }
    }

    public String getCVSCommand() {
        StringBuffer toReturn = new StringBuffer("rtag ");
        toReturn.append(this.getCVSArguments());
        if (this.getTag() != null) {
            toReturn.append(this.getTag());
            toReturn.append(" ");
        }
        this.appendModuleArguments(toReturn);
        return toReturn.toString();
    }

    public boolean setCVSCommand(char opt, String optArg) {
        if (opt == 'R') {
            this.setRecursive(true);
        } else if (opt == 'l') {
            this.setRecursive(false);
        } else if (opt == 'a') {
            this.setClearFromRemoved(true);
        } else if (opt == 'd') {
            this.setDeleteTag(true);
        } else if (opt == 'F') {
            this.setOverrideExistingTag(true);
        } else if (opt == 'f') {
            this.setMatchHeadIfRevisionNotFound(true);
        } else if (opt == 'b') {
            this.setMakeBranchTag(true);
        } else if (opt == 'n') {
            this.setNoExecTagProgram(true);
        } else if (opt == 'D') {
            this.setTagByDate(optArg.trim());
        } else if (opt == 'r') {
            this.setTagByRevision(optArg.trim());
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "RlaFfbdnD:r:";
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setClearFromRemoved(false);
        this.setDeleteTag(false);
        this.setMakeBranchTag(false);
        this.setOverrideExistingTag(false);
        this.setMatchHeadIfRevisionNotFound(false);
        this.setNoExecTagProgram(false);
    }

    public String getCVSArguments() {
        StringBuffer toReturn = new StringBuffer();
        if (!this.isRecursive()) {
            toReturn.append("-l ");
        }
        if (this.isClearFromRemoved()) {
            toReturn.append("-a ");
        }
        if (this.isOverrideExistingTag()) {
            toReturn.append("-F ");
        }
        if (this.isMatchHeadIfRevisionNotFound()) {
            toReturn.append("-f ");
        }
        if (this.isMakeBranchTag()) {
            toReturn.append("-b ");
        }
        if (this.isDeleteTag()) {
            toReturn.append("-d ");
        }
        if (this.isNoExecTagProgram()) {
            toReturn.append("-n ");
        }
        if (this.getTagByRevision() != null && this.getTagByRevision().length() > 0) {
            toReturn.append("-r ");
            toReturn.append(this.getTagByRevision());
            toReturn.append(" ");
        }
        if (this.getTagByDate() != null && this.getTagByDate().length() > 0) {
            toReturn.append("-D ");
            toReturn.append(this.getTagByDate());
            toReturn.append(" ");
        }
        return toReturn.toString();
    }
}

