/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.commandLine;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.commandLine.command.CommandProvider;

public class CommandFactory {
    private static final String[] COMMAND_CLASSES = new String[]{"Import", "add", "annotate", "checkout", "commit", "diff", "export", "locbundlecheck", "log", "rannotate", "remove", "rlog", "rtag", "status", "tag", "update"};
    private static CommandFactory instance;
    private Map commandProvidersByNames;
    static /* synthetic */ Class class$org$netbeans$lib$cvsclient$commandLine$CommandFactory;

    private CommandFactory() {
        this.createCommandProviders();
    }

    private void createCommandProviders() {
        this.commandProvidersByNames = new HashMap();
        String packageName = (class$org$netbeans$lib$cvsclient$commandLine$CommandFactory == null ? (class$org$netbeans$lib$cvsclient$commandLine$CommandFactory = CommandFactory.class$("org.netbeans.lib.cvsclient.commandLine.CommandFactory")) : class$org$netbeans$lib$cvsclient$commandLine$CommandFactory).getPackage().getName() + ".command.";
        for (int i = 0; i < COMMAND_CLASSES.length; ++i) {
            try {
                Class<?> providerClass = Class.forName(packageName + COMMAND_CLASSES[i]);
                CommandProvider provider = (CommandProvider)providerClass.newInstance();
                this.commandProvidersByNames.put(provider.getName(), provider);
                String[] synonyms = provider.getSynonyms();
                for (int j = 0; j < synonyms.length; ++j) {
                    this.commandProvidersByNames.put(synonyms[j], provider);
                }
                continue;
            }
            catch (Exception e) {
                System.err.println("Creation of command '" + COMMAND_CLASSES[i] + "' failed:");
                e.printStackTrace(System.err);
            }
        }
    }

    public static synchronized CommandFactory getDefault() {
        if (instance == null) {
            instance = new CommandFactory();
        }
        return instance;
    }

    public Command createCommand(String commandName, String[] args, int startingIndex, GlobalOptions gopt, String workingDir) throws IllegalArgumentException {
        CommandProvider provider = (CommandProvider)this.commandProvidersByNames.get(commandName);
        if (provider == null) {
            throw new IllegalArgumentException("Unknown command: '" + commandName + "'");
        }
        return provider.createCommand(args, startingIndex, gopt, workingDir);
    }

    public CommandProvider getCommandProvider(String name) {
        return (CommandProvider)this.commandProvidersByNames.get(name);
    }

    public CommandProvider[] getCommandProviders() {
        HashSet providers = new HashSet(this.commandProvidersByNames.values());
        return providers.toArray(new CommandProvider[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

