/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.impl.ScriptBlock;
import org.apache.commons.jelly.impl.StaticTagScript;
import org.apache.commons.jelly.impl.TagScript;
import org.apache.commons.jelly.tags.xml.ParamTag;
import org.apache.commons.jelly.tags.xml.ParseTag;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class TransformTag
extends ParseTag {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jelly$tags$xml$TransformTag == null ? (class$org$apache$commons$jelly$tags$xml$TransformTag = TransformTag.class$("org.apache.commons.jelly.tags.xml.TransformTag")) : class$org$apache$commons$jelly$tags$xml$TransformTag));
    private static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    private Object xslt;
    private SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
    private TransformerHandler transformerHandler;
    static /* synthetic */ Class class$org$apache$commons$jelly$tags$xml$TransformTag;

    public void doTag(XMLOutput output) throws MissingAttributeException, JellyTagException {
        if (null == this.getXslt()) {
            throw new MissingAttributeException("The xslt attribute cannot be null");
        }
        this.tf.setURIResolver(this.createURIResolver());
        try {
            this.transformerHandler = this.tf.newTransformerHandler(this.getObjAsSAXSource(this.getXslt()));
        }
        catch (TransformerConfigurationException e) {
            throw new JellyTagException((Throwable)e);
        }
        this.doNestedParamTag(output);
        try {
            XMLReader xmlReader = this.createXMLReader();
            xmlReader.setContentHandler(this.transformerHandler);
            xmlReader.setProperty(LEXICAL_HANDLER_PROPERTY, this.transformerHandler);
            String varName = this.getVar();
            if (null == varName) {
                this.transformerHandler.setResult(this.createSAXResult(output));
                xmlReader.parse(this.getXMLInputSource());
            } else {
                DocumentResult result = new DocumentResult();
                this.transformerHandler.setResult((Result)result);
                xmlReader.parse(this.getXMLInputSource());
                Document transformedDoc = result.getDocument();
                this.context.setVariable(varName, (Object)transformedDoc);
            }
        }
        catch (SAXException e) {
            throw new JellyTagException((Throwable)e);
        }
        catch (IOException e) {
            throw new JellyTagException((Throwable)e);
        }
    }

    public Object getXslt() {
        return this.xslt;
    }

    public void setXslt(Object xslt) {
        this.xslt = xslt;
    }

    public void setParameterValue(String name, Object value) {
        this.transformerHandler.getTransformer().setParameter(name, value);
    }

    protected URIResolver createURIResolver() {
        return new URIResolver(){

            public Source resolve(String href, String base) throws TransformerException {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("base: " + base + " href: " + href));
                }
                if (null == href) {
                    return null;
                }
                return new StreamSource(TransformTag.this.context.getResourceAsStream(href));
            }
        };
    }

    protected Result createSAXResult(XMLOutput output) {
        SAXResult result = new SAXResult((ContentHandler)output);
        result.setLexicalHandler((LexicalHandler)output);
        return result;
    }

    protected XMLReader createXMLReader() throws SAXException {
        XMLReader xmlReader = null;
        Object xmlReaderSourceObj = this.getXml();
        xmlReader = null == xmlReaderSourceObj ? new TagBodyXMLReader((Tag)this) : XMLReaderFactory.createXMLReader();
        return xmlReader;
    }

    protected InputSource getXMLInputSource() {
        InputSource xmlInputSource = null;
        Object xmlInputSourceObj = this.getXml();
        xmlInputSource = null == xmlInputSourceObj ? new TagBodyInputSource() : this.getInputSourceFromObj(xmlInputSourceObj);
        return xmlInputSource;
    }

    protected SAXSource getObjAsSAXSource(Object saxSourceObj) {
        Object saxSource = null;
        if (null != saxSourceObj) {
            if (saxSourceObj instanceof Document) {
                saxSource = new DocumentSource((Document)saxSourceObj);
            } else {
                InputSource xmlInputSource = this.getInputSourceFromObj(saxSourceObj);
                saxSource = new SAXSource(xmlInputSource);
            }
        }
        return saxSource;
    }

    protected InputSource getInputSourceFromObj(Object sourceObj) {
        InputSource xmlInputSource = null;
        if (sourceObj instanceof Document) {
            DocumentSource saxSource = new DocumentSource((Document)sourceObj);
            xmlInputSource = saxSource.getInputSource();
        } else if (sourceObj instanceof String) {
            String uri = (String)sourceObj;
            xmlInputSource = new InputSource(this.context.getResourceAsStream(uri));
        } else if (sourceObj instanceof Reader) {
            xmlInputSource = new InputSource((Reader)sourceObj);
        } else if (sourceObj instanceof InputStream) {
            xmlInputSource = new InputSource((InputStream)sourceObj);
        } else if (sourceObj instanceof URL) {
            String uri = ((URL)sourceObj).toString();
            xmlInputSource = new InputSource(this.context.getResourceAsStream(uri));
        } else if (sourceObj instanceof File) {
            try {
                String uri = ((File)sourceObj).toURL().toString();
                xmlInputSource = new InputSource(this.context.getResourceAsStream(uri));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("This should never occur. We should always be able to convert a File to a URL" + e);
            }
        } else {
            throw new IllegalArgumentException("Invalid source argument. Must be a String, Reader, InputStream or URL. Was type; " + sourceObj.getClass().getName() + " with value: " + sourceObj);
        }
        return xmlInputSource;
    }

    private void doNestedParamTag(XMLOutput output) throws JellyTagException {
        Script bodyScript = this.getBody();
        if (bodyScript instanceof ScriptBlock) {
            ScriptBlock scriptBlock = (ScriptBlock)bodyScript;
            List scriptList = scriptBlock.getScriptList();
            Iterator iter = scriptList.iterator();
            while (iter.hasNext()) {
                Script script = (Script)iter.next();
                if (!(script instanceof TagScript)) continue;
                Tag tag = null;
                try {
                    tag = ((TagScript)script).getTag();
                }
                catch (JellyException e) {
                    throw new JellyTagException((Throwable)e);
                }
                if (!(tag instanceof ParamTag)) continue;
                script.run(this.context, output);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TagBodyInputSource
    extends InputSource {
    }

    private class TagBodyXMLReader
    implements XMLReader {
        private Tag tag;
        private XMLOutput xmlOutput;
        private DTDHandler dtdHandler;
        private ErrorHandler errorHandler;
        private EntityResolver entityResolver;

        public TagBodyXMLReader(Tag tag) {
            this.tag = tag;
            this.xmlOutput = new XMLOutput();
        }

        public void parse(InputSource input) throws IOException, SAXException {
            if (!(input instanceof TagBodyInputSource)) {
                throw new SAXException("Invalid input source");
            }
            this.doInvokeBody();
        }

        public void parse(String systemId) throws IOException, SAXException {
            this.doInvokeBody();
        }

        private void doInvokeBody() throws SAXException {
            try {
                if (this.shouldParseBody()) {
                    XMLReader anXMLReader = XMLReaderFactory.createXMLReader();
                    anXMLReader.setContentHandler((ContentHandler)this.xmlOutput);
                    anXMLReader.setProperty(TransformTag.LEXICAL_HANDLER_PROPERTY, this.xmlOutput);
                    StringWriter writer = new StringWriter();
                    this.tag.invokeBody(XMLOutput.createXMLOutput((Writer)writer));
                    StringReader reader = new StringReader(writer.toString());
                    anXMLReader.parse(new InputSource(reader));
                } else {
                    this.tag.invokeBody(this.xmlOutput);
                }
            }
            catch (Exception ex) {
                throw new SAXException(ex);
            }
        }

        private boolean shouldParseBody() {
            boolean result = false;
            Script bodyScript = this.tag.getBody();
            if (bodyScript instanceof ScriptBlock) {
                ScriptBlock scriptBlock = (ScriptBlock)bodyScript;
                List scriptList = scriptBlock.getScriptList();
                Iterator iter = scriptList.iterator();
                while (iter.hasNext()) {
                    Script script = (Script)iter.next();
                    if (!(script instanceof StaticTagScript)) continue;
                    result = true;
                    break;
                }
            }
            return result;
        }

        public ContentHandler getContentHandler() {
            return this.xmlOutput.getContentHandler();
        }

        public void setContentHandler(ContentHandler contentHandler) {
            this.xmlOutput.setContentHandler(contentHandler);
            if (contentHandler instanceof LexicalHandler) {
                this.xmlOutput.setLexicalHandler((LexicalHandler)((Object)contentHandler));
            }
        }

        public DTDHandler getDTDHandler() {
            return this.dtdHandler;
        }

        public void setDTDHandler(DTDHandler dtdHandler) {
            this.dtdHandler = dtdHandler;
        }

        public ErrorHandler getErrorHandler() {
            return this.errorHandler;
        }

        public void setErrorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
        }

        public EntityResolver getEntityResolver() {
            return this.entityResolver;
        }

        public void setEntityResolver(EntityResolver entityResolver) {
            this.entityResolver = entityResolver;
        }

        public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            if (name.equalsIgnoreCase(TransformTag.LEXICAL_HANDLER_PROPERTY)) {
                return this.xmlOutput.getLexicalHandler();
            }
            return null;
        }

        public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
            if (name.equalsIgnoreCase(TransformTag.LEXICAL_HANDLER_PROPERTY)) {
                this.xmlOutput.setLexicalHandler((LexicalHandler)value);
            }
        }

        public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return false;
        }

        public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        }
    }
}

