/**
 * CleanupTask.java
 * @author rhowlett (copied from InitServlet in GEO_NODE)
 * Date: June 11th, 2006
 */
package gov.epa.cdx.ws.web;

/**
 * This class cleans up any log files that are over a certain
 * "age".  It uses the lastmodified time has the measure of 
 * how old a file is.
 */
 
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.util.CDXFilesList;
import gov.epa.cdx.commons.util.FileManager;

import java.io.File;
import java.util.Date;
import java.util.Iterator;
import java.util.TimerTask;

class CleanupTask extends TimerTask {
    private String logDir = null;
    private int dayLimit;
    public CleanupTask (String logDir, int limit) {
        this.logDir = logDir;
        dayLimit = limit;
    }
    
    public void stop() {
    }

    public void run() {
        InitServlet.log.debug("CleanupTask started at [" + System.currentTimeMillis() + "] \n\t for directory [" + logDir + "]");
        long longDayLimit = System.currentTimeMillis() - (dayLimit * 24 * 60 * 60 * 1000);
        InitServlet.log.debug("checking for file older than [" + longDayLimit + "]");
        try {
            CDXFilesList logfiles = FileManager.getFilesListFromDirectory(logDir);
            Iterator iter = logfiles.getFiles().iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (o instanceof java.io.File) {
                    File fo = (File) o;
                    if (fo.lastModified() < longDayLimit) {
                        InitServlet.log.debug("removing file [" + fo.getName() + "] [" + fo.lastModified() + "] is date "
                            + (new Date(fo.lastModified())));
                        fo.delete();
                    }
                }
            }
        } catch (CDXException e) {
           InitServlet.log.error("CleanupTask error: " + e.getMessage(), e);
        } catch (Throwable ex) {
           InitServlet.log.error("unknown error: " + ex.getMessage(), ex);
        }
        
        InitServlet.log.debug("CleanupTask ended at [" + System.currentTimeMillis() + "]");
    }
}