/**
 * InitServlet.java
 * @author rhowlett (copied from InitServlet in GEO_Node)
 * Date: June 11th, 2006
 */
package gov.epa.cdx.ws.web;

/**
 * This class holds all the processes that are run at the time the
 * application is started.  Currently the only process is to create
 * a TimerTask which will run daily and remove all log files past
 * a certain "age".  This age is specificed in the wsnode_properties.xml
 * file.
 */
 
import java.util.Properties;
import java.util.Timer;

import gov.epa.cdx.commons.property.CDXPropertyManager;
import gov.epa.cdx.commons.util.FileManager;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;


public class InitServlet extends HttpServlet
{
    private static final String   CONFIG_FILE = "wqxnode_properties.xml";
    private static final String   LOG_FILE_LIFE_LIMIT_PARAM = "logFileLifeLimit";
    private static final int      LOG_FILE_LIFE_LIMIT_VALUE_DEFAULT = 20;
    
    protected static Log log =	LogFactory.getLog(InitServlet.class.getName());

    private Timer timer = null;

    // Initialize configuration file on startup
    public void init() throws ServletException
    {
    	  //System.out.println("Initializing the application." + ((FileAppender)Logger.getLogger(this.getClass()).getAppender("A1")).getFile());

        //First thing is first we are going to use cdx_properties.xml for everything
        //global and user one
        //user will take precedence if its present
        CDXPropertyManager.init(CDXPropertyManager.GLOBAL_CONFIG_FILE, CONFIG_FILE);

        // Load the properties
        CDXPropertyManager.loadProperties();
       
        
        /* The rest of this method is dedicated to keeping the logs cleaned up.
         * In the properties file there is a property that indicates how many days 
         * worth of logs should be allowed this will keep only that many around. */
        boolean useLocal = false;
        
        String configDir = "j2ee home"; 
        // configDir = LogCleanUpUtil.formatFileName(CDXPropertyManager.getGlobalProperty("WorkingDirectory")); 
        // if (configDir.charAt(configDir.length() - 1) != '/') {
        //    configDir += '/';
        // } 
        String logFileLifeLimit = CDXPropertyManager.getGlobalProperty(LOG_FILE_LIFE_LIMIT_PARAM);
        log.debug("InitServlet.init started with config directory [" + configDir  
                + "] and log limit of [" + logFileLifeLimit + "]");
        
        int dayLogFileLifeLimit;
        try {
            dayLogFileLifeLimit = Integer.parseInt( logFileLifeLimit );
        } catch (Exception e) {
            dayLogFileLifeLimit = LOG_FILE_LIFE_LIMIT_VALUE_DEFAULT;
        }
        
        Properties p = null;    
        p = LogCleanUpUtil.getLogProperty();
        
        if (p != null) {
            String logDirectory = LogCleanUpUtil.getLastValidDirectory(p.getProperty(LogCleanUpUtil.LOG_DIRECTORY_PROPERTY));
            if (logDirectory == null) {
                log.debug("couldn't find log file directory");
            } else {
                timer = new Timer();
                int threadWaitTime = 1 * 1000;
                int taskRepeatTime = 24 * 60 * 60 * 1000; // repeat every 24 hours
                timer.schedule(new CleanupTask(logDirectory, dayLogFileLifeLimit), threadWaitTime, taskRepeatTime);
            }
        }
    }
    
    public void destroy() {
        if (timer != null)
            timer.cancel();
        
        super.destroy();
    }
}
