/**
 * LogCleanUpUtil.java
 * @author rhowlett (refactored from InitServlet in GEO_NODE)
 * Date: June 11th, 2006 
 */
package gov.epa.cdx.ws.web;

/**
 * This class contains multiple static methods useful in the "Log Clean-up"
 * function of the WaterSentinel Node.   
 */
 
import gov.epa.cdx.commons.util.FileManager;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LogCleanUpUtil
{
    public static final String    LOG_DIRECTORY_PROPERTY = "log4j.appender.A1.File";
    private static final String   DEFAUT_LOG_PROPERTY_FILE = "log4j.properties";
    
    protected static Log log =  LogFactory.getLog(LogCleanUpUtil.class.getName());


    public static Properties getLogProperty() {
        Properties p = null;
        try {
            InputStream fIs = Thread.currentThread().getContextClassLoader().getResourceAsStream(DEFAUT_LOG_PROPERTY_FILE);
            BufferedInputStream buffin = new BufferedInputStream(fIs);
            p = new Properties();
            p.load( buffin );
            fIs.close();
        }
        catch (IOException e)
        {
            log.error ("File IO error for log property", e);
        }
        catch (Exception ex)
        {
            log.error("Unexpected error while processing log property", ex);
        }
        
        return p;
    }
    
    public static Properties getLogProperty(String localLog4jConfig) {
        Properties p = null;
        try {
            final InputStream buffin = new BufferedInputStream( new FileInputStream( localLog4jConfig ) );
            p = new Properties();
            p.load( buffin );
            buffin.close();
        }
        catch (IOException e)
        {
            log.error ("File IO error for log property", e);
        }
        catch (Exception ex)
        {
            log.error("Unexpected error while processing log property", ex);
        }
        
        return p;
    }
    
    public static String formatFileName(String fullName) {
        if (fullName == null)
            return null;
        
        String path = new File(fullName).getAbsolutePath();
        if (File.separatorChar != '/') {
          path = path.replace(File.separatorChar, '/');
        }
        /*
        if (!path.startsWith("/")) {
          path = "/" + path;
        } */
        return path;
    }
    
    public static String getLastValidDirectory(String fullName) {
        String fullPath = formatFileName(fullName);
        boolean go = true;
        try {
            while (go) {
                if (fullPath == null)
                    break;
                
                if (FileManager.isFileExists(fullPath)) {
                    go = false;
                } else {
                    fullPath = getParentPath(fullPath);
                }
                
            }
            
        } catch (Throwable e) {
            log.error("getLastValidDirectory error: " + e.getMessage(), e);
            return null;
        }

        return fullPath;
    }
    
    public static String getParentPath(String fullName) {
        String fullPath = fullName;
        fullPath = fullPath.substring(0, fullPath.lastIndexOf('/'));
        if (fullPath.endsWith(fullName))
            return null;
        return fullPath;
    }
}
