package gov.epa.cdx.ws.logic;

import gov.epa.cdx.axis.v10.client.NodeRequestor;
import gov.epa.cdx.axis.v10.impl.DocumentConverter;
import gov.epa.cdx.axis.v10.vo.NodeDocument;
import gov.epa.cdx.axis.v10.vo.NodeDocumentContentConverter;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.property.CDXPropertyManager;
import gov.epa.cdx.model.commons.QueryVO;
import gov.epa.cdx.model.document.DocumentList;
import gov.epa.cdx.model.transaction.TransactionVO;

import gov.epa.wqx.node.SolicitThread;
 
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import gov.epa.wqx.node.Constant;

public class WSNodeManager {
	
  protected static Log log = LogFactory.getLog(WSNodeManager.class.getName());	
	
  
  /**
   * Handle a submit call to WQX
   * Spin off a separate thread to do the work (asynchronously)
   * and then return a TransactionVO.
   * @param documents the documents submitted
   * @return The transaction ID of the documents
   * @throws CDXException
   */
	public static TransactionVO processSubmit(DocumentList documents) 
      throws CDXException {
  
    log.debug("WSNodeManager.processSubmit() - Start");        
    //Start new thread, which will load data to database and call notify
    WSBackEndWorkerThread worker = new WSBackEndWorkerThread(documents);
    Thread thread = new Thread(worker);
    thread.start();
    log.debug("WSNodeManager.processSubmit() - End");        
		return documents.getTransaction();
	}
  
  
  /**
   * Handle a submit call to WQX
   * Spin off a separate thread to do the work (asynchronously)
   * and then return a TransactionVO.
   */
  public static TransactionVO processSolicit(QueryVO queryVO) 
      throws CDXException {
      
    log.debug("WSNodeManager.processSolicit() - Start");
    TransactionVO transactionVO = new TransactionVO();
    // Return URL holds our CDX TransactionID
    transactionVO.setTransactionID(queryVO.getReturnURL()); 
    SolicitThread worker = new SolicitThread(queryVO);
    Thread thread = new Thread(worker);
    thread.start();
    log.debug("WSNodeManager.processSolicit() - End");
    return transactionVO;
  }
	
  
  /**
   * This method call the "Notify" method at CDX
   * @param transId The transaction ID that was sent in the "Submit"
   * @param doc A document containing the processing report or error message
   * @param urlEndpoint the URL to send the message to
   */
	public static void callCdxNotify(String transId, NodeDocument doc, String urlEndpoint) {
		try{
      log.debug("callCdxNotify() - Start");
			URL nodeURL = new URL(urlEndpoint);
			NodeRequestor nr = new NodeRequestor(nodeURL);
      log.debug("calling authenticate");
			String token = nr.authenticate(
        CDXPropertyManager.getProperty("CDX", "User"), 
        CDXPropertyManager.getProperty("CDX", "Password"));
      //NodeDocument[] nDocs = DocumentConverter.DocumentListToCdx(docs, NodeDocumentContentConverter.CONTENT_TYPE_BYTES);
      NodeDocument[] nDocs = new NodeDocument[1];
      nDocs[0] = doc;            
			// call notify() at CDX
      log.debug("calling notify");
      nr.notify(token, transId, Constant.DATAFLOW, nDocs);
			log.info("Notification sent for Transaction ID " + transId);
		}
		catch (MalformedURLException e) {
			log.error("Error in callCdxNotify - Node URL is incorrect. ", e);
		}
		catch (RemoteException e) {
			log.trace("Error in callCdxNotify", e);
		}
    finally {
      log.debug("callCdxNotify() - End");
    }
	}
  
  
  public static void callCdxSubmit(String transId, NodeDocument doc) {
    
    try {
      log.debug("callCdxSubmit() - Start");
      String submitUrl = CDXPropertyManager.getProperty("Solicit", "SubmitURL");
      log.debug("Submit URL = " + submitUrl);
      URL nodeURL = new URL(submitUrl);
      NodeRequestor nr = new NodeRequestor(nodeURL);
      log.debug("calling authenticate");
			String token = nr.authenticate(
        CDXPropertyManager.getProperty("CDX", "User"), 
        CDXPropertyManager.getProperty("CDX", "Password"));
      //NodeDocument[] nDocs = DocumentConverter.DocumentListToCdx(docs, NodeDocumentContentConverter.CONTENT_TYPE_BYTES);
      NodeDocument[] nDocs = new NodeDocument[1];
      nDocs[0] = doc;
      // call submit() at CDX to send a document
      log.debug("calling submit");
      nr.submit(token, transId, Constant.DATAFLOW, nDocs);
    }
    catch(MalformedURLException e) {
      log.error("Error in callCdxSubmit - Node URL is incorrect. ", e);
    }
    catch (Exception e) {
      log.error("Error in callCdxSubmit", e);
    }
    finally {
      log.debug("callCdxSubmit() - End");
    }
  }

}
