package gov.epa.wqx.node;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class Activity extends SchemaComponent {

  // ---------------------------------------------------------------------
  // Private/Protected Variables
  // ---------------------------------------------------------------------
  private ActivityPkg   _pkg;
  
  private String        _activityIdentifier;
  private String        _activityTypeCode;
  private String        _activityMediaName;
  private String        _activityMediaSubdivisionName;
  private String        _activityStartDateString;
  private Date          _activityStartDate;
  private String        _activityStartTimeString;
  private Time          _activityStartTime;
  private String        _activityStartTimeZoneCode;
  private String        _activityEndDateString;
  private Date          _activityEndDate;
  private String        _activityEndTimeString;
  private Time          _activityEndTime;
  private String        _activityEndTimeZoneCode;
  private String        _activityRelativeDepthName;
  private String        _activityDepthHeightMeasureValue;
  private String        _activityDepthHeightMeasureUnitCode;
  private String        _activityTopDepthHeightMeasureValue;
  private String        _activityTopDepthHeightMeasureUnitCode;
  private String        _activityBottomDepthHeightMeasureValue;
  private String        _activityBottomDepthHeightMeasureUnitCode;
  private String        _activityDepthAltitudeReferencePointText;
  private List          _projectIdentifiers;
  private List          _activityConductingOrganizations;
  private String        _monitoringLocationIdentifier;
  private String        _activityCommentText;
  private String        _latitudeMeasure;
  private String        _longitudeMeasure;
  private String        _sourceMapScaleNumeric;
  private String        _horizontalCollectionMethodName;
  private String        _horizontalCoordinateReferenceSystemDatumName;
  private String        _sampleCollectionMethodIdentifier;
  private String        _sampleCollectionMethodIdentifierContext;
  private String        _sampleCollectionMethodName;
  private String        _sampleCollectionMethodQualifierTypeName;
  private String        _sampleCollectionMethodDescriptionText;
  private String        _sampleTissueTaxonomicName;
  private String        _sampleTissueAnatomyName;
  private String        _sampleCollectionEquipmentName;
  private String        _sampleCollectionEquipmentCommentText;
  private String        _samplePreparationMethodIdentifier;
  private String        _samplePreparationMethodIdentifierContext;
  private String        _samplePreparationMethodName;
  private String        _samplePreparationMethodQualifierTypeName;
  private String        _samplePreparationMethodDescriptionText;
  private String        _sampleContainerTypeName;
  private String        _sampleContainerColorName;
  private String        _chemicalPreservativeUsedName;
  private String        _thermalPreservativeUsedName;
  private String        _sampleTransportStorageDescription;
 
  // ---------------------------------------------------------------------
  // Constructors
  // ---------------------------------------------------------------------
  public Activity(SchemaComponent parent)
      throws WqxFatalException {
      
    super(parent);
    try {
      _transactionalBoundary = true;
      _projectIdentifiers = Collections.synchronizedList(new ArrayList());
      _activityConductingOrganizations = Collections.synchronizedList(new ArrayList());
      this.clear();    
      _pkg = new ActivityPkg(_connection);
    }
    catch(Exception e) {
      _transactionLog.logError(e);
    }
  }
  
  // ---------------------------------------------------------------------
  // Get/Set Methods
  // ---------------------------------------------------------------------

  public void setActivityIdentifier(String activityIdentifier)
      throws WqxFatalException {
      
    _activityIdentifier = setValue(activityIdentifier);
  }
  

  public String getActivityIdentifier() {
    return _activityIdentifier;
  }


  public void setActivityTypeCode(String activityTypeCode)
      throws WqxFatalException {
      
    _activityTypeCode = setValue(activityTypeCode);
  }
  

  public String getActivityTypeCode() {
    return _activityTypeCode;
  }


  public void setActivityMediaName(String activityMediaName)
      throws WqxFatalException {
      
    _activityMediaName = setValue(activityMediaName);
  }
  

  public String getActivityMediaName() {
    return _activityMediaName;
  }


  public void setActivityMediaSubdivisionName(String activityMediaSubdivisionName)
      throws WqxFatalException {
      
    _activityMediaSubdivisionName = setValue( activityMediaSubdivisionName);
  }  

  public String getActivityMediaSubdivisionName() {
    return _activityMediaSubdivisionName;
  }


  public void setActivityStartDate(String activityStartDate)
      throws WqxFatalException {
      
    _activityStartDateString = setValue( activityStartDate);
    try {
      _activityStartDate = Lib.xmlToDate(_activityStartDateString);
    }
    catch (Exception e) {
      _activityStartDate = null;
      _transactionLog.logError(e);
    }
  }
  

  public String getActivityStartDate() {
    return _activityStartDateString;
  }


  public void setActivityStartTime(String activityStartTime)
      throws WqxFatalException {
      
    _activityStartTimeString = setValue(activityStartTime);
    try {
      _activityStartTime = Lib.xmlToTime(_activityStartTimeString);
    }
    catch (Exception e) {
      _activityStartTime = null;
      _transactionLog.logError(e);
    }
  }
  

  public String getActivityStartTime() {
    return _activityStartTimeString;
  }


  public void setActivityStartTimeZoneCode(String activityStartTimeZoneCode)
      throws WqxFatalException {
      
    _activityStartTimeZoneCode = setValue(activityStartTimeZoneCode);
  }
  

  public String getActivityStartTimeZoneCode() {
    return _activityStartTimeZoneCode;
  }


  public void setActivityEndDate(String activityEndDate)
      throws WqxFatalException {
      
    _activityEndDateString = setValue(activityEndDate);
    try {
      _activityEndDate = Lib.xmlToDate(_activityEndDateString);
    }
    catch (Exception e) {
      _activityEndDate = null;
      _transactionLog.logError(e);
    }
  }
  

  public String getActivityEndDate() {
    return _activityEndDateString;
  }


  public void setActivityEndTime(String activityEndTime)
      throws WqxFatalException {
      
    _activityEndTimeString = setValue(activityEndTime);
    try {
      _activityEndTime = Lib.xmlToTime(_activityEndTimeString);
    }
    catch (Exception e) {
      _activityEndTime = null;
      _transactionLog.logError(e);
    }
  }
 

  public String getActivityEndTime() {
    return _activityEndTimeString;
  }


  public void setActivityEndTimeZoneCode(String activityEndTimeZoneCode)
      throws WqxFatalException {
      
    _activityEndTimeZoneCode = setValue(activityEndTimeZoneCode);
  }
  

  public String getActivityEndTimeZoneCode() {
    return _activityEndTimeZoneCode;
  }


  public void setActivityRelativeDepthName(String activityRelativeDepthName)
      throws WqxFatalException {
      
    _activityRelativeDepthName = setValue(activityRelativeDepthName);
  }
  

  public String getActivityRelativeDepthName() {
    return _activityRelativeDepthName;
  }


  public void setActivityDepthHeightMeasureValue(String activityDepthHeightMeasure)
      throws WqxFatalException {
      
    _activityDepthHeightMeasureValue = setValue(activityDepthHeightMeasure);
  }
 

  public String getActivityDepthHeightMeasureValue() {
    return _activityDepthHeightMeasureValue;
  }


  public void setActivityDepthHeightMeasureUnitCode(String activityDepthHeightMeasureUnitCode)
      throws WqxFatalException {
      
    _activityDepthHeightMeasureUnitCode = setValue(activityDepthHeightMeasureUnitCode);
  }
 

  public String getActivityDepthHeightMeasureUnitCode() {
    return _activityDepthHeightMeasureUnitCode;
  }


  public void setActivityTopDepthHeightMeasureValue(String activityTopDepthHeightMeasureValue)
      throws WqxFatalException {
      
    _activityTopDepthHeightMeasureValue = setValue(activityTopDepthHeightMeasureValue);
  }
 

  public String getActivityTopDepthHeightMeasureValue() {
    return _activityTopDepthHeightMeasureValue;
  }


  public void setActivityTopDepthHeightMeasureUnitCode(String activityTopDepthHeightMeasureUnitCode)
      throws WqxFatalException {
      
    _activityTopDepthHeightMeasureUnitCode = setValue(activityTopDepthHeightMeasureUnitCode);
  }
 

  public String getActivityTopDepthHeightMeasureUnitCode() {
    return _activityTopDepthHeightMeasureUnitCode;
  }


  public void setActivityBottomDepthHeightMeasureValue(String activityBottomDepthHeightMeasureValue)
      throws WqxFatalException {
      
    _activityBottomDepthHeightMeasureValue = setValue(activityBottomDepthHeightMeasureValue);
  }
 

  public String getActivityBottomDepthHeightMeasureValue() {
    return _activityBottomDepthHeightMeasureValue;
  }


  public void setActivityBottomDepthHeightMeasureUnitCode(String activityBottomDepthHeightMeasureUnitCode)
      throws WqxFatalException {
      
    _activityBottomDepthHeightMeasureUnitCode = setValue(activityBottomDepthHeightMeasureUnitCode);
  }
  

  public String getActivityBottomDepthHeightMeasureUnitCode() {
    return _activityBottomDepthHeightMeasureUnitCode;
  }


  public void setActivityDepthAltitudeReferencePointText(String activityDepthAltitudeReferencePointText)
      throws WqxFatalException {
      
    _activityDepthAltitudeReferencePointText = setValue(activityDepthAltitudeReferencePointText);
  }
 

  public String getActivityDepthAltitudeReferencePointText() {
    return _activityDepthAltitudeReferencePointText;
  }
 

  public void setMonitoringLocationIdentifier(String monitoringLocationIdentifier)
      throws WqxFatalException {
      
    _monitoringLocationIdentifier = setValue(monitoringLocationIdentifier);
  }
  

  public String getMonitoringLocationIdentifier() {
    return _monitoringLocationIdentifier;
  }


  public void setActivityCommentText(String activityCommentText)
      throws WqxFatalException {
      
    _activityCommentText = setValue(activityCommentText);
  }
  

  public String getActivityCommentText() {
    return _activityCommentText;
  }


  public void setLatitudeMeasure(String latitudeMeasure)
      throws WqxFatalException {
      
    _latitudeMeasure = setValue(latitudeMeasure);
  }
  

  public String getLatitudeMeasure() {
    return _latitudeMeasure;
  }


  public void setLongitudeMeasure(String longitudeMeasure)
      throws WqxFatalException {
      
    _longitudeMeasure = setValue(longitudeMeasure);
  }
  

  public String getLongitudeMeasure() {
    return _longitudeMeasure;
  }


  public void setSourceMapScaleNumeric(String sourceMapScaleNumeric)
      throws WqxFatalException {
      
    _sourceMapScaleNumeric = setValue(sourceMapScaleNumeric);
  }
 

  public String getSourceMapScaleNumeric() {
    return _sourceMapScaleNumeric;
  }


  public void setHorizontalCollectionMethodName(String horizontalCollectionMethodName)
      throws WqxFatalException {
      
    _horizontalCollectionMethodName = setValue(horizontalCollectionMethodName);
  }


  public String getHorizontalCollectionMethodName() {
    return _horizontalCollectionMethodName;
  }


  public void setHorizontalCoordinateReferenceSystemDatumName(String horizontalCoordinateReferenceSystemDatumName)
      throws WqxFatalException {
      
    _horizontalCoordinateReferenceSystemDatumName = setValue(horizontalCoordinateReferenceSystemDatumName);
  }
 

  public String getHorizontalCoordinateReferenceSystemDatumName() {
    return _horizontalCoordinateReferenceSystemDatumName;
  }


  public void setSampleCollectionMethodIdentifier(String sampleCollectionMethodIdentifier)
      throws WqxFatalException {
      
    _sampleCollectionMethodIdentifier = setValue(sampleCollectionMethodIdentifier);
  }
  

  public String getSampleCollectionMethodIdentifier() {
    return _sampleCollectionMethodIdentifier;
  }


  public void setSampleCollectionMethodIdentifierContext(String sampleCollectionMethodIdentifierContext)
      throws WqxFatalException {
      
    _sampleCollectionMethodIdentifierContext = setValue(sampleCollectionMethodIdentifierContext);
  }
  

  public String getSampleCollectionMethodIdentifierContext() {
    return _sampleCollectionMethodIdentifierContext;
  }


  public void setSampleCollectionMethodName(String sampleCollectionMethodName)
      throws WqxFatalException {
      
    _sampleCollectionMethodName = setValue(sampleCollectionMethodName);
  }
  

  public String getSampleCollectionMethodName() {
    return _sampleCollectionMethodName;
  }


  public void setSampleCollectionMethodQualifierTypeName(String sampleCollectionMethodQualifierTypeName)
      throws WqxFatalException {
      
    _sampleCollectionMethodQualifierTypeName = setValue(sampleCollectionMethodQualifierTypeName);
  }
  

  public String getSampleCollectionMethodQualifierTypeName() {
    return _sampleCollectionMethodQualifierTypeName;
  }


  public void setSampleCollectionMethodDescriptionText(String sampleCollectionMethodDescriptionText)
      throws WqxFatalException {
      
    _sampleCollectionMethodDescriptionText = setValue(sampleCollectionMethodDescriptionText);
  }
  

  public String getSampleCollectionMethodDescriptionText() {
    return _sampleCollectionMethodDescriptionText;
  }


  public void setSampleTissueTaxonomicName(String sampleTissueTaxonomicName)
      throws WqxFatalException {
      
    _sampleTissueTaxonomicName = setValue(sampleTissueTaxonomicName);
  }
  

  public String getSampleTissueTaxonomicName() {
    return _sampleTissueTaxonomicName;
  }


  public void setSampleTissueAnatomyName(String sampleTissueAnatomyName)
      throws WqxFatalException {
      
    _sampleTissueAnatomyName = setValue(sampleTissueAnatomyName);
  }
  

  public String getSampleTissueAnatomyName() {
    return _sampleTissueAnatomyName;
  }


  public void setSampleCollectionEquipmentName(String sampleCollectionEquipmentName)
      throws WqxFatalException {
      
    _sampleCollectionEquipmentName = setValue(sampleCollectionEquipmentName);
  }
  

  public String getSampleCollectionEquipmentName() {
    return _sampleCollectionEquipmentName;
  }


  public void setSampleCollectionEquipmentCommentText(String sampleCollectionEquipmentCommentText)
      throws WqxFatalException {
      
    _sampleCollectionEquipmentCommentText = setValue(sampleCollectionEquipmentCommentText);
  }
  

  public String getSampleCollectionEquipmentCommentText() {
    return _sampleCollectionEquipmentCommentText;
  }


  public void setSamplePreparationMethodIdentifier(String samplePreparationMethodIdentifier)
      throws WqxFatalException {
      
    _samplePreparationMethodIdentifier = setValue(samplePreparationMethodIdentifier);
  }
  

  public String getSamplePreparationMethodIdentifier() {
    return _samplePreparationMethodIdentifier;
  }


  public void setSamplePreparationMethodIdentifierContext(String samplePreparationMethodIdentifierContext)
      throws WqxFatalException {
      
    _samplePreparationMethodIdentifierContext = setValue(samplePreparationMethodIdentifierContext);
  }
 

  public String getSamplePreparationMethodIdentifierContext() {
    return _samplePreparationMethodIdentifierContext;
  }


  public void setSamplePreparationMethodName(String samplePreparationMethodName)
      throws WqxFatalException {
      
    _samplePreparationMethodName = setValue(samplePreparationMethodName);
  }
  

  public String getSamplePreparationMethodName() {
    return _samplePreparationMethodName;
  }


  public void setSamplePreparationMethodQualifierTypeName(String samplePreparationMethodQualifierTypeName)
      throws WqxFatalException {
      
    _samplePreparationMethodQualifierTypeName = setValue(samplePreparationMethodQualifierTypeName);
  }
  

  public String getSamplePreparationMethodQualifierTypeName() {
    return _samplePreparationMethodQualifierTypeName;
  }


  public void setSamplePreparationMethodDescriptionText(String samplePreparationMethodDescriptionText)
      throws WqxFatalException {
      
    _samplePreparationMethodDescriptionText = setValue(samplePreparationMethodDescriptionText);
  }
  

  public String getSamplePreparationMethodDescriptionText() {
    return _samplePreparationMethodDescriptionText;
  }


  public void setSampleContainerTypeName(String sampleContainerTypeName)
      throws WqxFatalException {
      
    _sampleContainerTypeName = setValue(sampleContainerTypeName);
  }
  

  public String getSampleContainerTypeName() {
    return _sampleContainerTypeName;
  }


  public void setSampleContainerColorName(String sampleContainerColorName)
      throws WqxFatalException {
      
    _sampleContainerColorName = setValue(sampleContainerColorName);
  }
  

  public String getSampleContainerColorName() {
    return _sampleContainerColorName;
  }


  public void setChemicalPreservativeUsedName(String chemicalPreservativeUsedName)
      throws WqxFatalException {
      
    _chemicalPreservativeUsedName = setValue(chemicalPreservativeUsedName);
  }
 

  public String getChemicalPreservativeUsedName() {
    return _chemicalPreservativeUsedName;
  }


  public void setThermalPreservativeUsedName(String thermalPreservativeUsedName)
      throws WqxFatalException {
      
    _thermalPreservativeUsedName = setValue(thermalPreservativeUsedName);
  }
 

  public String getThermalPreservativeUsedName() {
    return _thermalPreservativeUsedName;
  }


  public void setSampleTransportStorageDescription(String sampleTransportStorageDescription)
      throws WqxFatalException {
      
    _sampleTransportStorageDescription = setValue(sampleTransportStorageDescription);
  }
  

  public String getSampleTransportStorageDescription() {
    return _sampleTransportStorageDescription;
  }


  // ---------------------------------------------------------------------
  // Methods
  // ---------------------------------------------------------------------
  
  // Add Project ID to collection 
  public void addProjectIdentifier(String projectIdentifier)
      throws WqxFatalException {
      
    try {
      if (projectIdentifier != null) {
        _projectIdentifiers.add(projectIdentifier.trim());
        _dirty = true;
      }
    }
    catch(Exception e) {
      _transactionLog.logError(e);
    }
  }
  
  // Add Conducting Organization to collection
  public void addActivityConductingOrganizationText(String activityConductingOrganizationText)
      throws WqxFatalException {
      
    try {
      if (activityConductingOrganizationText != null) {
        _activityConductingOrganizations.add(activityConductingOrganizationText.trim());
        _dirty = true;
      } 
    }
    catch(Exception e) {
      _transactionLog.logError(e);
    }
  }
  
  // Save this object's values to the database
  public void save() 
      throws Exception {
    try {  
       if (_dirty) {  
        try {
          _uid = _pkg.insertUpdateRow(
            _context,
            _activityMediaName,
            _activityTypeCode,
            _activityCommentText,
            _activityDepthHeightMeasureValue, 
            _activityBottomDepthHeightMeasureValue,
            _activityDepthAltitudeReferencePointText,
            _activityTopDepthHeightMeasureValue,
            _activityEndDate,
            _activityEndTime,
            _activityIdentifier,
            _latitudeMeasure,
            _longitudeMeasure,
            _sourceMapScaleNumeric,
            _activityStartDate,
            _activityStartTime,
            _sampleCollectionMethodIdentifier,
            _sampleCollectionMethodIdentifierContext,
            _sampleCollectionMethodName,
            _sampleCollectionMethodQualifierTypeName,
            _sampleCollectionMethodDescriptionText,
            _sampleCollectionEquipmentCommentText,
            _samplePreparationMethodIdentifier,
            _samplePreparationMethodIdentifierContext,
            _samplePreparationMethodName,
            _samplePreparationMethodQualifierTypeName,
            _samplePreparationMethodDescriptionText,
            _sampleTransportStorageDescription,
            _chemicalPreservativeUsedName,
            _sampleContainerColorName,
            _sampleContainerTypeName,
            _activityMediaSubdivisionName,
            _horizontalCollectionMethodName,
            _horizontalCoordinateReferenceSystemDatumName,
            _monitoringLocationIdentifier,
            _activityDepthHeightMeasureUnitCode,
            _activityBottomDepthHeightMeasureUnitCode,
            _activityTopDepthHeightMeasureUnitCode,
            _activityRelativeDepthName,
            _sampleCollectionEquipmentName,
            _sampleTissueAnatomyName,
            _sampleTissueTaxonomicName,
            _thermalPreservativeUsedName,
            _activityStartTimeZoneCode,
            _activityEndTimeZoneCode);
        }
        catch(SQLException e) {
          _transactionLog.logError(e);
        }
        // Insert Activity/Project reference
        if (_projectIdentifiers.size() > 0) {
          String projectIdentifier = null;
          ListIterator prjIterator = _projectIdentifiers.listIterator();
          while (prjIterator.hasNext()) {
            projectIdentifier = (String) prjIterator.next();
            try {
              _pkg.insertProjectRef(
                _context,
                projectIdentifier,
                _uid);
            }
            catch(SQLException e) {
              _transactionLog.logError(e);  
            }
          }
        }
        // Insert Activity Conducting Orgs
        if (_activityConductingOrganizations != null) {
          String conductingOrg = null;
          ListIterator conOrgsIterator = _activityConductingOrganizations.listIterator();
          while (conOrgsIterator.hasNext()) {
            conductingOrg = (String) conOrgsIterator.next();
            try {
              _pkg.insertConductingOrg(
                _context,
                _uid,
                conductingOrg);
            }
            catch(SQLException e) {
              _transactionLog.logError(e);
            }
          }
        }
      }
    }
    catch(Exception e) {
      _transactionLog.logError(e);
    }
    finally {
      super.save();
    }
  }
  
  
  // Delete previous loaded data
  public void deleteRows(String context, String activityIdentifier)
      throws WqxFatalException {
      
    try {
      _pkg.deleteRowByActId(context, activityIdentifier);;
    }
    catch (SQLException e) {
      _transactionLog.logError(e);
    }
  }
  
  
  // Clear this object's values to reuse it for a new one.
  public void clear()
      throws WqxFatalException {
      
    try {
      _activityIdentifier = null;
      _activityTypeCode = null;
      _activityMediaName = null;
      _activityMediaSubdivisionName = null;
      _activityStartDateString = null;
      _activityStartDate = null;
      _activityStartTimeString = null;
      _activityStartTime = null;
      _activityStartTimeZoneCode = null;
      _activityEndDateString = null;
      _activityEndDate = null;
      _activityEndTimeString = null;
      _activityEndTime = null;
      _activityEndTimeZoneCode = null;
      _activityRelativeDepthName = null;
      _activityDepthHeightMeasureValue = null;
      _activityDepthHeightMeasureUnitCode = null;
      _activityTopDepthHeightMeasureValue = null;
      _activityTopDepthHeightMeasureUnitCode = null;
      _activityBottomDepthHeightMeasureValue = null;
      _activityBottomDepthHeightMeasureUnitCode = null;
      _activityDepthAltitudeReferencePointText = null;
      _projectIdentifiers.clear();
      _activityConductingOrganizations.clear();
      _monitoringLocationIdentifier = null;
      _activityCommentText = null;
      _latitudeMeasure = null;
      _longitudeMeasure = null;
      _sourceMapScaleNumeric = null;
      _horizontalCollectionMethodName = null;
      _horizontalCoordinateReferenceSystemDatumName = null;
      _sampleCollectionMethodIdentifier = null;
      _sampleCollectionMethodIdentifierContext = null;
      _sampleCollectionMethodName = null;
      _sampleCollectionMethodQualifierTypeName = null;
      _sampleCollectionMethodDescriptionText = null;
      _sampleTissueTaxonomicName = null;
      _sampleTissueAnatomyName = null;
      _sampleCollectionEquipmentName = null;
      _sampleCollectionEquipmentCommentText = null;
      _samplePreparationMethodIdentifier = null;
      _samplePreparationMethodIdentifierContext = null;
      _samplePreparationMethodName = null;
      _samplePreparationMethodQualifierTypeName = null;
      _samplePreparationMethodDescriptionText = null;
      _sampleContainerTypeName = null;
      _sampleContainerColorName = null;
      _chemicalPreservativeUsedName = null;
      _thermalPreservativeUsedName = null;
      _sampleTransportStorageDescription = null;
    }
    catch(Exception e) {
      _transactionLog.logError(e);
    }  
    finally {
      super.clear();
    }
  }
}