package gov.epa.wqx.node;

import gov.epa.wqx.node.SchemaComponent;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class ActivityGroup extends SchemaComponent {

  // ---------------------------------------------------------------------
  // Private/Protected Variables
  // ---------------------------------------------------------------------
  private ActivityGroupPkg _pkg;
  
  private String       _activityGroupIdentifier;
  private String       _activityGroupName;
  private String       _activityGroupTypeCode;
  private List         _activityIdentifiers;  
  
  // ---------------------------------------------------------------------
  // Constructors
  // ---------------------------------------------------------------------
  public ActivityGroup(SchemaComponent parent)
      throws WqxFatalException {
      
    super(parent);
    try {
      _transactionalBoundary = true;
      _activityIdentifiers = Collections.synchronizedList(new ArrayList());
      this.clear();
      _pkg = new ActivityGroupPkg(_connection);
    }
    catch(Exception e) {
      _transactionLog.logError(e);
    }
  }

  // ---------------------------------------------------------------------
  // Get/Set Methods
  // ---------------------------------------------------------------------
  public void setActivityGroupIdentifier(String activityGroupIdentifier)
      throws WqxFatalException {
      
    _activityGroupIdentifier = setValue(activityGroupIdentifier);
  }


  public String getActivityGroupIdentifier() {
    return _activityGroupIdentifier;
  }


  public void setActivityGroupName(String activityGroupName)
      throws WqxFatalException {
      
    _activityGroupName = setValue(activityGroupName);
  }
  

  public String getActivityGroupName() {
    return _activityGroupName;
  }


  public void setActivityGroupTypeCode(String activityGroupTypeCode)
      throws WqxFatalException {
      
    _activityGroupTypeCode = setValue(activityGroupTypeCode);
  }
  

  public String getActivityGroupTypeCode() {
    return _activityGroupTypeCode;
  }

  // ---------------------------------------------------------------------
  // Methods
  // ---------------------------------------------------------------------
  
  // add an Activity ID to the activity group
  public void addActivityIdentifier(String activityIdentifier)
      throws WqxFatalException {
      
    try {
      if (activityIdentifier != null) {
        _activityIdentifiers.add(activityIdentifier.trim());
        _dirty = true;
      }
    }
    catch(Exception e) {
      _transactionLog.logError(e);
    }  
  }
  
  
  // Save this object's values to the database
  public void save() 
      throws Exception {
    try {
      if (_dirty) {  
        _uid = _pkg.insertUpdateRow(
          _context,
          _activityGroupIdentifier,
          _activityGroupName,
          _activityGroupTypeCode);
        // Insert Activity Identifiers into the activity group details table
        if (_activityIdentifiers.size() > 0) {
          String activityId = null;
          ListIterator iterator = _activityIdentifiers.listIterator();
          while (iterator.hasNext()) {
            activityId = (String) iterator.next();
            try {
              _pkg.insertDetailRow(
                _context,
                _uid,
                activityId);
            }
            catch (Exception e) {
              _transactionLog.logError(e);
            }
          }
        }
      }
    }
    catch (Exception e) {
      _transactionLog.logError(e);
    }
    finally {
      super.save();
    }
  }
     
  // Clear this object's values to reuse it for a new one.
  public void clear()
      throws WqxFatalException {
      
    try {
      _activityGroupIdentifier = null;
      _activityGroupName = null;
      _activityGroupTypeCode = null;
      _activityIdentifiers.clear();
    }
    catch (Exception e) {
      _transactionLog.logError(e);
    }
    finally {
      super.clear();
    }
  }
   
}