package gov.epa.wqx.node;

import java.sql.SQLException;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleTypes;

public class ActivityGroupPkg {

  private OracleConnection _connection = null;
  private OracleCallableStatement _csDeleteDetailsByActgrpUid;
  private OracleCallableStatement _csDeleteRow;
  private OracleCallableStatement _csDeleteRowByActgrpId;
  private OracleCallableStatement _csInsertDetailRow;
  private OracleCallableStatement _csInsertUpdateRow;

  // constructor  
  public ActivityGroupPkg (
      OracleConnection connection) 
      
      throws SQLException {
      
    // make sure we're connected
    if (connection == null)
      throw new SQLException("Connection is null");
    else if(connection.isClosed())
      throw new SQLException("Connection is closed");
    _connection = connection;

    // DELETE DETAILS BY ACTGRP UID
    _csDeleteDetailsByActgrpUid = (OracleCallableStatement) _connection.prepareCall(
      "{call activity_group_pkg.delete_details_by_actgrp_uid(?, ?)}");
    _csDeleteDetailsByActgrpUid.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csDeleteDetailsByActgrpUid.defineParameterType(2, OracleTypes.NUMBER, 20); // p_actgrp_uid

    // DELETE ROW
    _csDeleteRow = (OracleCallableStatement) _connection.prepareCall(
      "{call activity_group_pkg.delete_row(?, ?, ?)}");
    _csDeleteRow.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csDeleteRow.defineParameterType(2, OracleTypes.NUMBER, 20); // p_actgrp_uid
    _csDeleteRow.defineParameterType(3, OracleTypes.VARCHAR, 35); // p_actgrp_id

    // DELETE ROW BY ACTGRP ID
    _csDeleteRowByActgrpId = (OracleCallableStatement) _connection.prepareCall(
      "{call activity_group_pkg.delete_row_by_actgrp_id(?, ?)}");
    _csDeleteRowByActgrpId.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csDeleteRowByActgrpId.defineParameterType(2, OracleTypes.VARCHAR, 35); // p_actgrp_id

    // INSERT DETAIL ROW
    _csInsertDetailRow = (OracleCallableStatement) _connection.prepareCall(
      "{call activity_group_pkg.insert_detail_row(?, ?, ?)}");
    _csInsertDetailRow.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csInsertDetailRow.defineParameterType(2, OracleTypes.NUMBER, 20); // p_actgrp_uid
    _csInsertDetailRow.defineParameterType(3, OracleTypes.VARCHAR, 35); // p_act_id

    // INSERT UPDATE ROW
    _csInsertUpdateRow = (OracleCallableStatement) _connection.prepareCall(
      "{call activity_group_pkg.insert_update_row(?, ?, ?, ?, ?)}");
    _csInsertUpdateRow.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csInsertUpdateRow.defineParameterType(2, OracleTypes.VARCHAR, 35); // p_actgrp_id
    _csInsertUpdateRow.defineParameterType(3, OracleTypes.VARCHAR, 50); // p_actgrp_name
    _csInsertUpdateRow.defineParameterType(4, OracleTypes.VARCHAR, 50); // p_agtyp_name
    _csInsertUpdateRow.registerOutParameter(5, OracleTypes.NUMBER, 20); // p_actgrp_uid
  }


  public void deleteDetailsByActgrpUid (  
      String context,
      String actgrpUid)

      throws SQLException {

    // set parameter values and call procedure
    _csDeleteDetailsByActgrpUid.setString(1, context);
    _csDeleteDetailsByActgrpUid.setString(2, actgrpUid);
    _csDeleteDetailsByActgrpUid.execute();
  }


  public void deleteRow (  
      String context,
      String actgrpUid,
      String actgrpId)

      throws SQLException {

    // set parameter values and call procedure
    _csDeleteRow.setString(1, context);
    _csDeleteRow.setString(2, actgrpUid);
    _csDeleteRow.setString(3, actgrpId);
    _csDeleteRow.execute();
  }


  public void deleteRowByActgrpId (  
      String context,
      String actgrpId)

      throws SQLException {

    // set parameter values and call procedure
    _csDeleteRowByActgrpId.setString(1, context);
    _csDeleteRowByActgrpId.setString(2, actgrpId);
    _csDeleteRowByActgrpId.execute();
  }


  public void insertDetailRow (  
      String context,
      String actgrpUid,
      String actId)

      throws SQLException {

    // set parameter values and call procedure
    _csInsertDetailRow.setString(1, context);
    _csInsertDetailRow.setString(2, actgrpUid);
    _csInsertDetailRow.setString(3, actId);
    _csInsertDetailRow.execute();
  }


  public String insertUpdateRow (  
      String context,
      String actgrpId,
      String actgrpName,
      String agtypName)

      throws SQLException {

    // set parameter values and call procedure
    _csInsertUpdateRow.setString(1, context);
    _csInsertUpdateRow.setString(2, actgrpId);
    _csInsertUpdateRow.setString(3, actgrpName);
    _csInsertUpdateRow.setString(4, agtypName);
    _csInsertUpdateRow.execute();
    // get out parameters and/or return value
    return _csInsertUpdateRow.getString(5);
  }

}