package gov.epa.wqx.node;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleTypes;

public class ActivityPkg {

  private OracleConnection _connection = null;
  private OracleCallableStatement _csDeleteActPrjRows;
  private OracleCallableStatement _csDeleteConductingOrgRows;
  private OracleCallableStatement _csDeleteRow;
  private OracleCallableStatement _csDeleteRowByActId;
  private OracleCallableStatement _csDeleteRowsByMlocUid;
  private OracleCallableStatement _csDeleteRowsByPrjUid;
  private OracleCallableStatement _csInsertConductingOrg;
  private OracleCallableStatement _csInsertProjectRef;
  private OracleCallableStatement _csInsertUpdateRow;

  // constructor  
  public ActivityPkg (
      OracleConnection connection) 
      
      throws SQLException {
      
    // make sure we're connected
    if (connection == null)
      throw new SQLException("Connection is null");
    else if(connection.isClosed())
      throw new SQLException("Connection is closed");
    _connection = connection;

    // DELETE ACT PRJ ROWS
    _csDeleteActPrjRows = (OracleCallableStatement) _connection.prepareCall(
      "{call activity_pkg.delete_act_prj_rows(?, ?)}");
    _csDeleteActPrjRows.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csDeleteActPrjRows.defineParameterType(2, OracleTypes.NUMBER, 20); // p_act_uid

    // DELETE CONDUCTING ORG ROWS
    _csDeleteConductingOrgRows = (OracleCallableStatement) _connection.prepareCall(
      "{call activity_pkg.delete_conducting_org_rows(?, ?)}");
    _csDeleteConductingOrgRows.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csDeleteConductingOrgRows.defineParameterType(2, OracleTypes.NUMBER, 20); // p_act_uid

    // DELETE ROW
    _csDeleteRow = (OracleCallableStatement) _connection.prepareCall(
      "{call activity_pkg.delete_row(?, ?, ?)}");
    _csDeleteRow.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csDeleteRow.defineParameterType(2, OracleTypes.NUMBER, 20); // p_act_uid
    _csDeleteRow.defineParameterType(3, OracleTypes.VARCHAR, 35); // p_act_id

    // DELETE ROW BY ACT ID
    _csDeleteRowByActId = (OracleCallableStatement) _connection.prepareCall(
      "{call activity_pkg.delete_row_by_act_id(?, ?)}");
    _csDeleteRowByActId.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csDeleteRowByActId.defineParameterType(2, OracleTypes.VARCHAR, 35); // p_act_id

    // DELETE ROWS BY MLOC UID
    _csDeleteRowsByMlocUid = (OracleCallableStatement) _connection.prepareCall(
      "{call activity_pkg.delete_rows_by_mloc_uid(?, ?)}");
    _csDeleteRowsByMlocUid.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csDeleteRowsByMlocUid.defineParameterType(2, OracleTypes.NUMBER, 20); // p_mloc_uid

    // DELETE ROWS BY PRJ UID
    _csDeleteRowsByPrjUid = (OracleCallableStatement) _connection.prepareCall(
      "{call activity_pkg.delete_rows_by_prj_uid(?, ?)}");
    _csDeleteRowsByPrjUid.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csDeleteRowsByPrjUid.defineParameterType(2, OracleTypes.NUMBER, 20); // p_prj_uid

    // INSERT CONDUCTING ORG
    _csInsertConductingOrg = (OracleCallableStatement) _connection.prepareCall(
      "{call activity_pkg.insert_conducting_org(?, ?, ?)}");
    _csInsertConductingOrg.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csInsertConductingOrg.defineParameterType(2, OracleTypes.NUMBER, 20); // p_act_uid
    _csInsertConductingOrg.defineParameterType(3, OracleTypes.VARCHAR, 120); // p_acorg_name

    // INSERT PROJECT REF
    _csInsertProjectRef = (OracleCallableStatement) _connection.prepareCall(
      "{call activity_pkg.insert_project_ref(?, ?, ?)}");
    _csInsertProjectRef.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csInsertProjectRef.defineParameterType(2, OracleTypes.VARCHAR, 35); // p_prj_id
    _csInsertProjectRef.defineParameterType(3, OracleTypes.NUMBER, 20); // p_act_uid

    // INSERT UPDATE ROW
    _csInsertUpdateRow = (OracleCallableStatement) _connection.prepareCall(
      "{call activity_pkg.insert_update_row(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}");
    _csInsertUpdateRow.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csInsertUpdateRow.defineParameterType(2, OracleTypes.VARCHAR, 20); // p_acmed_name
    _csInsertUpdateRow.defineParameterType(3, OracleTypes.VARCHAR, 70); // p_actyp_cd
    _csInsertUpdateRow.defineParameterType(4, OracleTypes.VARCHAR, 4000); // p_act_comments
    _csInsertUpdateRow.defineParameterType(5, OracleTypes.VARCHAR, 12); // p_act_depth_height
    _csInsertUpdateRow.defineParameterType(6, OracleTypes.VARCHAR, 12); // p_act_depth_height_bottom
    _csInsertUpdateRow.defineParameterType(7, OracleTypes.VARCHAR, 125); // p_act_depth_altitude_ref_point
    _csInsertUpdateRow.defineParameterType(8, OracleTypes.VARCHAR, 12); // p_act_depth_height_top
    _csInsertUpdateRow.defineParameterType(9, OracleTypes.DATE, 0); // p_act_end_date
    _csInsertUpdateRow.defineParameterType(10, OracleTypes.DATE, 0); // p_act_end_time
    _csInsertUpdateRow.defineParameterType(11, OracleTypes.VARCHAR, 35); // p_act_id
    _csInsertUpdateRow.defineParameterType(12, OracleTypes.NUMBER, 0); // p_act_loc_latitude
    _csInsertUpdateRow.defineParameterType(13, OracleTypes.NUMBER, 0); // p_act_loc_longitude
    _csInsertUpdateRow.defineParameterType(14, OracleTypes.NUMBER, 8); // p_act_loc_source_map_scale
    _csInsertUpdateRow.defineParameterType(15, OracleTypes.DATE, 0); // p_act_start_date
    _csInsertUpdateRow.defineParameterType(16, OracleTypes.DATE, 0); // p_act_start_time
    _csInsertUpdateRow.defineParameterType(17, OracleTypes.VARCHAR, 20); // p_act_sam_collect_meth_id
    _csInsertUpdateRow.defineParameterType(18, OracleTypes.VARCHAR, 120); // p_act_sam_collect_meth_context
    _csInsertUpdateRow.defineParameterType(19, OracleTypes.VARCHAR, 120); // p_act_sam_collect_meth_name
    _csInsertUpdateRow.defineParameterType(20, OracleTypes.VARCHAR, 25); // p_act_sam_col_meth_qual_type
    _csInsertUpdateRow.defineParameterType(21, OracleTypes.VARCHAR, 500); // p_act_sam_collect_meth_desc
    _csInsertUpdateRow.defineParameterType(22, OracleTypes.VARCHAR, 4000); // p_act_sam_col_equip_comments
    _csInsertUpdateRow.defineParameterType(23, OracleTypes.VARCHAR, 20); // p_act_sam_prep_meth_id
    _csInsertUpdateRow.defineParameterType(24, OracleTypes.VARCHAR, 120); // p_act_sam_prep_meth_context
    _csInsertUpdateRow.defineParameterType(25, OracleTypes.VARCHAR, 120); // p_act_sam_prep_meth_name
    _csInsertUpdateRow.defineParameterType(26, OracleTypes.VARCHAR, 25); // p_act_sam_prep_meth_qual_type
    _csInsertUpdateRow.defineParameterType(27, OracleTypes.VARCHAR, 500); // p_act_sam_prep_meth_desc
    _csInsertUpdateRow.defineParameterType(28, OracleTypes.VARCHAR, 250); // p_act_sam_trans_stor_desc
    _csInsertUpdateRow.defineParameterType(29, OracleTypes.VARCHAR, 250); // p_act_sam_chem_preserv
    _csInsertUpdateRow.defineParameterType(30, OracleTypes.VARCHAR, 15); // p_concol_name
    _csInsertUpdateRow.defineParameterType(31, OracleTypes.VARCHAR, 35); // p_contyp_name
    _csInsertUpdateRow.defineParameterType(32, OracleTypes.VARCHAR, 45); // p_amsub_name
    _csInsertUpdateRow.defineParameterType(33, OracleTypes.VARCHAR, 70); // p_hcmth_name
    _csInsertUpdateRow.defineParameterType(34, OracleTypes.VARCHAR, 6); // p_hrdat_name
    _csInsertUpdateRow.defineParameterType(35, OracleTypes.VARCHAR, 35); // p_mloc_id
    _csInsertUpdateRow.defineParameterType(36, OracleTypes.VARCHAR, 12); // p_msunt_cd_depth_height
    _csInsertUpdateRow.defineParameterType(37, OracleTypes.VARCHAR, 12); // p_msunt_cd_depth_height_bottom
    _csInsertUpdateRow.defineParameterType(38, OracleTypes.VARCHAR, 12); // p_msunt_cd_depth_height_top
    _csInsertUpdateRow.defineParameterType(39, OracleTypes.VARCHAR, 15); // p_reldpth_name
    _csInsertUpdateRow.defineParameterType(40, OracleTypes.VARCHAR, 40); // p_sceqp_name
    _csInsertUpdateRow.defineParameterType(41, OracleTypes.VARCHAR, 30); // p_stant_name
    _csInsertUpdateRow.defineParameterType(42, OracleTypes.VARCHAR, 120); // p_tax_name
    _csInsertUpdateRow.defineParameterType(43, OracleTypes.VARCHAR, 25); // p_thprsv_name
    _csInsertUpdateRow.defineParameterType(44, OracleTypes.VARCHAR, 5); // p_tmzone_cd_start_time
    _csInsertUpdateRow.defineParameterType(45, OracleTypes.VARCHAR, 5); // p_tmzone_cd_end_time
    _csInsertUpdateRow.registerOutParameter(46, OracleTypes.NUMBER, 20); // p_act_uid
  }


  public void deleteActPrjRows (  
      String context,
      String actUid)

      throws SQLException {

    // set parameter values and call procedure
    _csDeleteActPrjRows.setString(1, context);
    _csDeleteActPrjRows.setString(2, actUid);
    _csDeleteActPrjRows.execute();
  }


  public void deleteConductingOrgRows (  
      String context,
      String actUid)

      throws SQLException {

    // set parameter values and call procedure
    _csDeleteConductingOrgRows.setString(1, context);
    _csDeleteConductingOrgRows.setString(2, actUid);
    _csDeleteConductingOrgRows.execute();
  }


  public void deleteRow (  
      String context,
      String actUid,
      String actId)

      throws SQLException {

    // set parameter values and call procedure
    _csDeleteRow.setString(1, context);
    _csDeleteRow.setString(2, actUid);
    _csDeleteRow.setString(3, actId);
    _csDeleteRow.execute();
  }


  public void deleteRowByActId (  
      String context,
      String actId)

      throws SQLException {

    // set parameter values and call procedure
    _csDeleteRowByActId.setString(1, context);
    _csDeleteRowByActId.setString(2, actId);
    _csDeleteRowByActId.execute();
  }


  public void deleteRowsByMlocUid (  
      String context,
      String mlocUid)

      throws SQLException {

    // set parameter values and call procedure
    _csDeleteRowsByMlocUid.setString(1, context);
    _csDeleteRowsByMlocUid.setString(2, mlocUid);
    _csDeleteRowsByMlocUid.execute();
  }


  public void deleteRowsByPrjUid (  
      String context,
      String prjUid)

      throws SQLException {

    // set parameter values and call procedure
    _csDeleteRowsByPrjUid.setString(1, context);
    _csDeleteRowsByPrjUid.setString(2, prjUid);
    _csDeleteRowsByPrjUid.execute();
  }


  public void insertConductingOrg (  
      String context,
      String actUid,
      String acorgName)

      throws SQLException {

    // set parameter values and call procedure
    _csInsertConductingOrg.setString(1, context);
    _csInsertConductingOrg.setString(2, actUid);
    _csInsertConductingOrg.setString(3, acorgName);
    _csInsertConductingOrg.execute();
  }


  public void insertProjectRef (  
      String context,
      String prjId,
      String actUid)

      throws SQLException {

    // set parameter values and call procedure
    _csInsertProjectRef.setString(1, context);
    _csInsertProjectRef.setString(2, prjId);
    _csInsertProjectRef.setString(3, actUid);
    _csInsertProjectRef.execute();
  }


  public String insertUpdateRow (  
      String context,
      String acmedName,
      String actypCd,
      String actComments,
      String actDepthHeight,
      String actDepthHeightBottom,
      String actDepthAltitudeRefPoint,
      String actDepthHeightTop,
      Date actEndDate,
      Time actEndTime,
      String actId,
      String actLocLatitude,
      String actLocLongitude,
      String actLocSourceMapScale,
      Date actStartDate,
      Time actStartTime,
      String actSamCollectMethId,
      String actSamCollectMethContext,
      String actSamCollectMethName,
      String actSamColMethQualType,
      String actSamCollectMethDesc,
      String actSamColEquipComments,
      String actSamPrepMethId,
      String actSamPrepMethContext,
      String actSamPrepMethName,
      String actSamPrepMethQualType,
      String actSamPrepMethDesc,
      String actSamTransStorDesc,
      String actSamChemPreserv,
      String concolName,
      String contypName,
      String amsubName,
      String hcmthName,
      String hrdatName,
      String mlocId,
      String msuntCdDepthHeight,
      String msuntCdDepthHeightBottom,
      String msuntCdDepthHeightTop,
      String reldpthName,
      String sceqpName,
      String stantName,
      String taxName,
      String thprsvName,
      String tmzoneCdStartTime,
      String tmzoneCdEndTime)

      throws SQLException {

    // set parameter values and call procedure
    _csInsertUpdateRow.setString(1, context);
    _csInsertUpdateRow.setString(2, acmedName);
    _csInsertUpdateRow.setString(3, actypCd);
    _csInsertUpdateRow.setString(4, actComments);
    _csInsertUpdateRow.setString(5, actDepthHeight);
    _csInsertUpdateRow.setString(6, actDepthHeightBottom);
    _csInsertUpdateRow.setString(7, actDepthAltitudeRefPoint);
    _csInsertUpdateRow.setString(8, actDepthHeightTop);
    _csInsertUpdateRow.setDate(9, actEndDate);
    _csInsertUpdateRow.setTime(10, actEndTime);
    _csInsertUpdateRow.setString(11, actId);
    _csInsertUpdateRow.setString(12, actLocLatitude);
    _csInsertUpdateRow.setString(13, actLocLongitude);
    _csInsertUpdateRow.setString(14, actLocSourceMapScale);
    _csInsertUpdateRow.setDate(15, actStartDate);
    _csInsertUpdateRow.setTime(16, actStartTime);
    _csInsertUpdateRow.setString(17, actSamCollectMethId);
    _csInsertUpdateRow.setString(18, actSamCollectMethContext);
    _csInsertUpdateRow.setString(19, actSamCollectMethName);
    _csInsertUpdateRow.setString(20, actSamColMethQualType);
    _csInsertUpdateRow.setString(21, actSamCollectMethDesc);
    _csInsertUpdateRow.setString(22, actSamColEquipComments);
    _csInsertUpdateRow.setString(23, actSamPrepMethId);
    _csInsertUpdateRow.setString(24, actSamPrepMethContext);
    _csInsertUpdateRow.setString(25, actSamPrepMethName);
    _csInsertUpdateRow.setString(26, actSamPrepMethQualType);
    _csInsertUpdateRow.setString(27, actSamPrepMethDesc);
    _csInsertUpdateRow.setString(28, actSamTransStorDesc);
    _csInsertUpdateRow.setString(29, actSamChemPreserv);
    _csInsertUpdateRow.setString(30, concolName);
    _csInsertUpdateRow.setString(31, contypName);
    _csInsertUpdateRow.setString(32, amsubName);
    _csInsertUpdateRow.setString(33, hcmthName);
    _csInsertUpdateRow.setString(34, hrdatName);
    _csInsertUpdateRow.setString(35, mlocId);
    _csInsertUpdateRow.setString(36, msuntCdDepthHeight);
    _csInsertUpdateRow.setString(37, msuntCdDepthHeightBottom);
    _csInsertUpdateRow.setString(38, msuntCdDepthHeightTop);
    _csInsertUpdateRow.setString(39, reldpthName);
    _csInsertUpdateRow.setString(40, sceqpName);
    _csInsertUpdateRow.setString(41, stantName);
    _csInsertUpdateRow.setString(42, taxName);
    _csInsertUpdateRow.setString(43, thprsvName);
    _csInsertUpdateRow.setString(44, tmzoneCdStartTime);
    _csInsertUpdateRow.setString(45, tmzoneCdEndTime);
    _csInsertUpdateRow.execute();
    // get out parameters and/or return value
    return _csInsertUpdateRow.getString(46);
  }

}