package gov.epa.wqx.node;

import java.sql.SQLException;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleTypes;

public class AttachedObjectPkg {

  private OracleConnection _connection = null;
  private OracleCallableStatement _csAppendContent;
  private OracleCallableStatement _csDeleteRow;
  private OracleCallableStatement _csDeleteRowsByTableRef;
  private OracleCallableStatement _csInsertRow;

  // constructor  
  public AttachedObjectPkg (
      OracleConnection connection) 
      
      throws SQLException {
      
    // make sure we're connected
    if (connection == null)
      throw new SQLException("Connection is null");
    else if(connection.isClosed())
      throw new SQLException("Connection is closed");
    _connection = connection;

    // APPEND CONTENT
    _csAppendContent = (OracleCallableStatement) _connection.prepareCall(
      "{call attached_object_pkg.append_content(?, ?, ?)}");
    _csAppendContent.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csAppendContent.defineParameterType(2, OracleTypes.NUMBER, 20); // p_atobj_uid
    _csAppendContent.defineParameterType(3, OracleTypes.BLOB, 0); // p_atobj_content

    // DELETE ROW
    _csDeleteRow = (OracleCallableStatement) _connection.prepareCall(
      "{call attached_object_pkg.delete_row(?, ?)}");
    _csDeleteRow.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csDeleteRow.defineParameterType(2, OracleTypes.NUMBER, 20); // p_atobj_uid

    // DELETE ROWS BY TABLE REF
    _csDeleteRowsByTableRef = (OracleCallableStatement) _connection.prepareCall(
      "{call attached_object_pkg.delete_rows_by_table_ref(?, ?, ?)}");
    _csDeleteRowsByTableRef.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csDeleteRowsByTableRef.defineParameterType(2, OracleTypes.NUMBER, 20); // p_ref_uid
    _csDeleteRowsByTableRef.defineParameterType(3, OracleTypes.NUMBER, 6); // p_tbl_uid

    // INSERT ROW
    _csInsertRow = (OracleCallableStatement) _connection.prepareCall(
      "{call attached_object_pkg.insert_row(?, ?, ?, ?, ?, ?)}");
    _csInsertRow.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csInsertRow.defineParameterType(2, OracleTypes.VARCHAR, 255); // p_atobj_file_name
    _csInsertRow.defineParameterType(3, OracleTypes.VARCHAR, 6); // p_atobj_type
    _csInsertRow.defineParameterType(4, OracleTypes.NUMBER, 20); // p_ref_uid
    _csInsertRow.defineParameterType(5, OracleTypes.NUMBER, 6); // p_tbl_uid
    _csInsertRow.registerOutParameter(6, OracleTypes.NUMBER, 20); // p_atobj_uid
  }


  public void appendContent (  
      String context,
      String atobjUid,
      String atobjContent)

      throws SQLException {

    // set parameter values and call procedure
    _csAppendContent.setString(1, context);
    _csAppendContent.setString(2, atobjUid);
    _csAppendContent.setString(3, atobjContent);
    _csAppendContent.execute();
  }


  public void deleteRow (  
      String context,
      String atobjUid)

      throws SQLException {

    // set parameter values and call procedure
    _csDeleteRow.setString(1, context);
    _csDeleteRow.setString(2, atobjUid);
    _csDeleteRow.execute();
  }


  public void deleteRowsByTableRef (  
      String context,
      String refUid,
      String tblUid)

      throws SQLException {

    // set parameter values and call procedure
    _csDeleteRowsByTableRef.setString(1, context);
    _csDeleteRowsByTableRef.setString(2, refUid);
    _csDeleteRowsByTableRef.setString(3, tblUid);
    _csDeleteRowsByTableRef.execute();
  }


  public String insertRow (  
      String context,
      String atobjFileName,
      String atobjType,
      String refUid,
      String tblUid)

      throws SQLException {

    // set parameter values and call procedure
    _csInsertRow.setString(1, context);
    _csInsertRow.setString(2, atobjFileName);
    _csInsertRow.setString(3, atobjType);
    _csInsertRow.setString(4, refUid);
    _csInsertRow.setString(5, tblUid);
    _csInsertRow.execute();
    // get out parameters and/or return value
    return _csInsertRow.getString(6);
  }

}