package gov.epa.wqx.node;

import java.sql.Date;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

import javax.naming.InitialContext;
import javax.naming.NamingException;

import javax.sql.DataSource;

import oracle.jdbc.OracleConnection;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import gov.epa.cdx.commons.property.CDXPropertyManager;

//import oracle.jdbc.pool.OracleDataSource;

public class Lib  {
  
  // log4j support
  static Log log = LogFactory.getLog(Lib.class.getName());
  
  private static String dataSourceUrl;
  private static String dataSourceUser;
  private static String dataSourcePassword;
  
    
  public static String getFileSeparator() {
    return System.getProperty("file.separator");  
  }
  
  
  public static boolean allowTwoWayCommunication() {
      
    try {
      String twoWayCommunication = CDXPropertyManager.getProperty("CDX", "TwoWayCommunication");
      log.info("TwoWayCommunication=" + twoWayCommunication);
      if (twoWayCommunication == null) {
        return true;
      }
      else if (twoWayCommunication.equalsIgnoreCase("False")) {
        return false;
      }
      else {
        return true;
      }
    }
    catch (Exception e) {
      log.error(e);
      return true;
    }
  }
  
  
  public static boolean useNaas() {
      
    try {
      String useNaasProperty = CDXPropertyManager.getProperty("NAAS", "UseNAAS");
      log.info("useNAAS=" + useNaasProperty);
      if (useNaasProperty == null) {
        return true;
      }
      else if (useNaasProperty.equalsIgnoreCase("False")) {
        return false;
      }
      else {
        return true;
      }
    }
    catch (Exception e) {
      log.error(e);
      return true;
    }
  }
  
  
  public static String getWorkingDirectory() {
    String workingFolder = CDXPropertyManager.getProperty("global", "WorkingDirectory").trim(); 
    if (!workingFolder.endsWith(Lib.getFileSeparator())) {
      workingFolder += Lib.getFileSeparator();
    }
    return workingFolder;
  }
  
  
  // override the default connection used by the application
  // mostly useful for testing
  public static synchronized void setDataSourceInfo(String url, String user, String password) {
    dataSourceUrl = url;
    dataSourceUser = user;
    dataSourcePassword = password;
  }
  
  
  private static synchronized OracleConnection getConnectionUsingUrl() 
      throws SQLException, ClassNotFoundException {
    
    log.debug("dataSourceUrl=" + dataSourceUrl);
    Class.forName("oracle.jdbc.driver.OracleDriver");
    return (OracleConnection) DriverManager.getConnection(
      dataSourceUrl, dataSourceUser, dataSourcePassword);
  }
  
  
  public static synchronized OracleConnection getWqxConnection() 
      throws SQLException, ClassNotFoundException, NamingException {
  
    OracleConnection connection;
    
    log.debug("getWqxConnection");
    if (dataSourceUrl != null) {
      // if the URL has been set, then use that method
      connection = getConnectionUsingUrl();  
    }
    else {
      // check the property file to determine what method to use
      String accessMethod = CDXPropertyManager.getProperty("DatabaseAccess", "AccessMethod");
      log.debug("accessMethod=" + accessMethod);
      if (accessMethod.equalsIgnoreCase("URL")) {
        // get a connection using the URL from the property file
        setDataSourceInfo(
          CDXPropertyManager.getProperty("DatabaseAccess", "URL"),
          CDXPropertyManager.getProperty("DatabaseAccess", "User"),
          CDXPropertyManager.getProperty("DatabaseAccess", "Password"));
        connection = getConnectionUsingUrl();
      }
      else {
        // otherwise use the dataSource defined on the Application Server
        String dataSourceName = CDXPropertyManager.getProperty("DatabaseAccess", "DataSourceName");
        InitialContext ic = new InitialContext();  
        DataSource ds = (DataSource) ic.lookup(dataSourceName);  
        connection = (OracleConnection) ds.getConnection(); 
      }
    }
    connection.setAutoCommit(false);
    return connection;
  } 
  
  
  public static String getNotifyXML(
      String status, 
      String operation, 
      Timestamp timestamp,
      String transactionID, 
      String message) {
    
    String returnVal = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
      + "<Notify xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\""
      + " xsi:noNamespaceSchemaLocation=\"notification.xsd\">\n"
      + "  <Status>" + status + "</Status>\n"
      + "  <Operation>" + operation + "</Operation>\n"
      + "  <DataFlow>WQX</DataFlow>\n"
      + "  <Timestamp>" + timestamp.toString().replace(' ','T') + "</Timestamp>\n"
      + "  <TransactionID>" + transactionID + "</TransactionID>\n"
      + "  <Message>" + message + "</Message>\n"
      + "</Notify>";
    return returnVal;
  }
  
  
  public static String getSimplifiedStackTrace(Exception exception, boolean sourceOnly) {
    String source;
    String stackLine;
    StringBuffer stackLines = new StringBuffer();
    StackTraceElement[] stack = exception.getStackTrace();
    for (int i=0; i < stack.length; i++) {
      if (stack[i].getClassName().indexOf("gov.epa") != -1) {
        stackLine = stack[i].getClassName() + "." + stack[i].getMethodName() + " (Line " + stack[i].getLineNumber() + ")";
        if (sourceOnly) {
          if (stackLine.length() > 100) {
            source = stackLine.substring(0,100);
          }
          else {
            source = stackLine;
          }
          return source;
        }
        else {
          stackLines.append(stackLine + "\n");
        }
      }
    }
    return stackLines.toString();
  }
  
// convert from xsd:date (ISO 8601) String to Date
  public static Date xmlToDate(String stringDateTime) 
      throws WqxException {
    
    try {
      if (stringDateTime == null) {
        return null;
      }
      stringDateTime = stringDateTime.trim();
      if (stringDateTime.equals("")) {
        return null;
      }
      else {  
        Date date = Date.valueOf(stringDateTime);
        return date;
      }
    }
    catch (Exception e) {
      throw new WqxException("Error parsing Date: " + stringDateTime, e, null);
    }
  }


  // format xsd:Time String as JDBC Time String
  private static String formatTime(String stringTime) {
      
    if (stringTime.endsWith("Z")) {
      // time is in UTC/GMT
      // drop the "Z"
      return stringTime.substring(0,stringTime.length()-1);    
    }
    else {
      int offsetPosition = stringTime.indexOf('-') + stringTime.indexOf('+') + 1;
      if (offsetPosition > 0) {
        // time is in local time (with offset from UTC/GMT)
        // drop the offset
        return stringTime.substring(0,offsetPosition);
      }
      else {
        // time without offset or Z
        return stringTime;  
      }
    }
  }
  
  
  // convert from xsd:time (ISO 8601) String to Time
  public static Time xmlToTime(String stringDateTime) 
      throws WqxException {
  
    try {
      if (stringDateTime == null) {
        return null;
      }
      stringDateTime = stringDateTime.trim();
      if (stringDateTime.equals("")) {
        return null;
      }
      else {  
        Time time = Time.valueOf(formatTime(stringDateTime));
        return time;
      }
    }
    catch (Exception e) {
      throw new WqxException("Error parsing time: " + stringDateTime, e, null);
    }  
  }
  
  
  // convert from xsd:dateTime (ISO 8601) String to Timestamp
  public static Timestamp xmlToTimestamp(String stringDateTime) 
      throws WqxException {
  
    try {
      if (stringDateTime == null) {
        return null;
      }
      stringDateTime = stringDateTime.trim();
      if (stringDateTime.equals("")) {
        return null;
      }
      else {  
        String stringDate;
        String stringTime;
        int timeDateDelimPos = stringDateTime.indexOf('T');
        stringDate = stringDateTime.substring(0,timeDateDelimPos);
        stringTime = formatTime(stringDateTime.substring(timeDateDelimPos + 1, stringDateTime.length()));
        if (stringTime.indexOf('.') == -1) {
          stringTime = stringTime + ".0";
        }
        stringDateTime = stringDate + " " + stringTime;
        Timestamp timestamp = Timestamp.valueOf(stringDateTime);
        return timestamp;
      }
    }
    catch (Exception e) {
      throw new WqxException("Error parsing Date/Time: " + stringDateTime, e, null);
    }  
  }

}