package gov.epa.wqx.node;

import java.sql.SQLException;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleTypes;

public class LibPkg {

  private OracleConnection _connection = null;
  private OracleCallableStatement _csGetConfigValue;
  private OracleCallableStatement _csGetVersion;
  private OracleCallableStatement _csRaiseError;
  private OracleCallableStatement _csUserOrgAccessAllowed;

  // constructor  
  public LibPkg (
      OracleConnection connection) 
      
      throws SQLException {
      
    // make sure we're connected
    if (connection == null)
      throw new SQLException("Connection is null");
    else if(connection.isClosed())
      throw new SQLException("Connection is closed");
    _connection = connection;

    // GET CONFIG VALUE
    _csGetConfigValue = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lib_pkg.get_config_value(?)}");
    _csGetConfigValue.registerOutParameter(1, OracleTypes.VARCHAR, 2000); // return value
    _csGetConfigValue.defineParameterType(2, OracleTypes.VARCHAR, 30); // p_config_cd

    // GET VERSION
    _csGetVersion = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lib_pkg.get_version()}");
    _csGetVersion.registerOutParameter(1, OracleTypes.VARCHAR, 25); // return value

    // RAISE ERROR
    _csRaiseError = (OracleCallableStatement) _connection.prepareCall(
      "{call lib_pkg.raise_error(?, ?, ?, ?, ?, ?, ?)}");
    _csRaiseError.defineParameterType(1, OracleTypes.VARCHAR, 1000); // p_context
    _csRaiseError.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_source
    _csRaiseError.defineParameterType(3, OracleTypes.VARCHAR, 2000); // p_error_msg
    _csRaiseError.defineParameterType(4, OracleTypes.NUMBER, 0); // p_error_num
    _csRaiseError.defineParameterType(5, OracleTypes.NUMBER, 0); // p_sqlcode
    _csRaiseError.defineParameterType(6, OracleTypes.VARCHAR, 4000); // p_sqlerrm
    _csRaiseError.defineParameterType(7, OracleTypes.VARCHAR, 1); // p_force_err_yn

    // USER ORG ACCESS ALLOWED
    _csUserOrgAccessAllowed = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lib_pkg.user_org_access_allowed(?, ?, ?)}");
    _csUserOrgAccessAllowed.registerOutParameter(1, OracleTypes.VARCHAR, 1); // return value
    _csUserOrgAccessAllowed.defineParameterType(2, OracleTypes.NUMBER, 6); // p_usr_uid
    _csUserOrgAccessAllowed.defineParameterType(3, OracleTypes.NUMBER, 20); // p_org_uid
    _csUserOrgAccessAllowed.defineParameterType(4, OracleTypes.NUMBER, 6); // p_acctyp_uid
  }


  public String getConfigValue (  
      String configCd)

      throws SQLException {

    // set parameter values and call procedure
    _csGetConfigValue.setString(2, configCd);
    _csGetConfigValue.execute();
    // get out parameters and/or return value
    return _csGetConfigValue.getString(1);
  }

  public String getVersion (  )

      throws SQLException {

    // set parameter values and call procedure
    _csGetVersion.execute();
    // get out parameters and/or return value
    return _csGetVersion.getString(1);
  }

  public void raiseError (  
      String context,
      String source,
      String errorMsg,
      String errorNum,
      String sqlcode,
      String sqlerrm,
      String forceErrYn)

      throws SQLException {

    // set parameter values and call procedure
    _csRaiseError.setString(1, context);
    _csRaiseError.setString(2, source);
    _csRaiseError.setString(3, errorMsg);
    _csRaiseError.setString(4, errorNum);
    _csRaiseError.setString(5, sqlcode);
    _csRaiseError.setString(6, sqlerrm);
    _csRaiseError.setString(7, forceErrYn);
    _csRaiseError.execute();
  }


  public String userOrgAccessAllowed (  
      String usrUid,
      String orgUid,
      String acctypUid)

      throws SQLException {

    // set parameter values and call procedure
    _csUserOrgAccessAllowed.setString(2, usrUid);
    _csUserOrgAccessAllowed.setString(3, orgUid);
    _csUserOrgAccessAllowed.setString(4, acctypUid);
    _csUserOrgAccessAllowed.execute();
    // get out parameters and/or return value
    return _csUserOrgAccessAllowed.getString(1);
  }

}