package gov.epa.wqx.node;

import java.sql.SQLException;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleTypes;

public class LookupTblPkg {

  private OracleConnection _connection = null;
  private OracleCallableStatement _csGetAcmedUid;
  private OracleCallableStatement _csGetActypUid;
  private OracleCallableStatement _csGetAddtypUid;
  private OracleCallableStatement _csGetAmsubUid;
  private OracleCallableStatement _csGetAnlmthUid;
  private OracleCallableStatement _csGetChrUid;
  private OracleCallableStatement _csGetCntryUid;
  private OracleCallableStatement _csGetCntyUid;
  private OracleCallableStatement _csGetConcolUid;
  private OracleCallableStatement _csGetContypUid;
  private OracleCallableStatement _csGetCplvalUid;
  private OracleCallableStatement _csGetDqltypUid;
  private OracleCallableStatement _csGetEatypUid;
  private OracleCallableStatement _csGetHcmthUid;
  private OracleCallableStatement _csGetHrdatUid;
  private OracleCallableStatement _csGetMltypUid;
  private OracleCallableStatement _csGetMsuntUid;
  private OracleCallableStatement _csGetPhtypUid;
  private OracleCallableStatement _csGetRdcndUid;
  private OracleCallableStatement _csGetReldpthUid;
  private OracleCallableStatement _csGetResstaUid;
  private OracleCallableStatement _csGetRlcomUid;
  private OracleCallableStatement _csGetRmqlfUid;
  private OracleCallableStatement _csGetRsbasUid;
  private OracleCallableStatement _csGetRtimbUid;
  private OracleCallableStatement _csGetRtmpbUid;
  private OracleCallableStatement _csGetRvtypUid;
  private OracleCallableStatement _csGetRwbasUid;
  private OracleCallableStatement _csGetSceqpUid;
  private OracleCallableStatement _csGetSmfrcUid;
  private OracleCallableStatement _csGetStUid;
  private OracleCallableStatement _csGetStantUid;
  private OracleCallableStatement _csGetTaxUid;
  private OracleCallableStatement _csGetThprsvUid;
  private OracleCallableStatement _csGetTmzoneUid;
  private OracleCallableStatement _csGetTrbUid;
  private OracleCallableStatement _csGetUsrUid;
  private OracleCallableStatement _csGetVcmthUid;
  private OracleCallableStatement _csGetVrdatUid;

  // constructor  
  public LookupTblPkg (
      OracleConnection connection) 
      
      throws SQLException {
      
    // make sure we're connected
    if (connection == null)
      throw new SQLException("Connection is null");
    else if(connection.isClosed())
      throw new SQLException("Connection is closed");
    _connection = connection;

    // GET ACMED UID
    _csGetAcmedUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_acmed_uid(?, ?)}");
    _csGetAcmedUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetAcmedUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetAcmedUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_acmed_name

    // GET ACTYP UID
    _csGetActypUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_actyp_uid(?, ?)}");
    _csGetActypUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetActypUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetActypUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_actyp_cd

    // GET ADDTYP UID
    _csGetAddtypUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_addtyp_uid(?, ?)}");
    _csGetAddtypUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetAddtypUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetAddtypUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_addtyp_name

    // GET AMSUB UID
    _csGetAmsubUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_amsub_uid(?, ?)}");
    _csGetAmsubUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetAmsubUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetAmsubUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_amsub_name

    // GET ANLMTH UID
    _csGetAnlmthUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_anlmth_uid(?, ?, ?, ?, ?, ?)}");
    _csGetAnlmthUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetAnlmthUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetAnlmthUid.defineParameterType(3, OracleTypes.VARCHAR, 30); // p_amctx_cd
    _csGetAnlmthUid.defineParameterType(4, OracleTypes.VARCHAR, 20); // p_anlmth_id
    _csGetAnlmthUid.defineParameterType(5, OracleTypes.VARCHAR, 120); // p_anlmth_name
    _csGetAnlmthUid.defineParameterType(6, OracleTypes.VARCHAR, 500); // p_anlmth_desc
    _csGetAnlmthUid.defineParameterType(7, OracleTypes.VARCHAR, 25); // p_anlmth_qual_type
    
    // GET CHR UID
    _csGetChrUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_chr_uid(?, ?)}");
    _csGetChrUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetChrUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetChrUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_chr_name

    // GET CNTRY UID
    _csGetCntryUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_cntry_uid(?, ?)}");
    _csGetCntryUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetCntryUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetCntryUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_cntry_cd

    // GET CNTY UID
    _csGetCntyUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_cnty_uid(?, ?, ?)}");
    _csGetCntyUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetCntyUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetCntyUid.defineParameterType(3, OracleTypes.NUMBER, 0); // p_cnty_fips_cd
    _csGetCntyUid.defineParameterType(4, OracleTypes.VARCHAR, 200); // p_st_uid

    // GET CONCOL UID
    _csGetConcolUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_concol_uid(?, ?)}");
    _csGetConcolUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetConcolUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetConcolUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_concol_name

    // GET CONTYP UID
    _csGetContypUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_contyp_uid(?, ?)}");
    _csGetContypUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetContypUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetContypUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_contyp_name

    // GET CPLVAL UID
    _csGetCplvalUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_cplval_uid(?, ?)}");
    _csGetCplvalUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetCplvalUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetCplvalUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_cplval_cd

    // GET DQLTYP UID
    _csGetDqltypUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_dqltyp_uid(?, ?)}");
    _csGetDqltypUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetDqltypUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetDqltypUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_dqltyp_name

    // GET EATYP UID
    _csGetEatypUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_eatyp_uid(?, ?)}");
    _csGetEatypUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetEatypUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetEatypUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_eatyp_name

    // GET HCMTH UID
    _csGetHcmthUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_hcmth_uid(?, ?)}");
    _csGetHcmthUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetHcmthUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetHcmthUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_hcmth_name

    // GET HRDAT UID
    _csGetHrdatUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_hrdat_uid(?, ?)}");
    _csGetHrdatUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetHrdatUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetHrdatUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_hrdat_name

    // GET MLTYP UID
    _csGetMltypUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_mltyp_uid(?, ?)}");
    _csGetMltypUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetMltypUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetMltypUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_mltyp_name

    // GET MSUNT UID
    _csGetMsuntUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_msunt_uid(?, ?)}");
    _csGetMsuntUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetMsuntUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetMsuntUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_msunt_cd

    // GET PHTYP UID
    _csGetPhtypUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_phtyp_uid(?, ?)}");
    _csGetPhtypUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetPhtypUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetPhtypUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_phtyp_name

    // GET RDCND UID
    _csGetRdcndUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_rdcnd_uid(?, ?)}");
    _csGetRdcndUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetRdcndUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetRdcndUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_rdcnd_name

    // GET RELDPTH UID
    _csGetReldpthUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_reldpth_uid(?, ?)}");
    _csGetReldpthUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetReldpthUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetReldpthUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_reldpth_name

    // GET RESSTA UID
    _csGetResstaUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_ressta_uid(?, ?)}");
    _csGetResstaUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetResstaUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetResstaUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_ressta_name

    // GET RLCOM UID
    _csGetRlcomUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_rlcom_uid(?, ?)}");
    _csGetRlcomUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetRlcomUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetRlcomUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_rlcom_cd

    // GET RMQLF UID
    _csGetRmqlfUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_rmqlf_uid(?, ?)}");
    _csGetRmqlfUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetRmqlfUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetRmqlfUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_rmqlf_cd

    // GET RSBAS UID
    _csGetRsbasUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_rsbas_uid(?, ?)}");
    _csGetRsbasUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetRsbasUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetRsbasUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_rsbas_cd

    // GET RTIMB UID
    _csGetRtimbUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_rtimb_uid(?, ?)}");
    _csGetRtimbUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetRtimbUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetRtimbUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_rtimb_name

    // GET RTMPB UID
    _csGetRtmpbUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_rtmpb_uid(?, ?)}");
    _csGetRtmpbUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetRtmpbUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetRtmpbUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_rtmpb_name

    // GET RVTYP UID
    _csGetRvtypUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_rvtyp_uid(?, ?)}");
    _csGetRvtypUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetRvtypUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetRvtypUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_rvtyp_name

    // GET RWBAS UID
    _csGetRwbasUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_rwbas_uid(?, ?)}");
    _csGetRwbasUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetRwbasUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetRwbasUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_rwbas_name

    // GET SCEQP UID
    _csGetSceqpUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_sceqp_uid(?, ?)}");
    _csGetSceqpUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetSceqpUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetSceqpUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_sceqp_name

    // GET SMFRC UID
    _csGetSmfrcUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_smfrc_uid(?, ?)}");
    _csGetSmfrcUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetSmfrcUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetSmfrcUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_smfrc_name

    // GET ST UID
    _csGetStUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_st_uid(?, ?)}");
    _csGetStUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetStUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetStUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_st_cd

    // GET STANT UID
    _csGetStantUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_stant_uid(?, ?)}");
    _csGetStantUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetStantUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetStantUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_stant_name

    // GET TAX UID
    _csGetTaxUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_tax_uid(?, ?)}");
    _csGetTaxUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetTaxUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetTaxUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_tax_name

    // GET THPRSV UID
    _csGetThprsvUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_thprsv_uid(?, ?)}");
    _csGetThprsvUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetThprsvUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetThprsvUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_thprsv_name

    // GET TMZONE UID
    _csGetTmzoneUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_tmzone_uid(?, ?)}");
    _csGetTmzoneUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetTmzoneUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetTmzoneUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_tmzone_cd

    // GET TRB UID
    _csGetTrbUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_trb_uid(?, ?)}");
    _csGetTrbUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetTrbUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetTrbUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_trb_cd

    // GET USR UID
    _csGetUsrUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_usr_uid(?, ?)}");
    _csGetUsrUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetUsrUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetUsrUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_usr_naas_id

    // GET VCMTH UID
    _csGetVcmthUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_vcmth_uid(?, ?)}");
    _csGetVcmthUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetVcmthUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetVcmthUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_vcmth_name

    // GET VRDAT UID
    _csGetVrdatUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call lookup_tbl_pkg.get_vrdat_uid(?, ?)}");
    _csGetVrdatUid.registerOutParameter(1, OracleTypes.NUMBER, 0); // return value
    _csGetVrdatUid.defineParameterType(2, OracleTypes.VARCHAR, 1000); // p_context
    _csGetVrdatUid.defineParameterType(3, OracleTypes.VARCHAR, 200); // p_vrdat_name
  }


  public String getAcmedUid (  
      String context,
      String acmedName)

      throws SQLException {

    // set parameter values and call procedure
    _csGetAcmedUid.setString(2, context);
    _csGetAcmedUid.setString(3, acmedName);
    _csGetAcmedUid.execute();
    // get out parameters and/or return value
    return _csGetAcmedUid.getString(1);
  }

  public String getActypUid (  
      String context,
      String actypCd)

      throws SQLException {

    // set parameter values and call procedure
    _csGetActypUid.setString(2, context);
    _csGetActypUid.setString(3, actypCd);
    _csGetActypUid.execute();
    // get out parameters and/or return value
    return _csGetActypUid.getString(1);
  }

  public String getAddtypUid (  
      String context,
      String addtypName)

      throws SQLException {

    // set parameter values and call procedure
    _csGetAddtypUid.setString(2, context);
    _csGetAddtypUid.setString(3, addtypName);
    _csGetAddtypUid.execute();
    // get out parameters and/or return value
    return _csGetAddtypUid.getString(1);
  }

  public String getAmsubUid (  
      String context,
      String amsubName)

      throws SQLException {

    // set parameter values and call procedure
    _csGetAmsubUid.setString(2, context);
    _csGetAmsubUid.setString(3, amsubName);
    _csGetAmsubUid.execute();
    // get out parameters and/or return value
    return _csGetAmsubUid.getString(1);
  }

  public String getAnlmthUid (  
      String context,
      String amctxCd,
      String anlmthId,
      String anlmthName,
      String anlmthDesc,
      String anlmthQualType)

      throws SQLException {

    // set parameter values and call procedure
    _csGetAnlmthUid.setString(2, context);
    _csGetAnlmthUid.setString(3, amctxCd);
    _csGetAnlmthUid.setString(4, anlmthId);
    _csGetAnlmthUid.setString(5, anlmthName);
    _csGetAnlmthUid.setString(6, anlmthDesc);
    _csGetAnlmthUid.setString(7, anlmthQualType);
    _csGetAnlmthUid.execute();
    // get out parameters and/or return value
    return _csGetAnlmthUid.getString(1);
  }

  public String getChrUid (  
      String context,
      String chrName)

      throws SQLException {

    // set parameter values and call procedure
    _csGetChrUid.setString(2, context);
    _csGetChrUid.setString(3, chrName);
    _csGetChrUid.execute();
    // get out parameters and/or return value
    return _csGetChrUid.getString(1);
  }

  public String getCntryUid (  
      String context,
      String cntryCd)

      throws SQLException {

    // set parameter values and call procedure
    _csGetCntryUid.setString(2, context);
    _csGetCntryUid.setString(3, cntryCd);
    _csGetCntryUid.execute();
    // get out parameters and/or return value
    return _csGetCntryUid.getString(1);
  }

  public String getCntyUid (  
      String context,
      String cntyFipsCd,
      String stUid)

      throws SQLException {

    // set parameter values and call procedure
    _csGetCntyUid.setString(2, context);
    _csGetCntyUid.setString(3, cntyFipsCd);
    _csGetCntyUid.setString(4, stUid);
    _csGetCntyUid.execute();
    // get out parameters and/or return value
    return _csGetCntyUid.getString(1);
  }

  public String getConcolUid (  
      String context,
      String concolName)

      throws SQLException {

    // set parameter values and call procedure
    _csGetConcolUid.setString(2, context);
    _csGetConcolUid.setString(3, concolName);
    _csGetConcolUid.execute();
    // get out parameters and/or return value
    return _csGetConcolUid.getString(1);
  }

  public String getContypUid (  
      String context,
      String contypName)

      throws SQLException {

    // set parameter values and call procedure
    _csGetContypUid.setString(2, context);
    _csGetContypUid.setString(3, contypName);
    _csGetContypUid.execute();
    // get out parameters and/or return value
    return _csGetContypUid.getString(1);
  }

  public String getCplvalUid (  
      String context,
      String cplvalCd)

      throws SQLException {

    // set parameter values and call procedure
    _csGetCplvalUid.setString(2, context);
    _csGetCplvalUid.setString(3, cplvalCd);
    _csGetCplvalUid.execute();
    // get out parameters and/or return value
    return _csGetCplvalUid.getString(1);
  }

  public String getDqltypUid (  
      String context,
      String dqltypName)

      throws SQLException {

    // set parameter values and call procedure
    _csGetDqltypUid.setString(2, context);
    _csGetDqltypUid.setString(3, dqltypName);
    _csGetDqltypUid.execute();
    // get out parameters and/or return value
    return _csGetDqltypUid.getString(1);
  }

  public String getEatypUid (  
      String context,
      String eatypName)

      throws SQLException {

    // set parameter values and call procedure
    _csGetEatypUid.setString(2, context);
    _csGetEatypUid.setString(3, eatypName);
    _csGetEatypUid.execute();
    // get out parameters and/or return value
    return _csGetEatypUid.getString(1);
  }

  public String getHcmthUid (  
      String context,
      String hcmthName)

      throws SQLException {

    // set parameter values and call procedure
    _csGetHcmthUid.setString(2, context);
    _csGetHcmthUid.setString(3, hcmthName);
    _csGetHcmthUid.execute();
    // get out parameters and/or return value
    return _csGetHcmthUid.getString(1);
  }

  public String getHrdatUid (  
      String context,
      String hrdatName)

      throws SQLException {

    // set parameter values and call procedure
    _csGetHrdatUid.setString(2, context);
    _csGetHrdatUid.setString(3, hrdatName);
    _csGetHrdatUid.execute();
    // get out parameters and/or return value
    return _csGetHrdatUid.getString(1);
  }

  public String getMltypUid (  
      String context,
      String mltypName)

      throws SQLException {

    // set parameter values and call procedure
    _csGetMltypUid.setString(2, context);
    _csGetMltypUid.setString(3, mltypName);
    _csGetMltypUid.execute();
    // get out parameters and/or return value
    return _csGetMltypUid.getString(1);
  }

  public String getMsuntUid (  
      String context,
      String msuntCd)

      throws SQLException {

    // set parameter values and call procedure
    _csGetMsuntUid.setString(2, context);
    _csGetMsuntUid.setString(3, msuntCd);
    _csGetMsuntUid.execute();
    // get out parameters and/or return value
    return _csGetMsuntUid.getString(1);
  }

  public String getPhtypUid (  
      String context,
      String phtypName)

      throws SQLException {

    // set parameter values and call procedure
    _csGetPhtypUid.setString(2, context);
    _csGetPhtypUid.setString(3, phtypName);
    _csGetPhtypUid.execute();
    // get out parameters and/or return value
    return _csGetPhtypUid.getString(1);
  }

  public String getRdcndUid (  
      String context,
      String rdcndName)

      throws SQLException {

    // set parameter values and call procedure
    _csGetRdcndUid.setString(2, context);
    _csGetRdcndUid.setString(3, rdcndName);
    _csGetRdcndUid.execute();
    // get out parameters and/or return value
    return _csGetRdcndUid.getString(1);
  }

  public String getReldpthUid (  
      String context,
      String reldpthName)

      throws SQLException {

    // set parameter values and call procedure
    _csGetReldpthUid.setString(2, context);
    _csGetReldpthUid.setString(3, reldpthName);
    _csGetReldpthUid.execute();
    // get out parameters and/or return value
    return _csGetReldpthUid.getString(1);
  }

  public String getResstaUid (  
      String context,
      String resstaName)

      throws SQLException {

    // set parameter values and call procedure
    _csGetResstaUid.setString(2, context);
    _csGetResstaUid.setString(3, resstaName);
    _csGetResstaUid.execute();
    // get out parameters and/or return value
    return _csGetResstaUid.getString(1);
  }

  public String getRlcomUid (  
      String context,
      String rlcomCd)

      throws SQLException {

    // set parameter values and call procedure
    _csGetRlcomUid.setString(2, context);
    _csGetRlcomUid.setString(3, rlcomCd);
    _csGetRlcomUid.execute();
    // get out parameters and/or return value
    return _csGetRlcomUid.getString(1);
  }

  public String getRmqlfUid (  
      String context,
      String rmqlfCd)

      throws SQLException {

    // set parameter values and call procedure
    _csGetRmqlfUid.setString(2, context);
    _csGetRmqlfUid.setString(3, rmqlfCd);
    _csGetRmqlfUid.execute();
    // get out parameters and/or return value
    return _csGetRmqlfUid.getString(1);
  }

  public String getRsbasUid (  
      String context,
      String rsbasCd)

      throws SQLException {

    // set parameter values and call procedure
    _csGetRsbasUid.setString(2, context);
    _csGetRsbasUid.setString(3, rsbasCd);
    _csGetRsbasUid.execute();
    // get out parameters and/or return value
    return _csGetRsbasUid.getString(1);
  }

  public String getRtimbUid (  
      String context,
      String rtimbName)

      throws SQLException {

    // set parameter values and call procedure
    _csGetRtimbUid.setString(2, context);
    _csGetRtimbUid.setString(3, rtimbName);
    _csGetRtimbUid.execute();
    // get out parameters and/or return value
    return _csGetRtimbUid.getString(1);
  }

  public String getRtmpbUid (  
      String context,
      String rtmpbName)

      throws SQLException {

    // set parameter values and call procedure
    _csGetRtmpbUid.setString(2, context);
    _csGetRtmpbUid.setString(3, rtmpbName);
    _csGetRtmpbUid.execute();
    // get out parameters and/or return value
    return _csGetRtmpbUid.getString(1);
  }

  public String getRvtypUid (  
      String context,
      String rvtypName)

      throws SQLException {

    // set parameter values and call procedure
    _csGetRvtypUid.setString(2, context);
    _csGetRvtypUid.setString(3, rvtypName);
    _csGetRvtypUid.execute();
    // get out parameters and/or return value
    return _csGetRvtypUid.getString(1);
  }

  public String getRwbasUid (  
      String context,
      String rwbasName)

      throws SQLException {

    // set parameter values and call procedure
    _csGetRwbasUid.setString(2, context);
    _csGetRwbasUid.setString(3, rwbasName);
    _csGetRwbasUid.execute();
    // get out parameters and/or return value
    return _csGetRwbasUid.getString(1);
  }

  public String getSceqpUid (  
      String context,
      String sceqpName)

      throws SQLException {

    // set parameter values and call procedure
    _csGetSceqpUid.setString(2, context);
    _csGetSceqpUid.setString(3, sceqpName);
    _csGetSceqpUid.execute();
    // get out parameters and/or return value
    return _csGetSceqpUid.getString(1);
  }

  public String getSmfrcUid (  
      String context,
      String smfrcName)

      throws SQLException {

    // set parameter values and call procedure
    _csGetSmfrcUid.setString(2, context);
    _csGetSmfrcUid.setString(3, smfrcName);
    _csGetSmfrcUid.execute();
    // get out parameters and/or return value
    return _csGetSmfrcUid.getString(1);
  }

  public String getStUid (  
      String context,
      String stCd)

      throws SQLException {

    // set parameter values and call procedure
    _csGetStUid.setString(2, context);
    _csGetStUid.setString(3, stCd);
    _csGetStUid.execute();
    // get out parameters and/or return value
    return _csGetStUid.getString(1);
  }

  public String getStantUid (  
      String context,
      String stantName)

      throws SQLException {

    // set parameter values and call procedure
    _csGetStantUid.setString(2, context);
    _csGetStantUid.setString(3, stantName);
    _csGetStantUid.execute();
    // get out parameters and/or return value
    return _csGetStantUid.getString(1);
  }

  public String getTaxUid (  
      String context,
      String taxName)

      throws SQLException {

    // set parameter values and call procedure
    _csGetTaxUid.setString(2, context);
    _csGetTaxUid.setString(3, taxName);
    _csGetTaxUid.execute();
    // get out parameters and/or return value
    return _csGetTaxUid.getString(1);
  }

  public String getThprsvUid (  
      String context,
      String thprsvName)

      throws SQLException {

    // set parameter values and call procedure
    _csGetThprsvUid.setString(2, context);
    _csGetThprsvUid.setString(3, thprsvName);
    _csGetThprsvUid.execute();
    // get out parameters and/or return value
    return _csGetThprsvUid.getString(1);
  }

  public String getTmzoneUid (  
      String context,
      String tmzoneCd)

      throws SQLException {

    // set parameter values and call procedure
    _csGetTmzoneUid.setString(2, context);
    _csGetTmzoneUid.setString(3, tmzoneCd);
    _csGetTmzoneUid.execute();
    // get out parameters and/or return value
    return _csGetTmzoneUid.getString(1);
  }

  public String getTrbUid (  
      String context,
      String trbCd)

      throws SQLException {

    // set parameter values and call procedure
    _csGetTrbUid.setString(2, context);
    _csGetTrbUid.setString(3, trbCd);
    _csGetTrbUid.execute();
    // get out parameters and/or return value
    return _csGetTrbUid.getString(1);
  }

  public String getUsrUid (  
      String context,
      String usrNaasId)

      throws SQLException {

    // set parameter values and call procedure
    _csGetUsrUid.setString(2, context);
    _csGetUsrUid.setString(3, usrNaasId);
    _csGetUsrUid.execute();
    // get out parameters and/or return value
    return _csGetUsrUid.getString(1);
  }

  public String getVcmthUid (  
      String context,
      String vcmthName)

      throws SQLException {

    // set parameter values and call procedure
    _csGetVcmthUid.setString(2, context);
    _csGetVcmthUid.setString(3, vcmthName);
    _csGetVcmthUid.execute();
    // get out parameters and/or return value
    return _csGetVcmthUid.getString(1);
  }

  public String getVrdatUid (  
      String context,
      String vrdatName)

      throws SQLException {

    // set parameter values and call procedure
    _csGetVrdatUid.setString(2, context);
    _csGetVrdatUid.setString(3, vrdatName);
    _csGetVrdatUid.execute();
    // get out parameters and/or return value
    return _csGetVrdatUid.getString(1);
  }

}