package gov.epa.wqx.node;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MonitoringLocation extends SchemaComponent {
  
  // ---------------------------------------------------------------------
  // Private/Protected Variables
  // ---------------------------------------------------------------------
  private MonitoringLocationPkg _pkg;
  private String       _monitoringLocationIdentifier;
  private String       _monitoringLocationName;
  private String       _monitoringLocationTypeName;
  private String       _monitoringLocationDescriptionText;
  private String       _hucEightDigitCode;
  private String       _hucTwelveDigitCode;
  private String       _tribalLandIndicator;
  private String       _tribalLandName;
  private Map          _alternateMonitoringLocationIdentifiers;
  private String       _latitudeMeasure;
  private String       _longitudeMeasure;
  private String       _sourceMapScaleNumeric;
  private String       _horizontalCollectionMethodName;
  private String       _horizontalCoordinateReferenceSystemDatumName;
  private String       _verticalMeasureValue;
  private String       _verticalMeasureUnitCode;
  private String       _verticalCollectionMethodName;
  private String       _verticalCoordinateReferenceSystemDatumName;
  private String       _countryCode;
  private String       _stateCode;
  private String       _countyCode;
  
  // ---------------------------------------------------------------------
  // Constructors
  // ---------------------------------------------------------------------
  public MonitoringLocation(SchemaComponent parent)
      throws WqxFatalException {
      
    super(parent);
    try {
      _transactionalBoundary = true;
      _alternateMonitoringLocationIdentifiers = Collections.synchronizedMap(new HashMap());
      this.clear();
      _pkg = new MonitoringLocationPkg(_connection);
    }
    catch(Exception e) {
      _transactionLog.logError(e);
    }
  }

  
  // ---------------------------------------------------------------------
  // Get/Set Methods
  // ---------------------------------------------------------------------
  
  public void setMonitoringLocationIdentifier(String monitoringLocationIdentifier)
      throws WqxFatalException {
      
    _monitoringLocationIdentifier = setValue(monitoringLocationIdentifier);
  }


  public String getMonitoringLocationIdentifier() {
    return _monitoringLocationIdentifier;
  }


  public void setMonitoringLocationName(String monitoringLocationName)
      throws WqxFatalException {
      
    _monitoringLocationName = setValue(monitoringLocationName);
  }


  public String getMonitoringLocationName() {
    return _monitoringLocationName;
  }


  public void setMonitoringLocationTypeName(String monitoringLocationTypeName)
      throws WqxFatalException {
      
    _monitoringLocationTypeName = setValue(monitoringLocationTypeName);
  }


  public String getMonitoringLocationTypeName() {
    return _monitoringLocationTypeName;
  }


  public void setMonitoringLocationDescriptionText(String monitoringLocationDescriptionText)
      throws WqxFatalException {
      
    _monitoringLocationDescriptionText = setValue(monitoringLocationDescriptionText);
  }


  public String getMonitoringLocationDescriptionText() {
    return _monitoringLocationDescriptionText;
  }


  public void setHucEightDigitCode(String HucEightDigitCode)
      throws WqxFatalException {
      
    _hucEightDigitCode = setValue(HucEightDigitCode);
  }


  public String getHucEightDigitCode() {
    return _hucEightDigitCode;
  }


  public void setHucTwelveDigitCode(String HucTwelveDigitCode)
      throws WqxFatalException {
      
    _hucTwelveDigitCode = setValue(HucTwelveDigitCode);
  }


  public String getHucTwelveDigitCode() {
    return _hucTwelveDigitCode;
  }


  public void setTribalLandIndicator(String tribalLandIndicator)
      throws WqxFatalException {
      
    _tribalLandIndicator = setValue(tribalLandIndicator);
  }


  public String getTribalLandIndicator() {
    return _tribalLandIndicator;
  }


  public void setTribalLandName(String tribalLandName)
      throws WqxFatalException {
      
    _tribalLandName = setValue(tribalLandName);
  }


  public String getTribalLandName() {
    return _tribalLandName;
  }


  public void setLatitudeMeasure(String latitudeMeasure)
      throws WqxFatalException {
      
    _latitudeMeasure = setValue(latitudeMeasure);
  }


  public String getLatitudeMeasure() {
    return _latitudeMeasure;
  }


  public void setLongitudeMeasure(String longitudeMeasure)
      throws WqxFatalException {
      
    _longitudeMeasure = setValue(longitudeMeasure);
  }


  public String getLongitudeMeasure() {
    return _longitudeMeasure;
  }


  public void setSourceMapScaleNumeric(String sourceMapScaleNumeric)
      throws WqxFatalException {
      
    _sourceMapScaleNumeric = setValue(sourceMapScaleNumeric);
  }


  public String getSourceMapScaleNumeric() {
    return _sourceMapScaleNumeric;
  }


  public void setHorizontalCollectionMethodName(String horizontalCollectionMethodName)
      throws WqxFatalException {
      
    _horizontalCollectionMethodName = setValue(horizontalCollectionMethodName);
  }


  public String getHorizontalCollectionMethodName() {
    return _horizontalCollectionMethodName;
  }


  public void setHorizontalCoordinateReferenceSystemDatumName(String horizontalCoordinateReferenceSystemDatumName)
      throws WqxFatalException {
      
    _horizontalCoordinateReferenceSystemDatumName = setValue(horizontalCoordinateReferenceSystemDatumName);
  }


  public String getHorizontalCoordinateReferenceSystemDatumName() {
    return _horizontalCoordinateReferenceSystemDatumName;
  }


  public void setVerticalMeasureValue(String verticalMeasureValue)
      throws WqxFatalException {
      
    _verticalMeasureValue = setValue(verticalMeasureValue);
  }


  public String getVerticalMeasureValue() {
    return _verticalMeasureValue;
  }


  public void setVerticalMeasureUnitCode(String verticalMeasureUnitCode)
      throws WqxFatalException {
      
    _verticalMeasureUnitCode = setValue(verticalMeasureUnitCode);
  }


  public String getVerticalMeasureUnitCode() {
    return _verticalMeasureUnitCode;
  }


  public void setVerticalCollectionMethodName(String verticalCollectionMethodName)
      throws WqxFatalException {
      
    _verticalCollectionMethodName = setValue(verticalCollectionMethodName);
  }


  public String getVerticalCollectionMethodName() {
    return _verticalCollectionMethodName;
  }


  public void setVerticalCoordinateReferenceSystemDatumName(String verticalCoordinateReferenceSystemDatumName)
      throws WqxFatalException {
      
    _verticalCoordinateReferenceSystemDatumName = setValue(verticalCoordinateReferenceSystemDatumName);
  }


  public String getVerticalCoordinateReferenceSystemDatumName() {
    return _verticalCoordinateReferenceSystemDatumName;
  }


  public void setCountryCode(String countryCode)
      throws WqxFatalException {
      
    _countryCode = setValue(countryCode);
  }


  public String getCountryCode() {
    return _countryCode;
  }


  public void setStateCode(String stateCode)
      throws WqxFatalException {
      
    _stateCode = setValue(stateCode);
  }


  public String getStateCode() {
    return _stateCode;
  }


  public void setCountyCode(String countyCode)
      throws WqxFatalException {
      
    _countyCode = setValue(countyCode);
  }


  public String getCountyCode() {
    return _countyCode;
  }
  
  // ---------------------------------------------------------------------
  // Methods
  // ---------------------------------------------------------------------
      
  public void addAlternateIdentifier(String monitoringLocationIdentifier, String monitoringLocationIdentifierContext)
      throws WqxFatalException {
      
    try {
      if (monitoringLocationIdentifier != null && monitoringLocationIdentifierContext != null) {
        _alternateMonitoringLocationIdentifiers.put(monitoringLocationIdentifier, monitoringLocationIdentifierContext);
        _dirty = true;
      }
      else {
        throw new Exception("Identifier and Context are required for an Alternate Monitoring Location Identifier");
      }
    }
    catch(Exception e) {
      _transactionLog.logError(e);
    }
  }
  
  // Save this object's values to the database
  public void save() 
      throws Exception {
    try {
      if (_dirty) {  
        try {
          _uid = _pkg.insertUpdateRow(
            _context, 
            _countryCode,
            _countyCode,
            _horizontalCollectionMethodName,
            _horizontalCoordinateReferenceSystemDatumName,
            _monitoringLocationDescriptionText,
            _hucTwelveDigitCode,
            _hucEightDigitCode,
            _monitoringLocationIdentifier,
            _latitudeMeasure,
            _longitudeMeasure,
            _monitoringLocationName,
            _sourceMapScaleNumeric,
            _tribalLandName,
            _tribalLandIndicator,
            _verticalMeasureValue,
            _monitoringLocationTypeName,
            _verticalMeasureUnitCode,
            _stateCode,
            _verticalCollectionMethodName,
            _verticalCoordinateReferenceSystemDatumName);     
        }
        catch (SQLException e) {
          _transactionLog.logError(e);
        }
        // iterate trough the Alt Monitoring Location collection to insert.
        if (_alternateMonitoringLocationIdentifiers.size() > 0) {
          Iterator iterator = _alternateMonitoringLocationIdentifiers.keySet().iterator();
          while (iterator.hasNext()) {
            String key = (String) iterator.next();
            String value = (String) _alternateMonitoringLocationIdentifiers.get(key);
            try {
              _pkg.altMlocInsertRow(
                _context,
                _uid,
                key,
                value);
            }
            catch (SQLException e) {
              _transactionLog.logError(e);        
            }
          }
        }
      } 
    }
    catch (Exception e) {
      _transactionLog.logError(e); 
    }
    finally {
      super.save();  
    }
  }
  
  
  // Delete previous loaded data
  public void deleteRows(String context, String mlocId)
      throws WqxFatalException {
      
    try {
      _pkg.deleteRowByMlocId(context, mlocId);;
    }
    catch (SQLException e) {
      _transactionLog.logError(e);    
    }
  }
  
  
  // Clear this object's values to reuse it for a new one.
  public void clear()
      throws WqxFatalException {
      
    try {
      _monitoringLocationIdentifier = null;
      _monitoringLocationName = null;
      _monitoringLocationTypeName = null;
      _monitoringLocationDescriptionText = null;
      _hucEightDigitCode = null;
      _hucTwelveDigitCode = null;
      _tribalLandIndicator = null;
      _tribalLandName = null;
      _alternateMonitoringLocationIdentifiers.clear();
      _latitudeMeasure = null;
      _longitudeMeasure = null;
      _sourceMapScaleNumeric = null;
      _horizontalCollectionMethodName = null;
      _horizontalCoordinateReferenceSystemDatumName = null;
      _verticalMeasureValue = null;
      _verticalMeasureUnitCode = null;
      _verticalCollectionMethodName = null;
      _verticalCoordinateReferenceSystemDatumName = null;
      _countryCode = null;
      _stateCode = null;
      _countyCode = null; 
    }
    catch (Exception e) {
      _transactionLog.logError(e);
    }
    finally {
      super.clear();
    }
  }
  
}