package gov.epa.wqx.node;

import java.sql.SQLException;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleTypes;

public class MonitoringLocationPkg {

  private OracleConnection _connection = null;
  private OracleCallableStatement _csAltMlocInsertRow;
  private OracleCallableStatement _csDeleteMlocAlt;
  private OracleCallableStatement _csDeleteRow;
  private OracleCallableStatement _csDeleteRowByMlocId;
  private OracleCallableStatement _csInsertUpdateRow;

  // constructor  
  public MonitoringLocationPkg (
      OracleConnection connection) 
      
      throws SQLException {
      
    // make sure we're connected
    if (connection == null)
      throw new SQLException("Connection is null");
    else if(connection.isClosed())
      throw new SQLException("Connection is closed");
    _connection = connection;

    // ALT MLOC INSERT ROW
    _csAltMlocInsertRow = (OracleCallableStatement) _connection.prepareCall(
      "{call monitoring_location_pkg.alt_mloc_insert_row(?, ?, ?, ?)}");
    _csAltMlocInsertRow.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csAltMlocInsertRow.defineParameterType(2, OracleTypes.NUMBER, 20); // p_mloc_uid
    _csAltMlocInsertRow.defineParameterType(3, OracleTypes.VARCHAR, 35); // p_mlalt_id
    _csAltMlocInsertRow.defineParameterType(4, OracleTypes.VARCHAR, 120); // p_mlalt_context

    // DELETE MLOC ALT
    _csDeleteMlocAlt = (OracleCallableStatement) _connection.prepareCall(
      "{call monitoring_location_pkg.delete_mloc_alt(?, ?)}");
    _csDeleteMlocAlt.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csDeleteMlocAlt.defineParameterType(2, OracleTypes.NUMBER, 20); // p_mloc_uid

    // DELETE ROW
    _csDeleteRow = (OracleCallableStatement) _connection.prepareCall(
      "{call monitoring_location_pkg.delete_row(?, ?, ?)}");
    _csDeleteRow.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csDeleteRow.defineParameterType(2, OracleTypes.NUMBER, 20); // p_mloc_uid
    _csDeleteRow.defineParameterType(3, OracleTypes.VARCHAR, 35); // p_mloc_id

    // DELETE ROW BY MLOC ID
    _csDeleteRowByMlocId = (OracleCallableStatement) _connection.prepareCall(
      "{call monitoring_location_pkg.delete_row_by_mloc_id(?, ?)}");
    _csDeleteRowByMlocId.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csDeleteRowByMlocId.defineParameterType(2, OracleTypes.VARCHAR, 35); // p_mloc_id

    // INSERT UPDATE ROW
    _csInsertUpdateRow = (OracleCallableStatement) _connection.prepareCall(
      "{call monitoring_location_pkg.insert_update_row(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}");
    _csInsertUpdateRow.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csInsertUpdateRow.defineParameterType(2, OracleTypes.VARCHAR, 2); // p_cntry_cd
    _csInsertUpdateRow.defineParameterType(3, OracleTypes.VARCHAR, 3); // p_cnty_fips_cd
    _csInsertUpdateRow.defineParameterType(4, OracleTypes.VARCHAR, 70); // p_hcmth_name
    _csInsertUpdateRow.defineParameterType(5, OracleTypes.VARCHAR, 6); // p_hrdat_name
    _csInsertUpdateRow.defineParameterType(6, OracleTypes.VARCHAR, 1999); // p_mloc_desc
    _csInsertUpdateRow.defineParameterType(7, OracleTypes.VARCHAR, 12); // p_mloc_huc_12
    _csInsertUpdateRow.defineParameterType(8, OracleTypes.VARCHAR, 8); // p_mloc_huc_8
    _csInsertUpdateRow.defineParameterType(9, OracleTypes.VARCHAR, 35); // p_mloc_id
    _csInsertUpdateRow.defineParameterType(10, OracleTypes.NUMBER, 0); // p_mloc_latitude
    _csInsertUpdateRow.defineParameterType(11, OracleTypes.NUMBER, 0); // p_mloc_longitude
    _csInsertUpdateRow.defineParameterType(12, OracleTypes.VARCHAR, 255); // p_mloc_name
    _csInsertUpdateRow.defineParameterType(13, OracleTypes.NUMBER, 8); // p_mloc_source_map_scale
    _csInsertUpdateRow.defineParameterType(14, OracleTypes.VARCHAR, 200); // p_mloc_tribal_land_name
    _csInsertUpdateRow.defineParameterType(15, OracleTypes.VARCHAR, 8); // p_mloc_tribal_land_yn
    _csInsertUpdateRow.defineParameterType(16, OracleTypes.VARCHAR, 12); // p_mloc_vertical_measure
    _csInsertUpdateRow.defineParameterType(17, OracleTypes.VARCHAR, 45); // p_mltyp_name
    _csInsertUpdateRow.defineParameterType(18, OracleTypes.VARCHAR, 12); // p_msunt_cd
    _csInsertUpdateRow.defineParameterType(19, OracleTypes.VARCHAR, 2); // p_st_cd
    _csInsertUpdateRow.defineParameterType(20, OracleTypes.VARCHAR, 50); // p_vcmth_name
    _csInsertUpdateRow.defineParameterType(21, OracleTypes.VARCHAR, 6); // p_vrdat_name
    _csInsertUpdateRow.registerOutParameter(22, OracleTypes.NUMBER, 20); // p_mloc_uid
  }


  public void altMlocInsertRow (  
      String context,
      String mlocUid,
      String mlaltId,
      String mlaltContext)

      throws SQLException {

    // set parameter values and call procedure
    _csAltMlocInsertRow.setString(1, context);
    _csAltMlocInsertRow.setString(2, mlocUid);
    _csAltMlocInsertRow.setString(3, mlaltId);
    _csAltMlocInsertRow.setString(4, mlaltContext);
    _csAltMlocInsertRow.execute();
  }


  public void deleteMlocAlt (  
      String context,
      String mlocUid)

      throws SQLException {

    // set parameter values and call procedure
    _csDeleteMlocAlt.setString(1, context);
    _csDeleteMlocAlt.setString(2, mlocUid);
    _csDeleteMlocAlt.execute();
  }


  public void deleteRow (  
      String context,
      String mlocUid,
      String mlocId)

      throws SQLException {

    // set parameter values and call procedure
    _csDeleteRow.setString(1, context);
    _csDeleteRow.setString(2, mlocUid);
    _csDeleteRow.setString(3, mlocId);
    _csDeleteRow.execute();
  }


  public void deleteRowByMlocId (  
      String context,
      String mlocId)

      throws SQLException {

    // set parameter values and call procedure
    _csDeleteRowByMlocId.setString(1, context);
    _csDeleteRowByMlocId.setString(2, mlocId);
    _csDeleteRowByMlocId.execute();
  }


  public String insertUpdateRow (  
      String context,
      String cntryCd,
      String cntyFipsCd,
      String hcmthName,
      String hrdatName,
      String mlocDesc,
      String mlocHuc12,
      String mlocHuc8,
      String mlocId,
      String mlocLatitude,
      String mlocLongitude,
      String mlocName,
      String mlocSourceMapScale,
      String mlocTribalLandName,
      String mlocTribalLandYn,
      String mlocVerticalMeasure,
      String mltypName,
      String msuntCd,
      String stCd,
      String vcmthName,
      String vrdatName)

      throws SQLException {

    // set parameter values and call procedure
    _csInsertUpdateRow.setString(1, context);
    _csInsertUpdateRow.setString(2, cntryCd);
    _csInsertUpdateRow.setString(3, cntyFipsCd);
    _csInsertUpdateRow.setString(4, hcmthName);
    _csInsertUpdateRow.setString(5, hrdatName);
    _csInsertUpdateRow.setString(6, mlocDesc);
    _csInsertUpdateRow.setString(7, mlocHuc12);
    _csInsertUpdateRow.setString(8, mlocHuc8);
    _csInsertUpdateRow.setString(9, mlocId);
    _csInsertUpdateRow.setString(10, mlocLatitude);
    _csInsertUpdateRow.setString(11, mlocLongitude);
    _csInsertUpdateRow.setString(12, mlocName);
    _csInsertUpdateRow.setString(13, mlocSourceMapScale);
    _csInsertUpdateRow.setString(14, mlocTribalLandName);
    _csInsertUpdateRow.setString(15, mlocTribalLandYn);
    _csInsertUpdateRow.setString(16, mlocVerticalMeasure);
    _csInsertUpdateRow.setString(17, mltypName);
    _csInsertUpdateRow.setString(18, msuntCd);
    _csInsertUpdateRow.setString(19, stCd);
    _csInsertUpdateRow.setString(20, vcmthName);
    _csInsertUpdateRow.setString(21, vrdatName);
    _csInsertUpdateRow.execute();
    // get out parameters and/or return value
    return _csInsertUpdateRow.getString(22);
  }

}