package gov.epa.wqx.node;

import java.sql.SQLException;

public class OrgAddress extends SchemaComponent { 
  // ---------------------------------------------------------------------
  // Private/Protected Variables
  // ---------------------------------------------------------------------
  private OrgAddressPkg _pkg;
  private String _addressTypeName;
  private String _addressText;
  private String _supplementalAddressText;
  private String _localityName;
  private String _stateCode;
  private String _postalCode;
  private String _countryCode;
  private String _countyCode;

  // ---------------------------------------------------------------------
  // Constructors
  // ---------------------------------------------------------------------
  public OrgAddress(SchemaComponent parent)
      throws WqxFatalException {
    super(parent);
    try {
      this.clear();
      _pkg = new OrgAddressPkg(_connection);
    }
    catch(Exception e) {
      _transactionLog.logError(e);
    }
  }

  // ---------------------------------------------------------------------
  // Get/Set Methods
  // ---------------------------------------------------------------------
  
  public void setAddressTypeName(String addressTypeName)
      throws WqxFatalException {
      
    _addressTypeName = setValue(addressTypeName);
  }
  

  public String getAddressTypeName() {
    return _addressTypeName;
  }


  public void setAddressText(String addressText)
      throws WqxFatalException {
      
    _addressText = setValue(addressText);
  }
  

  public String getAddressText() {
    return _addressText;
  }


  public void setSupplementalAddressText(String supplementalAddressText)
      throws WqxFatalException {
      
    _supplementalAddressText = setValue(supplementalAddressText);
  }
  

  public String getSupplementalAddressText() {
    return _supplementalAddressText;
  }


  public void setLocalityName(String localityName)
      throws WqxFatalException {
      
    _localityName = setValue(localityName);
  }
  

  public String getLocalityName() {
    return _localityName;
  }


  public void setStateCode(String stateCode)
      throws WqxFatalException {
      
    _stateCode = setValue(stateCode);
  }
  

  public String getStateCode() {
    return _stateCode;
  }


  public void setPostalCode(String postalCode)
      throws WqxFatalException {
      
    _postalCode = setValue(postalCode);
  }
  

  public String getPostalCode() {
    return _postalCode;
  }


  public void setCountryCode(String countryCode)
      throws WqxFatalException {
      
    _countryCode = setValue(countryCode);
  }
  

  public String getCountryCode() {
    return _countryCode;
  }


  public void setCountyCode(String countyCode)
      throws WqxFatalException {
      
    _countyCode = setValue(countyCode);
  }
  

  public String getCountyCode() {
    return _countyCode;
  }

  
  // ---------------------------------------------------------------------
  // Methods
  // ---------------------------------------------------------------------
  // Save this object's values to the database
   public void save()
      throws Exception {
    if (_dirty) {  
      try {
        _uid = _pkg.insertRow(
          _context,
          _addressTypeName,
          _countryCode,
          _countyCode,
          _addressText,
          _supplementalAddressText,
          _localityName,
          _postalCode,
          _stateCode);
      }
      catch(SQLException e) {
        _transactionLog.logError(e);             
      }
    }
    super.save();
  }
   
  // Delete all rows for a specific organization
  public void deleteRowsByOrgUid(String context, String orgUid)
      throws WqxFatalException {
      
    try {
      _pkg.deleteRowsByOrgUid(context, orgUid);
    }
    catch (SQLException e) {
      _transactionLog.logError(e);
    }
  }
  
  
  // Clear this object's values to reuse it for a new one.
  public void clear()
      throws WqxFatalException {
      
    _addressTypeName = null;
    _addressText = null;
    _supplementalAddressText = null;
    _localityName = null;
    _stateCode = null;
    _postalCode = null;
    _countryCode = null;
    _countyCode = null;
    super.clear();
  }

}