package gov.epa.wqx.node;

import java.sql.SQLException;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleTypes;

public class OrgAddressPkg {

  private OracleConnection _connection = null;
  private OracleCallableStatement _csDeleteRow;
  private OracleCallableStatement _csDeleteRowsByOrgUid;
  private OracleCallableStatement _csInsertRow;

  // constructor  
  public OrgAddressPkg (
      OracleConnection connection) 
      
      throws SQLException {
      
    // make sure we're connected
    if (connection == null)
      throw new SQLException("Connection is null");
    else if(connection.isClosed())
      throw new SQLException("Connection is closed");
    _connection = connection;

    // DELETE ROW
    _csDeleteRow = (OracleCallableStatement) _connection.prepareCall(
      "{call org_address_pkg.delete_row(?, ?)}");
    _csDeleteRow.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csDeleteRow.defineParameterType(2, OracleTypes.NUMBER, 20); // p_orgadd_uid

    // DELETE ROWS BY ORG UID
    _csDeleteRowsByOrgUid = (OracleCallableStatement) _connection.prepareCall(
      "{call org_address_pkg.delete_rows_by_org_uid(?, ?)}");
    _csDeleteRowsByOrgUid.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csDeleteRowsByOrgUid.defineParameterType(2, OracleTypes.NUMBER, 20); // p_org_uid

    // INSERT ROW
    _csInsertRow = (OracleCallableStatement) _connection.prepareCall(
      "{call org_address_pkg.insert_row(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}");
    _csInsertRow.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csInsertRow.defineParameterType(2, OracleTypes.VARCHAR, 8); // p_addtyp_name
    _csInsertRow.defineParameterType(3, OracleTypes.VARCHAR, 2); // p_cntry_cd
    _csInsertRow.defineParameterType(4, OracleTypes.VARCHAR, 3); // p_cnty_fips_cd
    _csInsertRow.defineParameterType(5, OracleTypes.VARCHAR, 50); // p_orgadd_address
    _csInsertRow.defineParameterType(6, OracleTypes.VARCHAR, 120); // p_orgadd_address_supplemental
    _csInsertRow.defineParameterType(7, OracleTypes.VARCHAR, 30); // p_orgadd_locality_name
    _csInsertRow.defineParameterType(8, OracleTypes.VARCHAR, 10); // p_orgadd_postal_cd
    _csInsertRow.defineParameterType(9, OracleTypes.VARCHAR, 2); // p_st_cd
    _csInsertRow.registerOutParameter(10, OracleTypes.NUMBER, 20); // p_orgadd_uid
  }


  public void deleteRow (  
      String context,
      String orgaddUid)

      throws SQLException {

    // set parameter values and call procedure
    _csDeleteRow.setString(1, context);
    _csDeleteRow.setString(2, orgaddUid);
    _csDeleteRow.execute();
  }


  public void deleteRowsByOrgUid (  
      String context,
      String orgUid)

      throws SQLException {

    // set parameter values and call procedure
    _csDeleteRowsByOrgUid.setString(1, context);
    _csDeleteRowsByOrgUid.setString(2, orgUid);
    _csDeleteRowsByOrgUid.execute();
  }


  public String insertRow (  
      String context,
      String addtypName,
      String cntryCd,
      String cntyFipsCd,
      String orgaddAddress,
      String orgaddAddressSupplemental,
      String orgaddLocalityName,
      String orgaddPostalCd,
      String stCd)

      throws SQLException {

    // set parameter values and call procedure
    _csInsertRow.setString(1, context);
    _csInsertRow.setString(2, addtypName);
    _csInsertRow.setString(3, cntryCd);
    _csInsertRow.setString(4, cntyFipsCd);
    _csInsertRow.setString(5, orgaddAddress);
    _csInsertRow.setString(6, orgaddAddressSupplemental);
    _csInsertRow.setString(7, orgaddLocalityName);
    _csInsertRow.setString(8, orgaddPostalCd);
    _csInsertRow.setString(9, stCd);
    _csInsertRow.execute();
    // get out parameters and/or return value
    return _csInsertRow.getString(10);
  }

}