package gov.epa.wqx.node;

import java.sql.SQLException;

public class OrgElectronicAddress extends SchemaComponent  {
  
  // ---------------------------------------------------------------------
  // Private/Protected Variables
  // ---------------------------------------------------------------------
  private OrgElectronicAddressPkg _pkg;
  private String _electronicAddressText;
  private String _electronicAddressTypeName;

  // ---------------------------------------------------------------------
  // Constructors
  // ---------------------------------------------------------------------
  public OrgElectronicAddress(SchemaComponent parent)
      throws WqxFatalException {
      
    super(parent);
    try {
      this.clear();
      _pkg = new OrgElectronicAddressPkg(_connection);
    }
    catch(Exception e) {
      _transactionLog.logError(e);
    }
  }

  // ---------------------------------------------------------------------
  // Get/Set Methods
  // ---------------------------------------------------------------------
  public void setElectronicAddressText(String electronicAddressText)
      throws WqxFatalException {
      
    _electronicAddressText = setValue(electronicAddressText);
  }


  public String getElectronicAddressText() {
    return _electronicAddressText;
  }


  public void setElectronicAddressTypeName(String electronicAddressTypeName)
      throws WqxFatalException {
      
    _electronicAddressTypeName = setValue(electronicAddressTypeName);
  }


  public String getElectronicAddressTypeName() {
    return _electronicAddressTypeName;
  }
  
  // ---------------------------------------------------------------------
  // Methods
  // ---------------------------------------------------------------------
  
  // Save this object's values to the database
  public void save() 
      throws Exception {
    try {
      if (_dirty) {  
        try {
          _uid = _pkg.insertRow(
            _context,
            _electronicAddressTypeName,
            _electronicAddressText);
        }
        catch(SQLException e) {
          _transactionLog.logError(e); 
        }
      }
    }
    finally {
      super.save();
    }
  }
  
   
  // Delete all rows for a specific organization
  public void deleteRowsByOrgUid(String context, String orgUid)
      throws WqxFatalException {
      
    try {
      _pkg.deleteRowsByOrgUid(context, orgUid);
    }
    catch (SQLException e) {
      _transactionLog.logError(e);    
    }
  }
  
  
  // Clear this object's values to reuse it for a new one.
  public void clear()  
      throws WqxFatalException {
      
    _electronicAddressText = null;
    _electronicAddressTypeName = null;
    super.clear();
  }
  
}