package gov.epa.wqx.node;

import java.sql.SQLException;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleTypes;

public class OrgElectronicAddressPkg {

  private OracleConnection _connection = null;
  private OracleCallableStatement _csDeleteRow;
  private OracleCallableStatement _csDeleteRowsByOrgUid;
  private OracleCallableStatement _csInsertRow;

  // constructor  
  public OrgElectronicAddressPkg (
      OracleConnection connection) 
      
      throws SQLException {
      
    // make sure we're connected
    if (connection == null)
      throw new SQLException("Connection is null");
    else if(connection.isClosed())
      throw new SQLException("Connection is closed");
    _connection = connection;

    // DELETE ROW
    _csDeleteRow = (OracleCallableStatement) _connection.prepareCall(
      "{call org_electronic_address_pkg.delete_row(?, ?)}");
    _csDeleteRow.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csDeleteRow.defineParameterType(2, OracleTypes.NUMBER, 20); // p_orgea_uid

    // DELETE ROWS BY ORG UID
    _csDeleteRowsByOrgUid = (OracleCallableStatement) _connection.prepareCall(
      "{call org_electronic_address_pkg.delete_rows_by_org_uid(?, ?)}");
    _csDeleteRowsByOrgUid.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csDeleteRowsByOrgUid.defineParameterType(2, OracleTypes.NUMBER, 20); // p_org_uid

    // INSERT ROW
    _csInsertRow = (OracleCallableStatement) _connection.prepareCall(
      "{call org_electronic_address_pkg.insert_row(?, ?, ?, ?)}");
    _csInsertRow.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csInsertRow.defineParameterType(2, OracleTypes.VARCHAR, 20); // p_eatyp_name
    _csInsertRow.defineParameterType(3, OracleTypes.VARCHAR, 120); // p_orgea_text
    _csInsertRow.registerOutParameter(4, OracleTypes.NUMBER, 20); // p_orgea_uid
  }


  public void deleteRow (  
      String context,
      String orgeaUid)

      throws SQLException {

    // set parameter values and call procedure
    _csDeleteRow.setString(1, context);
    _csDeleteRow.setString(2, orgeaUid);
    _csDeleteRow.execute();
  }


  public void deleteRowsByOrgUid (  
      String context,
      String orgUid)

      throws SQLException {

    // set parameter values and call procedure
    _csDeleteRowsByOrgUid.setString(1, context);
    _csDeleteRowsByOrgUid.setString(2, orgUid);
    _csDeleteRowsByOrgUid.execute();
  }


  public String insertRow (  
      String context,
      String eatypName,
      String orgeaText)

      throws SQLException {

    // set parameter values and call procedure
    _csInsertRow.setString(1, context);
    _csInsertRow.setString(2, eatypName);
    _csInsertRow.setString(3, orgeaText);
    _csInsertRow.execute();
    // get out parameters and/or return value
    return _csInsertRow.getString(4);
  }

}