package gov.epa.wqx.node;

import java.sql.SQLException;

public class OrgPhone extends SchemaComponent {
  
  // ---------------------------------------------------------------------
  // Private/Protected Variables
  // ---------------------------------------------------------------------
  private OrgPhonePkg _pkg;
  private String _telephoneNumberText;
  private String _telephoneNumberTypeName;
  private String _telephoneExtensionNumberText;

  // ---------------------------------------------------------------------
  // Constructors
  // ---------------------------------------------------------------------
  public OrgPhone(SchemaComponent parent)
      throws WqxFatalException {
      
    super(parent);
    try {
      this.clear();
      _pkg = new OrgPhonePkg(_connection);
    }
    catch(Exception e) {
      _transactionLog.logError(e);
    }
  }

  // ---------------------------------------------------------------------
  // Get/Set Methods
  // ---------------------------------------------------------------------
   
   public void setTelephoneNumberText(String telephoneNumberText)
      throws WqxFatalException {
      
     _telephoneNumberText = setValue(telephoneNumberText);
  }
  

  public String getTelephoneNumberText() {
    return _telephoneNumberText;
  }


  public void setTelephoneNumberTypeName(String telephoneNumberTypeName)
      throws WqxFatalException {
      
     _telephoneNumberTypeName = setValue(telephoneNumberTypeName);
  }
  

  public String getTelephoneNumberTypeName() {
    return _telephoneNumberTypeName;
  }


  public void setTelephoneExtensionNumberText(String telephoneExtensionNumberText)
      throws WqxFatalException {
      
     _telephoneExtensionNumberText = setValue(telephoneExtensionNumberText);
  }
  

  public String getTelephoneExtensionNumberText() {
    return _telephoneExtensionNumberText;
  }
 
  // ---------------------------------------------------------------------
  // Methods
  // ---------------------------------------------------------------------
  
  // Save this object's values to the database
  public void save() 
      throws Exception {
    if (_dirty) {  
      try {
        _uid = _pkg.insertRow(
          _context,
          _telephoneExtensionNumberText,
          _telephoneNumberText,
          _telephoneNumberTypeName);
      }
      catch(SQLException e) {
        _transactionLog.logError(e);
      }
    }
    super.save();
  }
   
  
  // Delete all rows for a specific organization
  public void deleteRowsByOrgUid(String context, String orgUid)
      throws WqxFatalException {
      
    try {
      _pkg.deleteRowsByOrgUid(context, orgUid);
    }
    catch (SQLException e) {
      _transactionLog.logError(e);    
    }
  }
  
  
  // Clear this object's values to reuse it for a new one.
  public void clear()
      throws WqxFatalException {
      
    _telephoneExtensionNumberText = null;
    _telephoneNumberText = null;
    _telephoneNumberTypeName = null;
    super.clear();
  }
  
}