package gov.epa.wqx.node;

import java.sql.SQLException;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleTypes;

public class OrgPhonePkg {

  private OracleConnection _connection = null;
  private OracleCallableStatement _csDeleteRow;
  private OracleCallableStatement _csDeleteRowsByOrgUid;
  private OracleCallableStatement _csInsertRow;

  // constructor  
  public OrgPhonePkg (
      OracleConnection connection) 
      
      throws SQLException {
      
    // make sure we're connected
    if (connection == null)
      throw new SQLException("Connection is null");
    else if(connection.isClosed())
      throw new SQLException("Connection is closed");
    _connection = connection;

    // DELETE ROW
    _csDeleteRow = (OracleCallableStatement) _connection.prepareCall(
      "{call org_phone_pkg.delete_row(?, ?)}");
    _csDeleteRow.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csDeleteRow.defineParameterType(2, OracleTypes.NUMBER, 20); // p_orgph_uid

    // DELETE ROWS BY ORG UID
    _csDeleteRowsByOrgUid = (OracleCallableStatement) _connection.prepareCall(
      "{call org_phone_pkg.delete_rows_by_org_uid(?, ?)}");
    _csDeleteRowsByOrgUid.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csDeleteRowsByOrgUid.defineParameterType(2, OracleTypes.NUMBER, 20); // p_org_uid

    // INSERT ROW
    _csInsertRow = (OracleCallableStatement) _connection.prepareCall(
      "{call org_phone_pkg.insert_row(?, ?, ?, ?, ?)}");
    _csInsertRow.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csInsertRow.defineParameterType(2, OracleTypes.VARCHAR, 6); // p_orgph_ext
    _csInsertRow.defineParameterType(3, OracleTypes.VARCHAR, 15); // p_orgph_num
    _csInsertRow.defineParameterType(4, OracleTypes.VARCHAR, 6); // p_phtyp_name
    _csInsertRow.registerOutParameter(5, OracleTypes.NUMBER, 20); // p_orgph_uid
  }


  public void deleteRow (  
      String context,
      String orgphUid)

      throws SQLException {

    // set parameter values and call procedure
    _csDeleteRow.setString(1, context);
    _csDeleteRow.setString(2, orgphUid);
    _csDeleteRow.execute();
  }


  public void deleteRowsByOrgUid (  
      String context,
      String orgUid)

      throws SQLException {

    // set parameter values and call procedure
    _csDeleteRowsByOrgUid.setString(1, context);
    _csDeleteRowsByOrgUid.setString(2, orgUid);
    _csDeleteRowsByOrgUid.execute();
  }


  public String insertRow (  
      String context,
      String orgphExt,
      String orgphNum,
      String phtypName)

      throws SQLException {

    // set parameter values and call procedure
    _csInsertRow.setString(1, context);
    _csInsertRow.setString(2, orgphExt);
    _csInsertRow.setString(3, orgphNum);
    _csInsertRow.setString(4, phtypName);
    _csInsertRow.execute();
    // get out parameters and/or return value
    return _csInsertRow.getString(5);
  }

}