package gov.epa.wqx.node;

import java.sql.SQLException;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleTypes;

public class OrganizationPkg {

  private OracleConnection _connection = null;
  private OracleCallableStatement _csGetOrgId;
  private OracleCallableStatement _csGetOrgUid;
  private OracleCallableStatement _csUpdateRow;

  // constructor  
  public OrganizationPkg (
      OracleConnection connection) 
      
      throws SQLException {
      
    // make sure we're connected
    if (connection == null)
      throw new SQLException("Connection is null");
    else if(connection.isClosed())
      throw new SQLException("Connection is closed");
    _connection = connection;

    // GET ORG ID
    _csGetOrgId = (OracleCallableStatement) _connection.prepareCall(
      "{? = call organization_pkg.get_org_id()}");
    _csGetOrgId.registerOutParameter(1, OracleTypes.VARCHAR, 30); // return value

    // GET ORG UID
    _csGetOrgUid = (OracleCallableStatement) _connection.prepareCall(
      "{? = call organization_pkg.get_org_uid(?)}");
    _csGetOrgUid.registerOutParameter(1, OracleTypes.NUMBER, 20); // return value
    _csGetOrgUid.defineParameterType(2, OracleTypes.VARCHAR, 30); // p_org_id

    // UPDATE ROW
    _csUpdateRow = (OracleCallableStatement) _connection.prepareCall(
      "{call organization_pkg.update_row(?, ?, ?, ?, ?, ?)}");
    _csUpdateRow.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csUpdateRow.defineParameterType(2, OracleTypes.VARCHAR, 30); // p_org_id
    _csUpdateRow.defineParameterType(3, OracleTypes.VARCHAR, 120); // p_org_name
    _csUpdateRow.defineParameterType(4, OracleTypes.VARCHAR, 500); // p_org_desc
    _csUpdateRow.defineParameterType(5, OracleTypes.VARCHAR, 3); // p_trb_cd
    _csUpdateRow.registerOutParameter(6, OracleTypes.NUMBER, 20); // p_org_uid
  }


  public String getOrgId (  )

      throws SQLException {

    // set parameter values and call procedure
    _csGetOrgId.execute();
    // get out parameters and/or return value
    return _csGetOrgId.getString(1);
  }

  public String getOrgUid (  
      String orgId)

      throws SQLException {

    // set parameter values and call procedure
    _csGetOrgUid.setString(2, orgId);
    _csGetOrgUid.execute();
    // get out parameters and/or return value
    return _csGetOrgUid.getString(1);
  }

  public String updateRow (  
      String context,
      String orgId,
      String orgName,
      String orgDesc,
      String trbCd)

      throws SQLException {

    // set parameter values and call procedure
    _csUpdateRow.setString(1, context);
    _csUpdateRow.setString(2, orgId);
    _csUpdateRow.setString(3, orgName);
    _csUpdateRow.setString(4, orgDesc);
    _csUpdateRow.setString(5, trbCd);
    _csUpdateRow.execute();
    // get out parameters and/or return value
    return _csUpdateRow.getString(6);
  }

}