package gov.epa.wqx.node;

import java.sql.SQLException;

public class Project extends SchemaComponent {

  // ---------------------------------------------------------------------
  // Private/Protected Variables
  // ---------------------------------------------------------------------
  private ProjectPkg  _pkg;
  private String _projectIdentifier;
	private String _projectName;
	private String _projectDescriptionText;
  
  // ---------------------------------------------------------------------
  // Constructors
  // ---------------------------------------------------------------------

  public Project(SchemaComponent parent)
      throws WqxFatalException {
      
    super(parent);
    try {
      _transactionalBoundary = true;
      this.clear();	
      _pkg = new ProjectPkg(_connection);
    }        
    catch (Exception e) {
      _transactionLog.logError(e);
    }
  }


  // ---------------------------------------------------------------------
  // Get/Set Methods
  // ---------------------------------------------------------------------

  public void setProjectIdentifier(String projectIdentifier)
      throws WqxFatalException {
      
    _projectIdentifier = setValue(projectIdentifier);
  }

  public String getProjectIdentifier() {
    return _projectIdentifier;
  }

  public void setProjectName(String projectName)
      throws WqxFatalException {
      
    _projectName = setValue(projectName);
  }

  public String getProjectName() {
    return _projectName;
  }

  public void setProjectDescriptionText(String projectDescriptionText)
      throws WqxFatalException {
      
    _projectDescriptionText = setValue(projectDescriptionText);
  }

  public String getProjectDescriptionText() {
    return _projectDescriptionText;
  }
  
  // ---------------------------------------------------------------------
  // Methods
  // ---------------------------------------------------------------------
  
  // Save this object's values to the database
  public void save()
      throws Exception  {

    try {
      if (_dirty) {  
        // Check business rules on description text or Binary file name
        if (_projectDescriptionText == null) {
          AttachedObject binaryFile = (AttachedObject) _attachedObjects.get(0);
          String fileName = binaryFile.getBinaryObjectFileName();
          if (fileName == null) {
            throw new Exception(""); //Either project Description Text or binary object file name need to be included
          }
        }
        try {
          _uid = _pkg.insertUpdateRow(
            _context, 
            _projectDescriptionText, 
            _projectIdentifier,
            _projectName);
        }
        catch (SQLException e) {
          _transactionLog.logError(e);
        }
      }
    }
    finally {
      super.save();
    }
  }
  
  
  // Clear this object's values to reuse it for a new one.
  public void clear()
      throws WqxFatalException {
      
    try {
      _projectIdentifier = null;
      _projectName = null;
      _projectDescriptionText = null;
    }
    catch (Exception e) {
      _transactionLog.logError(e);
    }
    finally {
      super.clear();
    }
  }  
  
}