package gov.epa.wqx.node;

import java.sql.SQLException;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleTypes;

public class ProjectPkg {

  private OracleConnection _connection = null;
  private OracleCallableStatement _csDeleteRow;
  private OracleCallableStatement _csDeleteRowByPrjId;
  private OracleCallableStatement _csInsertUpdateRow;

  // constructor  
  public ProjectPkg (
      OracleConnection connection) 
      
      throws SQLException {
      
    // make sure we're connected
    if (connection == null)
      throw new SQLException("Connection is null");
    else if(connection.isClosed())
      throw new SQLException("Connection is closed");
    _connection = connection;

    // DELETE ROW
    _csDeleteRow = (OracleCallableStatement) _connection.prepareCall(
      "{call project_pkg.delete_row(?, ?, ?)}");
    _csDeleteRow.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csDeleteRow.defineParameterType(2, OracleTypes.NUMBER, 20); // p_prj_uid
    _csDeleteRow.defineParameterType(3, OracleTypes.VARCHAR, 35); // p_prj_id

    // DELETE ROW BY PRJ ID
    _csDeleteRowByPrjId = (OracleCallableStatement) _connection.prepareCall(
      "{call project_pkg.delete_row_by_prj_id(?, ?)}");
    _csDeleteRowByPrjId.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csDeleteRowByPrjId.defineParameterType(2, OracleTypes.VARCHAR, 35); // p_prj_id

    // INSERT UPDATE ROW
    _csInsertUpdateRow = (OracleCallableStatement) _connection.prepareCall(
      "{call project_pkg.insert_update_row(?, ?, ?, ?, ?)}");
    _csInsertUpdateRow.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csInsertUpdateRow.defineParameterType(2, OracleTypes.VARCHAR, 1999); // p_prj_desc
    _csInsertUpdateRow.defineParameterType(3, OracleTypes.VARCHAR, 35); // p_prj_id
    _csInsertUpdateRow.defineParameterType(4, OracleTypes.VARCHAR, 120); // p_prj_name
    _csInsertUpdateRow.registerOutParameter(5, OracleTypes.NUMBER, 20); // p_prj_uid
  }


  public void deleteRow (  
      String context,
      String prjUid,
      String prjId)

      throws SQLException {

    // set parameter values and call procedure
    _csDeleteRow.setString(1, context);
    _csDeleteRow.setString(2, prjUid);
    _csDeleteRow.setString(3, prjId);
    _csDeleteRow.execute();
  }


  public void deleteRowByPrjId (  
      String context,
      String prjId)

      throws SQLException {

    // set parameter values and call procedure
    _csDeleteRowByPrjId.setString(1, context);
    _csDeleteRowByPrjId.setString(2, prjId);
    _csDeleteRowByPrjId.execute();
  }


  public String insertUpdateRow (  
      String context,
      String prjDesc,
      String prjId,
      String prjName)

      throws SQLException {

    // set parameter values and call procedure
    _csInsertUpdateRow.setString(1, context);
    _csInsertUpdateRow.setString(2, prjDesc);
    _csInsertUpdateRow.setString(3, prjId);
    _csInsertUpdateRow.setString(4, prjName);
    _csInsertUpdateRow.execute();
    // get out parameters and/or return value
    return _csInsertUpdateRow.getString(5);
  }

}