package gov.epa.wqx.node;

import gov.epa.wqx.node.Lib;

import java.sql.Date;
import java.sql.SQLException;

import java.sql.Timestamp;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleTypes;


public class Query {

  private OracleConnection  _connection;
  private XmlQueryPkg       _pkg;
  private String            _trtypUid;
  
  public Query(OracleConnection connection, int trtypUid) throws SQLException {
    _connection = connection;
    _trtypUid = String.valueOf(trtypUid);
    _pkg = new XmlQueryPkg(_connection);
  }
  
  /**
   * Method:      getDomainValues
   * Parameters:  String elementName, String usrNaasIdFromCdx
   * 
   * Description: This method takes parameters elementName and usrNaasIdFromCdx from
   *              the user and calls the Oracle function WQX.GET_DOMAIN_VALUES().
   *              The Function returns a CLOB which is then returned by this 
   *              method as a byte[].
   * *************************************************************************/
  public byte[] getDomainValues(String elementName, String usrNaasIdFromCdx) 
      throws SQLException {
      
    return _pkg.getDomainValues(_trtypUid, elementName, usrNaasIdFromCdx).getBytes();
  }
  
  
  /**
   * Method:      getTransactionHistory
   * Parameters:  String orgID, String usrNaasIdFromCdx, String trlogStartTime, 
   *              String trlogEndTime
   * 
   * Description: This method takes the above listed parameters from the user 
   *              and calls the Oracle function WQX.GET_TRANSACTION_HISTORY().
   *              The Function returns a CLOB which is then returned by this 
   *              method as a byte[].
   * ************************************************************************/
  public byte[] getTransactionHistory(
      String orgID,
      String usrNaasId, 
      String trlogTransId,
      String trlogStartTimeBegin, 
      String trlogStartTimeEnd,
      String usrNaasIdFromCdx) 
      
      throws Exception {
      
    Date startTimeBegin = null;
    Date startTimeEnd = null;
    
    if (trlogStartTimeBegin == null) {
      startTimeBegin = null;
    }
    else {
      if (trlogStartTimeBegin.indexOf("T") > 0) {
        startTimeBegin = new Date(Lib.xmlToTimestamp(trlogStartTimeBegin).getTime());
      }
      else {
        startTimeBegin = Lib.xmlToDate(trlogStartTimeBegin);
      }
    }
    if (trlogStartTimeEnd == null) {
      startTimeEnd = null;
    }
    else{
      if (trlogStartTimeEnd.indexOf("T") > 0) {
        startTimeEnd = new Date(Lib.xmlToTimestamp(trlogStartTimeEnd).getTime());
      }
      else {
        startTimeEnd = Lib.xmlToDate(trlogStartTimeEnd);
      }
    }
    return _pkg.getTransactionHistory(
      _trtypUid, 
      orgID, 
      usrNaasId, 
      trlogTransId, 
      startTimeBegin, 
      startTimeEnd, 
      usrNaasIdFromCdx).getBytes();
  }
  
  
  /**
   * Method:      getProject
   * Parameters:  String orgID, String prjID, String usrNaasIdFromCdx
   * 
   * Description: This method takes the above listed parameters from the user 
   *              and calls the Oracle function WQX.GET_PROJECT().
   *              The Function returns a CLOB which is then returned by this 
   *              method as a byte[].
   * ************************************************************************/
  public byte[] getProject(String orgID, String prjID, String usrNaasIdFromCdx) 
      throws SQLException {    
    
    return _pkg.getProject(
      _trtypUid, 
      orgID, 
      prjID, 
      usrNaasIdFromCdx).getBytes(); 
  }
  
  
  /**
   * Method:      getMonitoringLocation
   * Parameters:  String orgID, String mlocID, String usrNaasIdFromCdx
   * 
   * Description: This method takes the above listed parameters from the user 
   *              and calls the Oracle function WQX.GET_MONITORING_LOCATION().
   *              The Function returns a CLOB which is then returned by this 
   *              method as a byte[].
   * ************************************************************************/
  public byte[] getMonitoringLocation(String orgID, String mlocID, String usrNaasIdFromCdx) 
      throws SQLException {    
    
    return _pkg.getMonitoringLocation(
      _trtypUid, 
      orgID, 
      mlocID, 
      usrNaasIdFromCdx).getBytes();
  }
  
  
  /**
   * Method:      getActivity
   * Parameters:  String orgID, String mlocID, String prjID, String actID,
   *              String actStartDate, String actEndDate, String usrNaasIdFromCdx
   * 
   * Description: This method takes the above listed parameters from the user 
   *              and calls the Oracle function WQX.GET_ACTIVITY().
   *              The Function returns a CLOB which is then returned by this 
   *              method as a byte[].
   * ************************************************************************/
  public byte[] getActivity(
      String orgID, 
      String mlocID, 
      String prjID, 
      String actStartDateBegin, 
      String actStartDateEnd, 
      String actID, 
      String usrNaasIdFromCdx)
      
      throws Exception {
      
    Date startDateBegin = null;
    Date startDateEnd = null;
    
    if (actStartDateBegin == null) {
      startDateBegin = null;
    }
    else {
      if (actStartDateBegin.indexOf("T") > 0) {
        Timestamp startDateTS = Lib.xmlToTimestamp(actStartDateBegin);
         startDateBegin = new Date(startDateTS.getTime());
      }
      else {
        startDateBegin = Lib.xmlToDate(actStartDateBegin);
      }
    }
    if (actStartDateEnd == null) {
      startDateEnd = null;
    }
    else{
      if (actStartDateEnd.indexOf("T") > 0) {
        Timestamp endDateTS = Lib.xmlToTimestamp(actStartDateEnd);
        startDateEnd = new Date(endDateTS.getTime());
      }
      else {
        startDateEnd = Lib.xmlToDate(actStartDateEnd);
      }
    }  
    return _pkg.getActivity(
      _trtypUid, 
      orgID, 
      mlocID, 
      prjID, 
      actID,
      startDateBegin, 
      startDateEnd, 
      usrNaasIdFromCdx).getBytes();  
  } 
 
  
  /**
   * Method:      getResult
   * Parameters:  String orgID, String mlocID, String prjID, String actID,
   *              String actStartDate, String actEndDate, String usrNaasIdFromCdx
   * 
   * Description: This method takes the above listed parameters from the user 
   *              and calls the Oracle function WQX.GET_RESULT().
   *              The Function returns a CLOB which is then returned by this 
   *              method as a byte[].
   * ************************************************************************/
  public byte[] getResult(
      String orgID, 
      String mlocID, 
      String prjID,
      String actStartDateBegin, 
      String actStartDateEnd,
      String actID,
      String usrNaasIdFromCdx) 
      
      throws Exception {
      
    Date startDateBegin = null;
    Date startDateEnd = null;
    
    if (actStartDateBegin == null) {
      startDateBegin = null;
    }
    else {
      if (actStartDateBegin.indexOf("T") > 0) {
        Timestamp startDateTS = Lib.xmlToTimestamp(actStartDateBegin);
         startDateBegin = new Date(startDateTS.getTime());
      }
      else {
        startDateBegin = Lib.xmlToDate(actStartDateBegin);
      }
    }
    if (actStartDateEnd == null) {
      startDateEnd = null;
    }
    else{
      if (actStartDateEnd.indexOf("T") > 0) {
        Timestamp endDateTS = Lib.xmlToTimestamp(actStartDateEnd);
        startDateEnd = new Date(endDateTS.getTime());
      }
      else {
        startDateEnd = Lib.xmlToDate(actStartDateEnd);
      }
    } 
    return _pkg.getResult(
      _trtypUid, 
      orgID, 
      mlocID, 
      prjID, 
      actID, 
      startDateBegin, 
      startDateEnd, 
      usrNaasIdFromCdx).getBytes();
  }
    
    
  /**
   * Method:      getActivityGroup
   * Parameters:  String orgID, String actGrpTypCD, String actGrpID, String usrNaasIdFromCdx
   * 
   * Description: This method takes the above listed parameters from the user 
   *              and calls the Oracle function WQX.GET_ACTIVITY_GROUP().
   *              The Function returns a CLOB which is then returned by this 
   *              method as a byte[].
   * ************************************************************************/
  public byte[] getActivityGroup(
      String orgID, 
      String actGrpTypCD,
      String actGrpID, 
      String usrNaasIdFromCdx) 
      
      throws SQLException {
      
    return _pkg.getActivityGroup(
      _trtypUid, 
      orgID, 
      actGrpTypCD, 
      actGrpID, 
      usrNaasIdFromCdx).getBytes();
  } 
  
}