package gov.epa.wqx.node;

import gov.epa.wqx.node.LookupTblPkg;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Result extends SchemaComponent {
 // ---------------------------------------------------------------------
  // Private/Protected Variables
  // ---------------------------------------------------------------------
  private ResultPkg     _pkg;
  private LookupTblPkg  _pkgLookup;
  
  private String _dataLoggerLineName;
  private String _resultDetectionConditionText;
  private String _characteristicName;
  private String _resultSampleFractionText;
  private String _resultMeasureValue;
  private String _resultMeasureUnitCode;
  private String _resultMeasureQualifierCode;
  private String _resultStatusIdentifier;
  private String _statisticalBaseCode;
  private String _resultValueTypeName;
  private String _resultWeightBasisText;
  private String _resultTimeBasisText;
  private String _resultTemperatureBasisText;
  private String _resultParticleSizeBasisText;
  private String _precisionValue;
  private String _biasValue;
  private String _confidenceIntervalValue;
  private String _upperConfidenceLimitValue;
  private String _lowerConfidenceLimitValue;
  private String _resultCommentText;
  private String _resultDepthHeightMeasureValue;
  private String _resultDepthHeightMeasureUnitCode;
  private String _resultDepthAltitudeReferencePointText;
  private String _resultAnalyticalMethodIdentifier;
  private String _resultAnalyticalMethodIdentifierContext;
  private String _resultAnalyticalMethodName;
  private String _resultAnalyticalMethodQualifierTypeName;
  private String _resultAnalyticalMethodDescriptionText;
  private String _laboratoryName;
  private String _analysisStartDateString;
  private Date _analysisStartDate;
  private String _analysisStartTimeString;
  private Time _analysisStartTime;
  private String _analysisStartTimeZoneCode;
  private String _analysisEndDateString;
  private Date _analysisEndDate;
  private String _analysisEndTimeString;
  private Time _analysisEndTime;
  private String _analysisEndTimeZoneCode;
  private String _resultLaboratoryCommentCode;
  
  private String _analyticalMethodUid;
  private Map    _analyticalMethodUids;
  
  private boolean _detectionQuantitationLimitTypeNameReported;
  private boolean _detectionQuantitationLimitMeasureValueReported;
  
  // ---------------------------------------------------------------------
  // Constructors
  // ---------------------------------------------------------------------
  
  public Result(SchemaComponent parent)
      throws WqxFatalException {
      
    super(parent);
    try {
      this.clear();
      _analyticalMethodUids = Collections.synchronizedMap(new HashMap());
      _pkg = new ResultPkg(_connection);
      _pkgLookup = new LookupTblPkg(_connection);
    }        
    catch (Exception e) {
      _transactionLog.logError(e);
    }
  }

  // ---------------------------------------------------------------------
  // Get/Set Methods
  // ---------------------------------------------------------------------
  public void setDataLoggerLineName(String dataLoggerLineName)
      throws WqxFatalException {
      
    _dataLoggerLineName = setValue(dataLoggerLineName);
  }
 

  public String getDataLoggerLineName() {
    return _dataLoggerLineName;
  }


  public void setResultDetectionConditionText(String resultDetectionConditionText)
      throws WqxFatalException {
      
    _resultDetectionConditionText = setValue(resultDetectionConditionText);
  }
  

  public String getResultDetectionConditionText() {
    return _resultDetectionConditionText;
  }


  public void setCharacteristicName(String characteristicName)
      throws WqxFatalException {
      
    _characteristicName = setValue(characteristicName);
  }
  

  public String getCharacteristicName() {
    return _characteristicName;
  }


  public void setResultSampleFractionText(String resultSampleFractionText)
      throws WqxFatalException {
      
    _resultSampleFractionText = setValue(resultSampleFractionText);
  }
  

  public String getResultSampleFractionText() {
    return _resultSampleFractionText;
  }


  public void setResultMeasureValue(String resultMeasureValue)
      throws WqxFatalException {
      
    _resultMeasureValue = setValue(resultMeasureValue);
  }
 

  public String getResultMeasureValue() {
    return _resultMeasureValue;
  }


  public void setResultMeasureUnitCode(String resultMeasureUnitCode)
      throws WqxFatalException {
      
    _resultMeasureUnitCode = setValue(resultMeasureUnitCode);
  }
  

  public String getResultMeasureUnitCode() {
    return _resultMeasureUnitCode;
  }


  public void setResultMeasureQualifierCode(String resultMeasureQualifierCode)
      throws WqxFatalException {
      
    _resultMeasureQualifierCode = setValue(resultMeasureQualifierCode);
  }
  

  public String getResultMeasureQualifierCode() {
    return _resultMeasureQualifierCode;
  }


  public void setResultStatusIdentifier(String resultStatusIdentifier)
      throws WqxFatalException {
      
    _resultStatusIdentifier = setValue(resultStatusIdentifier);
  }


  public String getResultStatusIdentifier() {
    return _resultStatusIdentifier;
  }


  public void setStatisticalBaseCode(String statisticalBaseCode)
      throws WqxFatalException {
      
    _statisticalBaseCode = setValue(statisticalBaseCode);
  }


  public String getStatisticalBaseCode() {
    return _statisticalBaseCode;
  }


  public void setResultValueTypeName(String resultValueTypeName)
      throws WqxFatalException {
      
    _resultValueTypeName = setValue(resultValueTypeName);
  }
  

  public String getResultValueTypeName() {
    return _resultValueTypeName;
  }


  public void setResultWeightBasisText(String resultWeightBasisText)
      throws WqxFatalException {
      
    _resultWeightBasisText = setValue(resultWeightBasisText);
  }
  

  public String getResultWeightBasisText() {
    return _resultWeightBasisText;
  }


  public void setResultTimeBasisText(String resultTimeBasisText)
      throws WqxFatalException {
      
    _resultTimeBasisText = setValue(resultTimeBasisText);
  }
  

  public String getResultTimeBasisText() {
    return _resultTimeBasisText;
  }


  public void setResultTemperatureBasisText(String resultTemperatureBasisText)
      throws WqxFatalException {
      
    _resultTemperatureBasisText = setValue(resultTemperatureBasisText);
  }
  

  public String getResultTemperatureBasisText() {
    return _resultTemperatureBasisText;
  }


  public void setResultParticleSizeBasisText(String resultParticleSizeBasisText)
      throws WqxFatalException {
      
    _resultParticleSizeBasisText = setValue(resultParticleSizeBasisText);
  }
  

  public String getResultParticleSizeBasisText() {
    return _resultParticleSizeBasisText;
  }


  public void setPrecisionValue(String precisionValue)
      throws WqxFatalException {
      
    _precisionValue = setValue(precisionValue);
  }
  

  public String getPrecisionValue() {
    return _precisionValue;
  }


  public void setBiasValue(String biasValue)
      throws WqxFatalException {
      
    _biasValue = setValue(biasValue);
  }
  

  public String getBiasValue() {
    return _biasValue;
  }


  public void setConfidenceIntervalValue(String confidenceIntervalValue)
      throws WqxFatalException {
      
    _confidenceIntervalValue = setValue(confidenceIntervalValue);
  }
  

  public String getConfidenceIntervalValue() {
    return _confidenceIntervalValue;
  }


  public void setUpperConfidenceLimitValue(String upperConfidenceLimitValue)
      throws WqxFatalException {
      
    _upperConfidenceLimitValue = setValue(upperConfidenceLimitValue);
  }
  

  public String getUpperConfidenceLimitValue() {
    return _upperConfidenceLimitValue;
  }


  public void setLowerConfidenceLimitValue(String lowerConfidenceLimitValue)
      throws WqxFatalException {
      
    _lowerConfidenceLimitValue = setValue(lowerConfidenceLimitValue);
  }
 

  public String getLowerConfidenceLimitValue() {
    return _lowerConfidenceLimitValue;
  }


  public void setResultCommentText(String resultCommentText)
      throws WqxFatalException {
      
    _resultCommentText = setValue(resultCommentText);
  }
  

  public String getResultCommentText() {
    return _resultCommentText;
  }


  public void setResultDepthHeightMeasureValue(String resultDepthHeightMeasureValue)
      throws WqxFatalException {
      
    _resultDepthHeightMeasureValue = setValue(resultDepthHeightMeasureValue);
  }
  

  public String getResultDepthHeightMeasureValue() {
    return _resultDepthHeightMeasureValue;
  }


  public void setResultDepthHeightMeasureUnitCode(String resultDepthHeightMeasureUnitCode)
      throws WqxFatalException {
      
    _resultDepthHeightMeasureUnitCode = setValue(resultDepthHeightMeasureUnitCode);
  }
  

  public String getResultDepthHeightMeasureUnitCode() {
    return _resultDepthHeightMeasureUnitCode;
  }


  public void setResultDepthAltitudeReferencePointText(String resultDepthAltitudeReferencePointText)
      throws WqxFatalException {
      
    _resultDepthAltitudeReferencePointText = setValue(resultDepthAltitudeReferencePointText);
  }
  

  public String getResultDepthAltitudeReferencePointText() {
    return _resultDepthAltitudeReferencePointText;
  }


  public void setResultAnalyticalMethodIdentifier(String resultAnalyticalMethodIdentifier)
      throws WqxFatalException {
      
    _resultAnalyticalMethodIdentifier = setValue(resultAnalyticalMethodIdentifier);
  }
  

  public String getResultAnalyticalMethodIdentifier() {
    return _resultAnalyticalMethodIdentifier;
  }


  public void setResultAnalyticalMethodIdentifierContext(String resultAnalyticalMethodIdentifierContext)
      throws WqxFatalException {
      
    _resultAnalyticalMethodIdentifierContext = setValue(resultAnalyticalMethodIdentifierContext);
  }
   

  public String getResultAnalyticalMethodIdentifierContext() {
    return _resultAnalyticalMethodIdentifierContext;
  }


  public void setResultAnalyticalMethodName(String resultAnalyticalMethodName)
      throws WqxFatalException {
      
    _resultAnalyticalMethodName = setValue(resultAnalyticalMethodName);
  }
  

  public String getResultAnalyticalMethodName() {
    return _resultAnalyticalMethodName;
  }


  public void setResultAnalyticalMethodQualifierTypeName(String resultAnalyticalMethodQualifierTypeName)
      throws WqxFatalException {
      
    _resultAnalyticalMethodQualifierTypeName = setValue(resultAnalyticalMethodQualifierTypeName);
  }
  

  public String getResultAnalyticalMethodQualifierTypeName() {
    return _resultAnalyticalMethodQualifierTypeName;
  }


  public void setResultAnalyticalMethodDescriptionText(String resultAnalyticalMethodDescriptionText)
      throws WqxFatalException {
      
    _resultAnalyticalMethodDescriptionText = setValue(resultAnalyticalMethodDescriptionText);
  }
  

  public String getResultAnalyticalMethodDescriptionText() {
    return _resultAnalyticalMethodDescriptionText;
  }


  public void setLaboratoryName(String laboratoryName)
      throws WqxFatalException {
      
    _laboratoryName = setValue(laboratoryName);
  }
  

  public String getLaboratoryName() {
    return _laboratoryName;
  }


  public void setAnalysisStartDate(String analysisStartDate)
      throws WqxFatalException {
      
    if (analysisStartDate == null) {
      _analysisStartDateString = null;
    }
    else {
      _analysisStartDateString = analysisStartDate.trim();
      try {
        _analysisStartDate = Lib.xmlToDate(_analysisStartDateString);
      }
      catch (Exception e) {
        _analysisStartDate = null;
        _transactionLog.logError(e);
      }
    } 
    _dirty = true;
  }
  

  public String getAnalysisStartDate() {
    return _analysisStartDateString;
  }


  public void setAnalysisStartTime(String analysisStartTime)
      throws WqxFatalException {
      
    if (analysisStartTime == null) {
      _analysisStartTimeString = null;
    }
    else {
      _analysisStartTimeString = analysisStartTime.trim();
      try {
        _analysisStartTime = Lib.xmlToTime(_analysisStartTimeString);
      }
      catch (Exception e) {
        _analysisStartTime = null;
        _transactionLog.logError(e);
      }        
    } 
    _dirty = true;
  }
  

  public String getAnalysisStartTime() {
    return _analysisStartTimeString;
  }


  public void setAnalysisStartTimeZoneCode(String analysisStartTimeZoneCode)
      throws WqxFatalException {
      
    _analysisStartTimeZoneCode = setValue(analysisStartTimeZoneCode);
  }
  

  public String getAnalysisStartTimeZoneCode() {
    return _analysisStartTimeZoneCode;
  }


  public void setAnalysisEndDate(String analysisEndDate)
      throws WqxFatalException {
      
    if (analysisEndDate == null) {
      _analysisEndDateString = null;
    }
    else {
      _analysisEndDateString = analysisEndDate.trim();
      try {
        _analysisEndDate = Lib.xmlToDate(_analysisEndDateString);
      }
      catch (Exception e) {
        _analysisEndDate = null;
        _transactionLog.logError(e);
      }  
    } 
    _dirty = true;
  }
  

  public String getAnalysisEndDate() {
    return _analysisEndDateString;
  }


  public void setAnalysisEndTime(String analysisEndTime)
      throws WqxFatalException {
      
    if (analysisEndTime == null) {
      _analysisEndTimeString = null;
    }
    else {
      _analysisEndTimeString = analysisEndTime.trim();
      try {
        _analysisEndTime = Lib.xmlToTime(_analysisEndTimeString);
      }
      catch (Exception e) {
        _analysisEndTime = null;
        _transactionLog.logError(e);
      }
    } 
    _dirty = true;
  }
  

  public String getAnalysisEndTime() {
    return _analysisEndTimeString;
  }


  public void setAnalysisEndTimeZoneCode(String analysisEndTimeZoneCode)
      throws WqxFatalException {
      
    _analysisEndTimeZoneCode = setValue(analysisEndTimeZoneCode);
  }
  

  public String getAnalysisEndTimeZoneCode() {
    return _analysisEndTimeZoneCode;
  }


  public void setResultLaboratoryCommentCode(String resultLaboratoryCommentCode)
      throws WqxFatalException {
      
    _resultLaboratoryCommentCode = setValue(resultLaboratoryCommentCode);
  }
 

  public String getResultLaboratoryCommentCode() {
    return _resultLaboratoryCommentCode;
  }


  public void setDetectionQuantitationLimitTypeNameReported(boolean detectionQuantitationLimitTypeNameReported) {
    _detectionQuantitationLimitTypeNameReported = detectionQuantitationLimitTypeNameReported;
  }


  public boolean isDetectionQuantitationLimitTypeNameReported() {
    return _detectionQuantitationLimitTypeNameReported;
  }


  public void setDetectionQuantitationLimitMeasureValueReported(boolean detectionQuantitationLimitMeasureValueReported) {
    _detectionQuantitationLimitMeasureValueReported = detectionQuantitationLimitMeasureValueReported;
  }


  public boolean isDetectionQuantitationLimitMeasureValueReported() {
    return _detectionQuantitationLimitMeasureValueReported;
  }
  
  
  // ---------------------------------------------------------------------
  // Methods
  // ---------------------------------------------------------------------

  // Save this object's values to the database
  public void save() 
      throws Exception {
    
    try {
      if (_dirty) {
        // analytical methods are often repeated so see if we already have the UID in our collection
        
        _analyticalMethodUid = (String) _analyticalMethodUids.get(_resultAnalyticalMethodIdentifier + _resultAnalyticalMethodIdentifierContext);
        if (_analyticalMethodUid == null) {
          try {    
            _analyticalMethodUid = _pkgLookup.getAnlmthUid(
              _context,
              _resultAnalyticalMethodIdentifierContext,
              _resultAnalyticalMethodIdentifier,
              _resultAnalyticalMethodName,
              _resultAnalyticalMethodDescriptionText,
              _resultAnalyticalMethodQualifierTypeName);
            
            // NEED TO FIX THIS
            /* The collection of Analytical Methods needs to have a success_yn equivalent so that if we rollback the inserts to the analytical method table then we can also remove them from the collection in java (otherwise we continue to try to use the anlmth_uid for one that has been rolled back, which causes foreign key exceptions). 
          
            // add this analytical method UID to the collection
            _analyticalMethodUids.put(
              _resultAnalyticalMethodIdentifier + _resultAnalyticalMethodIdentifierContext, 
              _analyticalMethodUid);
            */
          }
          catch(Exception e) {
            _transactionLog.logError(e);
          }             
        }
        //Business rule to check Data Logger Line name when activity type is Loggger.
        if ((((Activity) _parent).getActivityTypeCode().indexOf("Logger") > 0) && _dataLoggerLineName == null) {
          throw new Exception("Data Logger Line Name is required when Activity Type contains the word Logger");
        }
        try {          
          _uid = _pkg.insertRow(
            _context, 
            _parent.getUid(),
            _characteristicName,
            _resultDepthHeightMeasureUnitCode,
            _resultMeasureUnitCode,
            _resultDetectionConditionText,
            _analyticalMethodUid,
            _biasValue,
            _resultCommentText,
            _dataLoggerLineName,
            _resultDepthHeightMeasureValue,
            _resultDepthAltitudeReferencePointText,
            _analysisStartDate,
            _analysisStartTime,
            _analysisEndDate,
            _analysisEndTime,
            _analysisStartTimeZoneCode,
            _analysisEndTimeZoneCode,
            _laboratoryName,
            _resultParticleSizeBasisText,
            _resultMeasureValue,
            _confidenceIntervalValue,
            _precisionValue,
            _lowerConfidenceLimitValue,
            _upperConfidenceLimitValue,
            _resultLaboratoryCommentCode,
            _resultMeasureQualifierCode,
            _statisticalBaseCode, 
            _resultStatusIdentifier,
            _resultTimeBasisText, 
            _resultTemperatureBasisText, 
            _resultValueTypeName, 
            _resultWeightBasisText, 
            _resultSampleFractionText);
        }
        catch (SQLException e) {
          _transactionLog.logError(e);
        }
      }
    }
    catch (Exception e) {
      _transactionLog.logError(e);
    }
    finally {
      super.save();
    }
  }
  
  
  // Delete all results relating to a specific Activity
  public void deleteAllForParentActivity()
      throws WqxFatalException {
      
    try {
      _pkg.deleteRowsByActUid(
        _context,
        _parent.getUid());
    }
    catch(SQLException e) {
      _transactionLog.logError(e);
    }
  }
  
  
  // Clear this object's values to reuse it for a new one.
  public void clear()
      throws WqxFatalException {
      
    // These rules can only be checked after children are saved
    // So before clearing, check these rules
    try {
      if (_count > 0) {
        if (_resultDetectionConditionText != null) {
          if (_resultDetectionConditionText.indexOf("Quantification") > 0
              && !_detectionQuantitationLimitTypeNameReported) {
            _transactionLog.logError(new WqxException(
              "When ResultDetectionConditionText contains the word 'Quantification', DetectionQuantitationLimitTypeName must be reported.",
              _context));
          }
          if (_resultDetectionConditionText.equals("Not Detected")
              && (!_detectionQuantitationLimitTypeNameReported || !_detectionQuantitationLimitMeasureValueReported)) {
            _transactionLog.logError(new WqxException(
              "When ResultDetectionConditionText is 'Not Detected', DetectionQuantitationLimitTypeName and DetectionQuantitationLimitMeasure must be reported.",
              _context));  
          } 
        }
      }
    }
    catch (Exception e) {
      _transactionLog.logError(e);
    }
    // now clear the object
    _dataLoggerLineName = null;
    _resultDetectionConditionText = null;
    _characteristicName = null;
    _resultSampleFractionText = null;
    _resultMeasureValue = null;
    _resultMeasureUnitCode = null;
    _resultMeasureQualifierCode = null;
    _resultStatusIdentifier = null;
    _statisticalBaseCode = null;
    _resultValueTypeName = null;
    _resultWeightBasisText = null;
    _resultTimeBasisText = null;
    _resultTemperatureBasisText = null;
    _resultParticleSizeBasisText = null;
    _precisionValue = null;
    _biasValue = null;
    _confidenceIntervalValue = null;
    _upperConfidenceLimitValue = null;
    _lowerConfidenceLimitValue = null;
    _resultCommentText = null;
    _resultDepthHeightMeasureValue = null;
    _resultDepthHeightMeasureUnitCode = null;
    _resultDepthAltitudeReferencePointText = null;
    _resultAnalyticalMethodIdentifier = null;
    _resultAnalyticalMethodIdentifierContext = null;
    _resultAnalyticalMethodName = null;
    _resultAnalyticalMethodQualifierTypeName = null;
    _resultAnalyticalMethodDescriptionText = null;
    _laboratoryName = null;
    _analysisStartDateString = null;
    _analysisStartDate = null;
    _analysisStartTimeString = null;
    _analysisStartTime = null;
    _analysisStartTimeZoneCode = null;
    _analysisEndDateString = null;
    _analysisEndDate = null;
    _analysisEndTimeString = null;
    _analysisEndTime = null;
    _analysisEndTimeZoneCode = null;
    _resultLaboratoryCommentCode = null;
    _analyticalMethodUid = null;
    _detectionQuantitationLimitTypeNameReported = false;
    _detectionQuantitationLimitMeasureValueReported = false;
    super.clear();
  }  

}

 