package gov.epa.wqx.node;

import java.sql.SQLException;

public class ResultDetectQuantLimit extends SchemaComponent {

  // ---------------------------------------------------------------------
  // Private/Protected Variables
  // ---------------------------------------------------------------------
  private ResultDetectQuantLimitPkg _pkg;
  
  private String _detectionQuantitationLimitTypeName;
  private String _detectionQuantitationLimitMeasureValue;
  private String _detectionQuantitationLimitMeasureUnitCode;
  
  // ---------------------------------------------------------------------
  // Constructors
  // ---------------------------------------------------------------------
  
  public ResultDetectQuantLimit(SchemaComponent parent)
      throws WqxFatalException {
      
    super(parent);
    try {
      this.clear();
      _pkg = new ResultDetectQuantLimitPkg(_connection);
    }
    catch(Exception e) {
      _transactionLog.logError(e);
    }
  }

  // ---------------------------------------------------------------------
  // Get/Set Methods
  // ---------------------------------------------------------------------
  
  public void setDetectionQuantitationLimitTypeName(String detectionQuantitationLimitTypeName)
      throws WqxFatalException {
      
    _detectionQuantitationLimitTypeName = setValue(detectionQuantitationLimitTypeName);
    if (!detectionQuantitationLimitTypeName.equals("")) {
      ((Result) _parent).setDetectionQuantitationLimitTypeNameReported(true);
    }
  }
  

  public String getDetectionQuantitationLimitTypeName() {
    return _detectionQuantitationLimitTypeName;
  }


  public void setDetectionQuantitationLimitMeasureValue(String detectionQuantitationLimitMeasureValue)
      throws WqxFatalException {
      
    _detectionQuantitationLimitMeasureValue = setValue(detectionQuantitationLimitMeasureValue);
    if (!detectionQuantitationLimitMeasureValue.equals("")) {
      ((Result) _parent).setDetectionQuantitationLimitMeasureValueReported(true);
    }
  }
  

  public String getDetectionQuantitationLimitMeasureValue() {
    return _detectionQuantitationLimitMeasureValue;
  }


  public void setDetectionQuantitationLimitMeasureUnitCode(String detectionQuantitationLimitMeasureUnitCode)
      throws WqxFatalException {
      
    _detectionQuantitationLimitMeasureUnitCode = setValue(detectionQuantitationLimitMeasureUnitCode);
  }
 

  public String getDetectionQuantitationLimitMeasureUnitCode() {
    return _detectionQuantitationLimitMeasureUnitCode;
  }
  
  
  // ---------------------------------------------------------------------
  // Methods
  // ---------------------------------------------------------------------
  
  // Save this object's values to the database
  public void save()
      throws Exception {
    
    try {
      if (_dirty) {
        try {
          _uid = _pkg.insertRow(
            _context, 
            _detectionQuantitationLimitTypeName,
            _detectionQuantitationLimitMeasureUnitCode,
            _detectionQuantitationLimitMeasureValue,
            _parent.getUid());              
        }
        catch(SQLException e) {
          _transactionLog.logError(e);  
        }
      }
    }
    catch (Exception e) {
      _transactionLog.logError(e);
    }
    finally {
      super.save();
    }
  }
  
  
  // Clear this object's values to reuse it for a new one.
  public void clear() 
      throws WqxFatalException {
      
    _detectionQuantitationLimitTypeName = null;
    _detectionQuantitationLimitMeasureValue = null;
    _detectionQuantitationLimitMeasureUnitCode = null;
    super.clear();
  }
}