package gov.epa.wqx.node;

import java.sql.SQLException;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleTypes;

public class ResultDetectQuantLimitPkg {

  private OracleConnection _connection = null;
  private OracleCallableStatement _csDeleteRow;
  private OracleCallableStatement _csDeleteRowByResUid;
  private OracleCallableStatement _csInsertRow;

  // constructor  
  public ResultDetectQuantLimitPkg (
      OracleConnection connection) 
      
      throws SQLException {
      
    // make sure we're connected
    if (connection == null)
      throw new SQLException("Connection is null");
    else if(connection.isClosed())
      throw new SQLException("Connection is closed");
    _connection = connection;

    // DELETE ROW
    _csDeleteRow = (OracleCallableStatement) _connection.prepareCall(
      "{call result_detect_quant_limit_pkg.delete_row(?, ?)}");
    _csDeleteRow.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csDeleteRow.defineParameterType(2, OracleTypes.NUMBER, 20); // p_rdqlmt_uid

    // DELETE ROW BY RES UID
    _csDeleteRowByResUid = (OracleCallableStatement) _connection.prepareCall(
      "{call result_detect_quant_limit_pkg.delete_row_by_res_uid(?, ?)}");
    _csDeleteRowByResUid.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csDeleteRowByResUid.defineParameterType(2, OracleTypes.NUMBER, 20); // p_res_uid

    // INSERT ROW
    _csInsertRow = (OracleCallableStatement) _connection.prepareCall(
      "{call result_detect_quant_limit_pkg.insert_row(?, ?, ?, ?, ?, ?)}");
    _csInsertRow.defineParameterType(1, OracleTypes.VARCHAR, 500); // p_context
    _csInsertRow.defineParameterType(2, OracleTypes.VARCHAR, 35); // p_dqltyp_name
    _csInsertRow.defineParameterType(3, OracleTypes.VARCHAR, 12); // p_msunt_cd
    _csInsertRow.defineParameterType(4, OracleTypes.VARCHAR, 12); // p_rdqlmt_measure
    _csInsertRow.defineParameterType(5, OracleTypes.NUMBER, 20); // p_res_uid
    _csInsertRow.registerOutParameter(6, OracleTypes.NUMBER, 20); // p_rdqlmt_uid
  }


  public void deleteRow (  
      String context,
      String rdqlmtUid)

      throws SQLException {

    // set parameter values and call procedure
    _csDeleteRow.setString(1, context);
    _csDeleteRow.setString(2, rdqlmtUid);
    _csDeleteRow.execute();
  }


  public void deleteRowByResUid (  
      String context,
      String resUid)

      throws SQLException {

    // set parameter values and call procedure
    _csDeleteRowByResUid.setString(1, context);
    _csDeleteRowByResUid.setString(2, resUid);
    _csDeleteRowByResUid.execute();
  }


  public String insertRow (  
      String context,
      String dqltypName,
      String msuntCd,
      String rdqlmtMeasure,
      String resUid)

      throws SQLException {

    // set parameter values and call procedure
    _csInsertRow.setString(1, context);
    _csInsertRow.setString(2, dqltypName);
    _csInsertRow.setString(3, msuntCd);
    _csInsertRow.setString(4, rdqlmtMeasure);
    _csInsertRow.setString(5, resUid);
    _csInsertRow.execute();
    // get out parameters and/or return value
    return _csInsertRow.getString(6);
  }

}