package gov.epa.wqx.node;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;

public class ResultLabSamplePrep extends SchemaComponent {
  
  // ---------------------------------------------------------------------
  // Private/Protected Variables
  // ---------------------------------------------------------------------
  private ResultLabSamplePrepPkg _pkg;
  
  private String _labSamplePreparationMethodIdentifier;
  private String _labSamplePreparationMethodIdentifierContext;
  private String _labSamplePreparationMethodName;
  private String _labSamplePreparationMethodQualifierTypeName;
  private String _labSamplePreparationMethodDescriptionText;
  private String _preparationStartDateString;
  private Date   _preparationStartDate;
  private String _preparationStartTimeString;
  private Time   _preparationStartTime;
  private String _preparationStartTimeZoneCode;
  private String _preparationEndDateString;
  private Date   _preparationEndDate;
  private String _preparationEndTimeString;
  private Time   _preparationEndTime;
  private String _preparationEndTimeZoneCode;
  
  // ---------------------------------------------------------------------
  // Constructors
  // ---------------------------------------------------------------------
  public ResultLabSamplePrep(SchemaComponent parent)
      throws WqxFatalException {
      
    super(parent);
    try {
      this.clear();
      _pkg = new ResultLabSamplePrepPkg(_connection);
    }
    catch(Exception e) {
      _transactionLog.logError(e);
    }
  }
  
  // ---------------------------------------------------------------------
  // Get/Set Methods
  // ---------------------------------------------------------------------
  
  public void setLabSamplePreparationMethodIdentifier(String labSamplePreparationMethodIdentifier)
      throws WqxFatalException {
      
    _labSamplePreparationMethodIdentifier = setValue(labSamplePreparationMethodIdentifier);
  }
  

  public String getLabSamplePreparationMethodIdentifier() {
    return _labSamplePreparationMethodIdentifier;
  }


  public void setLabSamplePreparationMethodIdentifierContext(String labSamplePreparationMethodIdentifierContext)
      throws WqxFatalException {
      
    _labSamplePreparationMethodIdentifierContext = setValue(labSamplePreparationMethodIdentifierContext);
  }
  

  public String getLabSamplePreparationMethodIdentifierContext() {
    return _labSamplePreparationMethodIdentifierContext;
  }


  public void setLabSamplePreparationMethodName(String labSamplePreparationMethodName)
      throws WqxFatalException {
      
    _labSamplePreparationMethodName = setValue(labSamplePreparationMethodName);
  }
  

  public String getLabSamplePreparationMethodName() {
    return _labSamplePreparationMethodName;
  }


  public void setLabSamplePreparationMethodQualifierTypeName(String labSamplePreparationMethodQualifierTypeName)
      throws WqxFatalException {
      
    _labSamplePreparationMethodQualifierTypeName = setValue(labSamplePreparationMethodQualifierTypeName);
  }
  

  public String getLabSamplePreparationMethodQualifierTypeName() {
    return _labSamplePreparationMethodQualifierTypeName;
  }


  public void setLabSamplePreparationMethodDescriptionText(String labSamplePreparationMethodDescriptionText)
      throws WqxFatalException {
      
    _labSamplePreparationMethodDescriptionText = setValue(labSamplePreparationMethodDescriptionText);
  }
  

  public String getLabSamplePreparationMethodDescriptionText() {
    return _labSamplePreparationMethodDescriptionText;
  }


  public void setPreparationStartDate(String preparationStartDate)
      throws WqxFatalException {
      
    if (preparationStartDate == null) {
      _preparationStartDateString = null;
      _preparationStartDate = null;
    }
    else {
      _preparationStartDateString = preparationStartDate.trim();
      try {
        _preparationStartDate = Lib.xmlToDate(_preparationStartDateString);
      }
      catch (Exception e) {
        _preparationStartDate = null;
        _transactionLog.logError(e);
      }
    } 
    _dirty = true;
  }
  

  public String getPreparationStartDate() {
    return _preparationStartDateString;
  }


  public void setPreparationStartTime(String preparationStartTime)
      throws WqxFatalException {
      
    if (preparationStartTime == null) {
      _preparationStartTimeString = null;
      _preparationStartTime = null;
    }
    else {
      _preparationStartTimeString = preparationStartTime.trim();
      try {
        _preparationStartTime = Lib.xmlToTime(_preparationStartTimeString);
      }
      catch (Exception e) {
        _preparationStartTime = null;
        _transactionLog.logError(e);
      }
    } 
    _dirty = true;
  }
  

  public String getPreparationStartTime() {
    return _preparationStartTimeString;
  }


  public void setPreparationStartTimeZoneCode(String preparationStartTimeZoneCode)
      throws WqxFatalException {
      
    _preparationStartTimeZoneCode = setValue(preparationStartTimeZoneCode);
  }
  

  public String getPreparationStartTimeZoneCode() {
    return _preparationStartTimeZoneCode;
  }


  public void setPreparationEndDate(String preparationEndDate)
      throws WqxFatalException {
      
    if (preparationEndDate == null) {
      _preparationEndDateString = null;
      _preparationEndDate = null;
    }
    else {
      _preparationEndDateString = preparationEndDate.trim();
      try {
        _preparationEndDate = Lib.xmlToDate(_preparationEndDateString);
      }
      catch (Exception e) {
        _preparationEndDate = null;
        _transactionLog.logError(e);
      }
    } 
    _dirty = true;
  }
  

  public String getPreparationEndDate() {
    return _preparationEndDateString;
  }


  public void setPreparationEndTime(String preparationEndTime)
      throws WqxFatalException {
      
    if (preparationEndTime == null) {
      _preparationEndTimeString = null;
      _preparationEndTime = null;
    }
    else {
      _preparationEndTimeString = preparationEndTime.trim();
      try {
        _preparationEndTime = Lib.xmlToTime(_preparationEndTimeString);
      }
      catch (Exception e) {
        _preparationEndTime = null;
        _transactionLog.logError(e);
      }
    } 
    _dirty = true;
  }
  

  public String getPreparationEndTime() {
    return _preparationEndTimeString;
  }


  public void setPreparationEndTimeZoneCode(String preparationEndTimeZoneCode)
      throws WqxFatalException {
      
    _preparationEndTimeZoneCode = setValue(preparationEndTimeZoneCode);
  }
  

  public String getPreparationEndTimeZoneCode() {
    return _preparationEndTimeZoneCode;
  }

  
  // ---------------------------------------------------------------------
  // Methods
  // ---------------------------------------------------------------------
  
  // Save this object's values to the database
  public void save() 
      throws Exception {
    if (_dirty) {
      try {
        _uid = _pkg.insertRow(
          _context,
          _parent.getUid(),
          _preparationEndDate,
          _preparationEndTime,
          _labSamplePreparationMethodIdentifierContext,
          _labSamplePreparationMethodDescriptionText,
          _labSamplePreparationMethodIdentifier,
          _labSamplePreparationMethodName,
          _labSamplePreparationMethodQualifierTypeName,
          _preparationStartDate,
          _preparationStartTime,
          _preparationEndTimeZoneCode,
          _preparationStartTimeZoneCode);
      }
      catch(SQLException e) {
        _transactionLog.logError(e);
      }
    }
    super.save();
  }
  
  
  // Clear this object's values to reuse it for a new one.
  public void clear()
      throws WqxFatalException {
      
    _preparationEndDateString = null;
    _preparationEndDate = null;
    _preparationEndTimeString = null;
    _preparationEndTime = null;
    _labSamplePreparationMethodIdentifierContext = null;
    _labSamplePreparationMethodDescriptionText = null;
    _labSamplePreparationMethodIdentifier = null;
    _labSamplePreparationMethodName = null;
    _labSamplePreparationMethodQualifierTypeName = null;
    _preparationStartDateString = null;
    _preparationStartDate = null;
    _preparationStartTimeString = null;
    _preparationStartTime = null;
    _preparationEndTimeZoneCode = null;
    _preparationStartTimeZoneCode = null;
    super.clear();
  }  
  
}
